#/bin/csh -f

set n = (1k 2k 4k 8k 16k 32k 64k 128k 256k 512k 1m 2m 4m)
set nn = (1024 2048 4096 8192 16384 32768 65536 131072 262144 524288 1048576 2097152 4194304)
set infile = (pl1ka.pob pl2ka.pob pl4ka.pob pl8ka.pob pl16ka.pob pl32ka.pob pl64ka.pob pl128ka.pob pl256ka.pob pl512ka.pob pl1Ma.pob pl2Ma.pob pl4Ma.pob)
set outroot = ./log
set ncrit = 300 # Xeon Core2Quad (E5345/2.66GHz), Supermicro X7DBE-X(5000P)
set indir = /home2/kawai/init/pob

foreach p (1)
  set i = 1
  while (${i} <= ${#n})
    set out = ${outroot}/p${p}${n[${i}]}
    echo '----------' tree on host with phantom, hm${n[${i}]} p${p} '----------'
    ./vtc_phantom -c -t 0.5 -T 0.1 -d 0.1 -p ${p} -n ${ncrit} -i $indir/${infile[${i}]} -g -G >& ${out}
    @ i++
  end # i
end # p


#  tree on GRAPE no force
foreach p (1)
  set i = 1
  while (${i} <= ${#n})
    set out = ${outroot}/p${p}${n[${i}]}noforce
    echo '----------' tree on host with phantom, hm${n[${i}]} p${p} 'no force ----------'
    ./vtc_phantom_noforce -c -t 0.5 -T 0.1 -d 0.1 -p ${p} -n ${ncrit} -i $indir/${infile[${i}]} -g -G >& ${out}
    @ i++
  end # i
end # p


#  direct on host
set n = (1k 2k 4k 8k 16k 32k 64k 128k 256k 512k 1m)

set p = 1
set i = 1
while (${i} <= ${#n})
  set out = ${outroot}/direct${n[${i}]}
  echo '----------' direct on host with phantom, hm${n[${i}]} p${p} '----------'
  ./vtc_phantom_direct -c -T 0.1 -d 0.1 -I ${nn[${i}]} -G >& ${out}
  @ i++
end # i
