#/bin/csh -f

set n = (1k 2k 4k 8k 16k 32k 64k 128k 256k 512k 1m 2m)
set nn = (1024 2048 4096 8192 16384 32768 65536 131072 262144 524288 1048576 2097152 4194304)
set infile = (pl1ka.pob pl2ka.pob pl4ka.pob pl8ka.pob pl16ka.pob pl32ka.pob pl64ka.pob pl128ka.pob pl256ka.pob pl512ka.pob pl1Ma.pob pl2Ma.pob pl4Ma.pob)
set outroot = ./log
set ncrit = 30 # Core2Duo P5WDG, ASUS P5WDG2 WS Pro
set indir = /home2/kawai/init/pob

foreach p (1)
  set i = 1
  while (${i} <= ${#n})
    set out = ${outroot}/p${p}host${n[${i}]}
    echo '----------' tree on host, hm${n[${i}]} p${p} '----------'
#    ./vtc -c -t 0.5 -T 0.1 -d 0.1 -p ${p} -n ${ncrit} -I ${nn[${i}]} >& ${out}
    ./vtc -c -t 0.5 -T 0.1 -d 0.1 -p ${p} -n ${ncrit} -i $indir/${infile[${i}]} -g >& ${out}
    @ i++
  end # i
end # p

#  direct on host

set n = (1k 2k 4k 8k 16k 32k 64k 128k)

set p = 1
set i = 1
while (${i} <= ${#n})
  set out = ${outroot}/directhost${n[${i}]}
  echo '----------' direct on host, hm${n[${i}]} p${p} '----------'
  ./vtc_direct -c -T 0.1 -d 0.1 -I ${nn[${i}]} >& ${out}
  @ i++
end # i
