#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include "hibutil.h"
#include "g5util.h"

void
hold_grape(void)
{
    g5_open();
}

void
free_grape(void)
{
    g5_close();
}

void
scale_grape(double xscale, double mscale)
{
    if (xscale < 0.0) {
	xscale *= -1.0;
    }
    g5_set_range(-xscale, xscale, mscale);
}

// #define CUTOFF

void
force_grape(double (*x)[3], double *m, double eps2,
	    double (*a)[3], double *pot, int n)
{
  int i, j, nn, njmax,k;
  int nii;
  static int index[10000];
  static double rnnb2[10000];
  static int innb[10000];  
  double ddum,eta;

  for(i=0;i<n;i++) index[i] = i;
#if 0
    fprintf(stderr, "x[0]: %5.3f %5.3f %5.3f\n",
	    x[0][0], x[0][1], x[0][2]);
    fprintf(stderr, "x[1]: %5.3f %5.3f %5.3f\n",
	    x[1][0], x[1][1], x[1][2]);
    fprintf(stderr, "m[0]: %5.3f\n", m[0]);
    fprintf(stderr, "m[1]: %5.3f\n", m[1]);
    fprintf(stderr, "eps2: %5.3f\n", eps2);
    fprintf(stderr, "n: %d\n", n);
#endif

#ifdef CUTOFF
    eta = 0.25;
    g5_set_cutoff_table(&ddum,ddum,ddum,&ddum,ddum,ddum);
    g5_set_eta(eta);
#endif

    /* send i particle softening */
    g5_set_eps2_to_all(eps2);

    /* send j particle */
    g5n_set_jp(0, n, m, x, index);

    /* set N */
    g5_set_n(n);

    /* send i, run, and then get force */
    nii = g5_get_number_of_pipelines();

#if 0
    for (i = 0; i < n; i += nii) {
	if ((i + nii) > n) {
	    nn = n - i;
	}
	else {
	    nn = nii;
	}
	g5_set_xi(nn, (double (*)[3])x[i]);
	g5_set_index(nn, index+i);	
	g5_run();
        g5n_get_force(nn, (double (*)[3])a[i], pot+i, rnnb2+i, innb+i);
    }
#else
    g5n_calculate_force_on_x(x,index,a,pot,rnnb2,innb,n);
#endif

    if(eps2!=0.0){
      double epsinv;
      epsinv = 1.0/sqrt(eps2);
      for(i=0;i<n;i++) pot[i] += m[i] * epsinv;
    }

#if 1
    for(i=0;i<n;i++){
      double minr2,tmpr2,r2error;
      int minindex;
      minr2 = 10000000000;
      for(j=0;j<n;j++){
	if(j!=i){
	  tmpr2 = (x[i][0]-x[j][0])*(x[i][0]-x[j][0])
	    +(x[i][1]-x[j][1])*(x[i][1]-x[j][1])
	    +(x[i][2]-x[j][2])*(x[i][2]-x[j][2])+eps2;
	  if(tmpr2 < minr2){
	    minr2 = tmpr2;
	    minindex = j;
	  }
	}
      }
      r2error = sqrt(minr2)-sqrt(rnnb2[i]);
      r2error = sqrt(r2error*r2error);
      if((minindex!=innb[i])||(r2error>1e-6)){
        printf("i %d host %d %g  grape %d %g %g\n",i,minindex,sqrt(minr2),innb[i],sqrt(rnnb2[i]),r2error);
      }
    }
#endif


}
