#include <stdlib.h>
#include "g6util.h"
#include "./sticky.h"

#ifndef NNBTEST
#define NNBTEST 0
#endif

void force_grape(REAL x[NMAX][DIM],
                 REAL v[NMAX][DIM],
                 REAL m[NMAX],
                 REAL t[NMAX],
                 REAL eps,
                 REAL a[NMAX][DIM],
                 REAL adot[NMAX][DIM],
                 REAL pot[NMAX],
                 int n)
{
    int i,j,d;
    REAL a2by18[DIM];
    REAL a1by6[DIM];
    REAL aby2[DIM];
    REAL dtj,eps2;
    int nn,ii,index,npipe;
    REAL h2,epsinv;
    static int flag[128];
    static int nnbindex[NMAX];	
    REAL time;
    int clusterid=0;
    int ng = 0;
	
    dtj = 1.0;
    for(d=0;d<DIM;d++){
        a2by18[d] = 0.0;
        a1by6[d] = 0.0;
        aby2[d] = 0.0;
    }
    time = 0.0;
    eps2 = eps*eps;
    h2 = 0.0;

    npipe = g6_npipes();

    for(i=0;i<n;i++){
#if PRIMITIVEAPI
        g6_set_j_particle(clusterid,i, i, t[i], dtj, m[i], a2by18, a1by6, aby2, v[i], x[i]);
#else
        g6_set_j_particle_all(i, i, t[i], dtj, m[i], a2by18, a1by6, aby2, v[i], x[i]);
#endif
    }

#if PRIMITIVEAPI
    g6_set_ti(clusterid, t[0]);
#else
    g6_set_ti_all(t[0]);
#endif

    for(i=0;i<n;i+=npipe){
        double jfactor=6,ffactor=0;

        nn = npipe;
        if(n-i<npipe) nn= n - i; 

        for(ii=0;ii<nn;ii++){
            index = i+ii; 
#if PRIMITIVEAPI
            g6_set_i_particle_scales_from_real_value(clusterid, ii,a[index],adot[index],pot[index],jfactor,ffactor);
            g6_set_i_particle(clusterid, ii, index, x[index], v[index], eps2, h2);
#else
            g6_set_i_particle_scales_from_real_value_all(ii,a[index],adot[index],pot[index],jfactor,ffactor);
            g6_set_i_particle_all(ii, index, x[index], v[index], eps2, h2);
#endif
        }
#if PRIMITIVEAPI
        g6_set_nip(clusterid,nn);
        g6_set_njp(clusterid,n);
#else
        g6_set_nip_all(nn);
        g6_set_njp_all(n);
#endif

#if !NNBTEST
#if PRIMITIVEAPI
        g6_get_force(clusterid, a+i, adot+i, pot+i, flag);
#else
        g6_get_force_all(a+i, adot+i, pot+i, flag);
#endif
#endif

#if NNBTEST
#if PRIMITIVEAPI
        g6_get_force_etc(clusterid,a+i, adot+i, pot+i, nnbindex+i, flag);
#else
        g6_get_force_etc_all(a+i, adot+i, pot+i, nnbindex+i, flag);
#endif
        for(ii=0;ii<nn;ii++){
	    double minr2,tmpr2;
            int minindex;
            minr2 = 10000000000;
	    for(j=0;j<n;j++){
                if(j!=(i+ii)){
                    tmpr2 = (x[i+ii][0]-x[j][0])*(x[i+ii][0]-x[j][0])
                        +(x[i+ii][1]-x[j][1])*(x[i+ii][1]-x[j][1])
                        +(x[i+ii][2]-x[j][2])*(x[i+ii][2]-x[j][2]);
                    if(tmpr2 < minr2){
                        minr2 = tmpr2;
                        minindex = j;
                    }
                }
            }
	    if(minindex!=nnbindex[i+ii]){
                ng++;
                printf("nnb i %d minindex %d nnbindex %d\n",i+ii,minindex,nnbindex[i+ii]);
            }
            else {
                printf("nnb i %d  OK.\n", i+ii);
            }
        }
        if (ng) {
            fprintf(stderr, "%d nnb error%s found. abort.\n", ng, ng > 1 ? "s" : "");
            exit(1);
        }
#endif
    }
}

void set_particle_on_grape(REAL x[NMAX][DIM],
                           REAL v[NMAX][DIM],
                           REAL a[NMAX][DIM],
                           REAL adot[NMAX][DIM],
                           REAL m[NMAX],
                           REAL t[NMAX],
                           REAL dt[NMAX],
                           int n)
{
    int i,k;
    REAL over2,over6;
    REAL a2by18[DIM];
    REAL a1by6[DIM];
    REAL aby2[DIM];
    int clusterid=0;
	
    over2 = 1.0/2.0;
    over6 = 1.0/6.0; 

    for(i=0;i<n;i++){
        for(k=0;k<DIM;k++){
	    aby2[k] = over2*a[i][k];
	    a1by6[k] = over6*adot[i][k];
	    a2by18[k] = 0.0;
        }
#if PRIMITIVEAPI
        g6_set_j_particle(clusterid,i,i,t[i],dt[i],m[i], a2by18, a1by6, aby2, v[i], x[i]);
#else
        g6_set_j_particle_all(i,i,t[i],dt[i],m[i], a2by18, a1by6, aby2, v[i], x[i]);
#endif
    }
}
