c     
c     input initial particle distribution from 'infile' (NEMO ASCII format)
c     output calculation result to 'outfile' (also in NEMO ASCII format)
c     
      program direct_summation

      include 'direct.inc'
      real*8 mj(NJMAX), xj(3, NJMAX), vj(3, NJMAX)
      real*8 a(3, NJMAX), p(NJMAX)
      real*8 xmax, xmin, mmin
      real*8 eps, dt, endt
      real*8 e, e0, ke, pe
      integer i, j, k
      integer nj
      integer nstep, step

      eps = 0.02
      dt = 0.01
      endt = 1.0
      time = 0.0
      nstep = endt/dt
      xmax = 10.0
      xmin = -10.0
      
      call readnbody(nj, mj, xj, vj)
      mmin = mj(1)
      call g5_open()
      call g5_set_range(xmin, xmax, mmin)
      call calc_gravity(mj, xj, vj, eps, a, p, nj)
      call energy(mj, vj, p, nj, ke, pe)
      e0 = ke+pe
      do step=1,nstep /* main loop */
	 call push_velocity(vj, a, 0.5*dt, nj)
	 call push_position(xj, vj, a, dt, nj)
	 time = time + dt
	 call calc_gravity(mj, xj, vj, eps, a, p, nj)
	 call push_velocity(vj, a, 0.5*dt, nj)

         if (mod(step, (nstep/10)) .eq. 0) then
            call energy(mj, vj, p, nj, ke, pe)
            e = ke+pe
            write(*,*)'step: ',step, ' time: ', time
            write(*,*)'e: ', e, 'de: ', e-e0
            write(*,*)'ke: ', ke, 'pe: ', pe
            write(*,*)'ke/pe: ', ke/pe
            write(*,*)
         endif
      enddo
      call g5_close()
      call writenbody(nj, mj, xj, vj)
      end


      subroutine calc_gravity(mj, xj, vj, eps, a, p, nj)

      include 'direct.inc'
      real*8 mj(NJMAX)
      real*8 xj(3, NJMAX), vj(3, NJMAX)
      real*8 a(3, NJMAX), p(NJMAX)
      real*8 eps, epsinv
      integer nj

      call g5_set_jp(0, nj, mj, xj)
      call g5_set_eps2_to_all(eps * eps)
      call g5_set_n(nj)
      call g5_calculate_force_on_x(xj, a, p, nj)
      end

      subroutine push_velocity(vj, a, dt, nj)

      include 'direct.inc'
      real*8 vj(3, NJMAX)
      real*8 a(3, NJMAX)
      real*8 dt
      integer nj
      integer j, k

      do j=1,nj
	do k=1,3
	   vj(k,j) = vj(k,j) + dt*a(k,j)
	enddo
      enddo
      end

      subroutine push_position(xj,vj,a,dt,nj)

      include 'direct.inc'
      real*8 xj(3, NJMAX)
      real*8 vj(3, NJMAX)
      real*8 a(3, NJMAX)
      real*8 dt
      integer nj
      integer j, k

      do j=1, nj
	 do k=1,3
	    xj(k,j) = xj(k,j) + dt*vj(k,j)
	 enddo
      enddo
      end

      subroutine energy(mj, vj, p, nj, ke, pe)

      include 'direct.inc'
      real*8 mj(NJMAX), vj(3, NJMAX), p(NJMAX)
      integer nj
      real*8 ke, pe
      integer i, k

      pe = 0
      ke = 0
      do i=1, nj
	 pe = pe + mj(i) * p(i)
	 do k=1,3
	    ke = ke + 0.5 * mj(i) * vj(k,i) * vj(k,i)
	 enddo
      enddo
      pe = pe / 2.0

      end

      subroutine readnbody(nj, mj, xj, vj)

      include 'direct.inc'
      integer nj
      real*8 mj(NJMAX), xj(3, NJMAX), vj(3, NJMAX)
      integer i, dummy
      real*8 ddummy

      open(unit=11,file='pl8k',status='old')
      read(11,*) nj
      read(11,*) dummy
      read(11,*) ddummy
      write(*,*) 'nj: ', nj
      do i=1,nj
	 read(11,*)mj(i)
      enddo
      do i=1,nj
	 read(11,*)(xj(k,i),k=1,3)
      enddo
      do i=1,nj
	 read(11,*)(vj(k,i),k=1,3)
      enddo

      end

      subroutine writenbody(nj, mj, xj, vj)

      include 'direct.inc'
      integer nj
      real*8 mj(NJMAX), xj(3, NJMAX), vj(3, NJMAX)
      integer i, dummy

      open(unit=12,file='outfile',status='new')
      write(12,*) nj
      write(12,*) 3
      write(12,*) 0.0
      do i=1,nj
	 write(12,*)mj(i)
      enddo
      do i=1,nj
	 write(12,*)(xj(k,i),k=1,3)
      enddo
      do i=1,nj
	 write(12,*)(vj(k,i),k=1,3)
      enddo

      end

