.SUFFIX: .s

CC = gcc
ifndef maxdev
  maxdev=4
endif
CFLAGS = -O3 -Wall -ffast-math -funroll-loops $(ARCHFLAG) -DMAXDEV=$(maxdev) -I../include

# the value of ENABLE_OPENMP is set to 'yes' by default.
# it is set by grapepkg/script/inst via the environment variable.
ENABLE_OPENMP ?= yes
ifeq ($(ENABLE_OPENMP), yes)
  CFLAGS += -fopenmp
endif

CFLAGS0 = -O3 -Wall
# OBJS    = gravity.o phantom_g5.o rsqrt.o
OBJS    = gravity.o phantom_g5mc.o rsqrt.o
TARGET  = libpg55.a 

all:	$(TARGET)

clean:
	rm *.o *.s *.a *.swp a.out -f

.s.o:
	$(CC) $(CFLAGS) -c $^

.c.s:
	$(CC) $(CFLAGS0) -S $^

libpg55.a: $(OBJS)
	ar -r $@ $^
	ranlib $@

benchmark: $(TARGET)
	make -C direct enable_openmp=$(enable_openmp) benchmark
