#ifndef HIBDRV_H
#define HIBDRV_H

/* max # of device */
#define NHIBMAX 16
#define HIB_DEVNAME "hibdrv"
enum {
    HIB_GRAPE7X  = 0,
    HIB_GRAPEDRP = 1,
    HIB_GRAPEDRG = 2,
};

// size of DMA buffers
#ifndef PAGE_SIZE
// #define PAGE_SIZE sysconf (_SC_PAGE_SIZE)
#define PAGE_SIZE 4096
#endif
#define HIB_DMABUF_ORDER (5) /* 2^5 pages */
#define HIB_DMABUF_BYTES (PAGE_SIZE * (1<<HIB_DMABUF_ORDER)) /* 128kbyte, 32pages */
#define HIB_DMABUF_WORDS (HIB_DMABUF_BYTES>>2) /* dma buffer size in quad-word */

#define HIB_USE_INTX (0) // 0:disable INTX interrupt. 1:enable it.

#if defined(_WIN32)

#include <initguid.h>

DEFINE_GUID(GUID_DEVINTERFACE_GPCIEHIB, // Generated using guidgen.exe
            0x7b39d3ee, 0x7c17, 0x4240, 0xb5, 0x4e, 0xa5, 0xab, 0x3, 0xa, 0x9, 0x9e);
// {7B39D3EE-7C17-4240-B54E-A5AB030A099E}

#include <poppack.h>

/* data object used for communications between
   user-space & kernel-space ioctl routines. */
typedef struct {
    unsigned int barid;
    unsigned long addr;
    unsigned int data;
} IOCTL_PACKET;

typedef struct {
    unsigned int nbyte;
    unsigned int barid;
    unsigned long addr;
    unsigned long data[4096];
} IOCTL_DATAPACKET;

typedef struct {
    unsigned int barid;
    unsigned long uaddr;
    unsigned int nbyte;
    unsigned int cacheType;
} IOCTL_MMAPPACKET;

typedef struct {
    unsigned long dmarpa;
    unsigned long dmawpa;
    unsigned long *dmarva;
    unsigned long *dmawva;
    unsigned long dmawsize;
    unsigned long dmarsize;
} IOCTL_DMAPACKET;

#define IOCTL_INDEX            3987
#define FILE_DEVICE_GPCIEHIB   65432

#define IOCTL_GPCIEHIB_CONFIG_READ CTL_CODE(FILE_DEVICE_GPCIEHIB,       \
                                            IOCTL_INDEX,                \
                                            METHOD_BUFFERED,            \
                                            FILE_ANY_ACCESS)
                                                   
#define IOCTL_GPCIEHIB_CONFIG_WRITE CTL_CODE(FILE_DEVICE_GPCIEHIB,      \
                                             IOCTL_INDEX + 1,           \
                                             METHOD_BUFFERED,           \
                                             FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_BAR_READ CTL_CODE(FILE_DEVICE_GPCIEHIB,  \
                                         IOCTL_INDEX + 2,       \
                                         METHOD_BUFFERED,       \
                                         FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_BAR_WRITE CTL_CODE(FILE_DEVICE_GPCIEHIB, \
                                          IOCTL_INDEX + 3,      \
                                          METHOD_BUFFERED,      \
                                          FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_BAR_MASSIVE_WRITE CTL_CODE(FILE_DEVICE_GPCIEHIB, \
                                                  IOCTL_INDEX + 4,      \
                                                  METHOD_BUFFERED,      \
                                                  FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_BAR_MMAP CTL_CODE(FILE_DEVICE_GPCIEHIB,  \
                                         IOCTL_INDEX + 5,       \
                                         METHOD_BUFFERED,       \
                                         FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_BAR_MUNMAP CTL_CODE(FILE_DEVICE_GPCIEHIB,  \
                                           IOCTL_INDEX + 6,       \
                                           METHOD_BUFFERED,       \
                                           FILE_ANY_ACCESS)

#define IOCTL_GPCIEHIB_DMABUF_DESC CTL_CODE(FILE_DEVICE_GPCIEHIB,  \
                                           IOCTL_INDEX + 7,       \
                                           METHOD_BUFFERED,       \
                                           FILE_ANY_ACCESS)


#ifndef PAGE_SIZE
#define PAGE_SIZE 4096
#endif

// dummy
enum {
    HIBDRV_MAP_HIBMEM = 0,
    HIBDRV_MAP_DMARBUF,
    HIBDRV_MAP_DMAWBUF,
    HIBDRV_MAP_BACKEND,
    HIBDRV_MAP_DBLBUF,
};
#define HIBDRV_WRITE_CFG            0
#define HIBDRV_READ_CFG             0
#define HIBDRV_GET_DMAR_PA          0
#define HIBDRV_GET_DMAW_PA          0
#define HIBDRV_SET_MAP_MODE         0

#else // !_WIN32

//#include <asm/page.h>
#include <linux/ioctl.h>
#include "typedef.h"

typedef struct {
    unsigned int vendorid;
    unsigned int deviceid;
} HibId;

static HibId hibids[] = {
    // GRAPE-7, PLDA PCI-X
    {
        .vendorid = 0x1556,
        .deviceid = 0x0070,
    },
    // GRAPE-DR, PLDA PCIe-Lite
    {
        .vendorid = 0x1556,
        .deviceid = 0x0e70,
    },
    // GRAPE-DR, GPCIe
    {
        .vendorid = 0x1b1a,
        .deviceid = 0x0e70,
    },
};

/* structure for read/write ioctl */

enum {
    HIB_MAP_HIBMEM = 0,
    HIB_MAP_DMARBUF,
    HIB_MAP_DMAWBUF,
    HIB_MAP_BACKEND,
    HIB_MAP_DBLBUF,
};

#define HIB_MAGIC (5)
#define HIB_WRITE_CFG            _IOW(HIB_MAGIC, 5, struct long_access)
#define HIB_READ_CFG             _IOWR(HIB_MAGIC, 4, struct long_access)
#define HIB_GET_DMAR_PA          _IOWR(HIB_MAGIC, 18, unsigned long)
#define HIB_GET_DMAW_PA          _IOWR(HIB_MAGIC, 19, unsigned long)
#define HIB_SET_MAP_MODE         _IOW(HIB_MAGIC, 20, unsigned int)

#endif // _WIN32

#endif /* HIBDRV_H */
