#include "vpm-local.h"
#include "vpm-sim-defs.h"
#include "vpm-board-sim-defs.h"
#define grape_j_particle_struct  SING_elt_struct0
struct grape_i_particle_struct{
  double xi_lmv;
  double yi_lmv;
  double zi_lmv;
  UINT32 idxi;
  double xi2_lmv;
  double yi2_lmv;
  double zi2_lmv;
  UINT32 idxi2;
};
struct grape_i_particle_vector_struct{
  double xi_lmv[4];
  double yi_lmv[4];
  double zi_lmv[4];
  UINT32 idxi[4];
  double xi2_lmv[4];
  double yi2_lmv[4];
  double zi2_lmv[4];
  UINT32 idxi2[4];
};
int SING_send_i_particle(struct grape_i_particle_struct *ip,
                         int n);

struct SING_elt_struct0{
  double xj;
  double yj;
  double zj;
  double mj_lb;
  double eps2_lb;
  UINT32 idxj;
};
int SING_send_elt_data0(struct SING_elt_struct0 *ip, int index_in_EM);
int SING_move_elt_data0(int index);


struct SING_result_struct{
  double accx_lmv;
  double accy_lmv;
  double accz_lmv;
  double pot_lmv;
  double accx2_lmv;
  double accy2_lmv;
  double accz2_lmv;
  double pot2_lmv;

};
struct SING_result_vectorstruct{
  double accx_lmv[128];
  double accy_lmv[128];
  double accz_lmv[128];
  double pot_lmv[128];
  double accx2_lmv[128];
  double accy2_lmv[128];
  double accz2_lmv[128];
  double pot2_lmv[128];

};
int SING_get_result(struct SING_result_struct *rp);
#define  grape_result_struct SING_result_struct 
void SING_grape_init();
int SING_grape_run(int n);
int SING_type2_run(int n, void * loopout);
