#include <stdio.h>
#include <stdarg.h>
#include "./vsmgen.h"
#ifndef NJP
#    define NJP 65536
#endif
struct SING_grape_consts{
  double _const_0;
  UINT64 _const_1;
  INT64 _const_2;
  UINT64 _const_3;
  double _const_4;
};
struct SING_grape_consts constants;

int SING_send_vsm_constants()
{
    int ndata = 5;
    int firstaddress= 124;
    int conversions[]={1,6,4,6,1};

    constants._const_0 = 1.5;
    constants._const_1 = 0x3fe000000LL;
    constants._const_2 = 1;
    constants._const_3 = 0x5fe7c0000LL;
    constants._const_4 = 0.5;

    SING_LM_write_regconv(ndata,conversions);
    SING_LM_write(&constants, firstaddress, 0);
}
int SING_send_j_particle(struct grape_j_particle_struct *jp, int index)
{
      return SING_send_elt_data0(jp, index);
}


static SING_copy_ip_to_vip(struct grape_i_particle_struct *p,
			   struct grape_i_particle_vector_struct *vp,
			   int k)
{
   vp->xi_lmv[k]= p->xi_lmv;
   vp->yi_lmv[k]= p->yi_lmv;
   vp->zi_lmv[k]= p->zi_lmv;
   vp->idxi[k]= p->idxi;
   vp->xi2_lmv[k]= p->xi2_lmv;
   vp->yi2_lmv[k]= p->yi2_lmv;
   vp->zi2_lmv[k]= p->zi2_lmv;
   vp->idxi2[k]= p->idxi2;

}

int SING_send_i_particle(struct grape_i_particle_struct *ip,
                         int n)
{
    struct grape_i_particle_vector_struct ipv[NPEMAX];
    int i;
    for(i=0;i<n;i++){
        int iv = i/4;
	int k  = i%4;
        SING_copy_ip_to_vip(ip+i, ipv+iv, k);
    }
    i = (n+3)/4;
    SING_LM_write(ipv, 0, i);
}

void SING_register_i_particle_conversion()
{
    int conversions[]={0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9};

    SING_LM_write_regconv(32,conversions);
}




static int emid0;
static int bmid0;
int SING_setup_elt_data0()
{
    int err;
    int conversions[]={0,0,0,1,1,9};

    emid0=SING_EM_alloc(6, conversions, 65536, &err);
    if (emid0 < 0){
        fprintf(stderr,"register jp, EMalloc err = %d\n",err);
        exit(-1);
    }
    bmid0=SING_BM_alloc(emid0,1,&err);
    if (bmid0 < 0){
    fprintf(stderr,"register jp, BMalloc err = %d\n",err);
          exit(-1);
    }
}


int SING_send_elt_data0(struct SING_elt_struct0 *ip, int index_in_EM)
{
    int ret;
    ret = SING_EM_send(emid0,index_in_EM,1,ip);
    if (ret){
        fprintf(stderr,"SING_EM_send returns: %d\n", ret);
         exit(-1);
    }
}

int SING_move_elt_data0(int index)
{
    SING_EM_BM_transfer(bmid0,index,0,1,0,-1);
}
static SING_copy_vr_to_r(struct SING_result_vectorstruct *vp,
                              struct SING_result_struct *p,
                         int k)
{
   p->accx_lmv=vp->accx_lmv[k];
   p->accy_lmv=vp->accy_lmv[k];
   p->accz_lmv=vp->accz_lmv[k];
   p->pot_lmv=vp->pot_lmv[k];
   p->accx2_lmv=vp->accx2_lmv[k];
   p->accy2_lmv=vp->accy2_lmv[k];
   p->accz2_lmv=vp->accz2_lmv[k];
   p->pot2_lmv=vp->pot2_lmv[k];

}
static struct SING_result_vectorstruct SING_rvp;

int SING_get_result(struct SING_result_struct *rp)
{
    int i;
    for(i=0;i<128;i++){
        SING_copy_vr_to_r(&SING_rvp, rp+i,i);
    }
}
static char* codes_1[]={
"ISP 1 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 idp 0 # idp 0",
"ISP 4 0 0 0 1 0 1 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  7 1 0 0   0  0 0 #   uxor $t $t $t",
"ISP 4 0 0 0 0 1 0 0 0  0 0 0  0 0 0  0 0 0 1 1  3c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $ti $ti accx_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  44 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   accy_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  4c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   accz_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  54 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   pot_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  5c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   accx2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  64 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   accy2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  6c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   accz2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 1 1  74 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 2 2  a 1 0 0   0  0 0 #   upassa $t $t   pot2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 #   nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 #   nop",
"ISP 4 0 0 0 0 0 0 1 1 15 0 0  0 0 0  0 0 0 0 0  7c 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 3 2  a 1 0 0   0  0 0 #   upassa _const_0  $t  f1p5_r21"
};
static char* codes_2[]={
"ISP 4 0 0 0 0 0 0 1 2 18 1 1  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 0   0  0 1 #   bm   vxj_lbv  $lr24v                                                         # xj,yj,zj,mj,eps2",
"ISP 4 0 0 0 0 0 0 1 1 14 0 0  0 0 0  0 0 0 0 0  7d 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 2 3  b 1 0 0   0  0 0  idp 0 #                                        upassb $t   _const_1   $r20        ",
"ISP 4 0 0 0 1 0 1 1 1  0 1 0 18 0 1  0 0 0 0 0   0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #                                        fsub $lr24  xi_lmv  dx_r0v  $t                            ",
"ISP 4 0 0 0 1 1 0 1 1  4 1 0 1a 0 1  0 0 0 0 0   8 1 0 1 0 0 1 1 0 0 1 1 0 1 2 2 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #   fmul $ti $ti     $t                ; fsub $lr26  yi_lmv  dy_r4v   ",
"ISP 4 0 0 0 0 0 0 1 1  8 1 0 1c 0 1  0 0 0 0 0  10 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #                                        fsub $lr28  zi_lmv  dz_r8v              # 5 ",
"ISP 4 0 0 0 1 0 1 0 0  0 0 0  4 1 0  0 0 0 0 0  fe 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 2 3  0 0 1 0   0  0 0 #   fmul dy_r4v   dy_r4v               ; fadd $t  leps2_m510 $t",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  8 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 6 2  0 0 1 0   0  0 0 #   fmul dz_r8v   dz_r8v               ; fadd $fb $ti       $t                   ",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 6 2  0 0 1 0   0  0 0 #                                        fadd $fb $ti       $t                    # r2",
"ISP 4 0 0 0 1 1 1 1 0 20 1 0 14 0 0  0 0 0 0 0  7e 0 0 1 0 0 1 1 0 0 0 1 1 1 2 0 1 1 0 0 1 2 3  d 1 0 0   0  0 0 #   fmul $ti       $r20     ahalf_r32v ; ulsr $ti _const_2     $t",
"ISP 4 0 0 0 1 1 1 1 1 10 1 0  0 0 0  0 0 0 0 0  80 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 3 2  1 1 0 0   0  0 0 #                                        usub _const_3  $ti  $t rinv_r16v    # 10",
"ISP 4 0 0 0 1 1 0 1 1  c 1 0 18 0 1  0 0 0 0 0  1c 1 0 1 0 0 1 1 0 0 1 1 0 1 2 2 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #   fmul $ti       $ti        $t       ; fsub $lr24  xi2_lmv  dx_r12v                                           ",
"ISP 4 0 0 0 1 1 0 0 0  0 0 0 20 1 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul $ti       ahalf_r32v $t       ",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  0 0 0  0 0 0 0 0  7c 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 1 3 2  0 0 1 0   0  0 0 #                                        fsub _const_0    $ti       $t",
"ISP 4 0 0 0 1 1 0 1 0 10 1 0 10 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul rinv_r16v $ti    $t rinv_r16v",
"ISP 4 0 0 0 1 1 0 1 1 30 1 1  0 0 0  0 0 0 0 0  44 1 0 1 0 0 1 1 0 0 1 1 0 1 2 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul $ti       $ti       $t        ; upassa accy_lmv accy_lmv $lr48v        # 15",
"ISP 4 0 0 0 1 1 0 1 1 38 1 1 20 1 0  0 0 0 0 0  4c 1 0 1 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul $ti       ahalf_r32v $t       ; upassa accz_lmv accz_lmv $lr56v     ",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  0 0 0  0 0 0 0 0  7c 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 1 3 2  0 0 1 0   0  0 0 #                                        fsub _const_0    $ti       $t",
"ISP 4 0 0 0 1 1 0 1 1 20 1 1 10 1 0  0 0 0 0 0  54 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul rinv_r16v $ti       $t        ; upassa pot_lmv pot_lmv    $lr32v       ",
"ISP 4 0 0 0 0 1 0 1 0 10 1 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 1 1 2 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul $ti       $ti      r2inv_r16v                                          # 20",
"ISP 4 0 0 0 1 0 0 1 1 28 1 1 1e 0 0  0 0 0 0 0  3c 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul lmj_r30   $t         $t       ; upassa accx_lmv accx_lmv $lr40v     ",
"ISP 4 0 0 0 1 1 0 0 0  0 0 0 10 1 0 20 1 1 1 1  54 1 0 1 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul $ti       r2inv_r16v $t       ; fadd   $fb $lr32v pot_lmv                ",
"ISP 4 0 0 0 0 1 0 0 0  0 0 0  0 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul dx_r0v    $ti                 ",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  4 1 0 28 1 1 1 1  3c 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul dy_r4v   $t                   ; fadd   $fb $lr40v accx_lmv",
"ISP 4 0 0 0 0 0 0 1 1 30 1 1  8 1 0 30 1 1 0 0   0 0 0 0 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul dz_r8v   $t                   ; fadd   $fb $lr48v $lr48v                # 25",
"ISP 4 0 0 0 1 0 0 1 1 38 1 1  c 1 0 38 1 1 0 0   0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul dx_r12v  dx_r12v  $t          ; fadd   $fb $lr56v $lr56v",
"ISP 4 0 0 0 0 0 0 1 1  4 1 0 1a 0 1  0 0 0 0 0  24 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #                                        fsub $lr26  yi2_lmv  dy_r4v   ",
"ISP 4 0 0 0 0 0 0 1 1  8 1 0 1c 0 1  0 0 0 0 0  2c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 3  0 0 1 0   0  0 0 #                                        fsub $lr28  zi2_lmv  dz_r8v              # 5 ",
"ISP 4 0 0 0 1 0 1 0 0  0 0 0  4 1 0  0 0 0 0 0  fe 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 2 3  0 0 1 0   0  0 0 #   fmul dy_r4v   dy_r4v               ; fadd $t  leps2_m510 $t",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  8 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 6 2  0 0 1 0   0  0 0 #   fmul dz_r8v   dz_r8v               ; fadd $fb $ti       $t                   ",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 6 2  0 0 1 0   0  0 0 #                                        fadd $fb $ti       $t                    # r2",
"ISP 4 0 0 0 1 1 1 1 0  0 1 0 14 0 0  0 0 0 0 0  7e 0 0 1 0 0 1 1 0 0 0 1 1 1 2 0 1 1 0 0 1 2 3  d 1 0 0   0  0 0 #   fmul $ti       $r20     ahalf_r0v  ; ulsr $ti _const_2     $t",
"ISP 4 0 0 0 1 1 1 1 1 10 1 0  0 0 0  0 0 0 0 0  80 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 3 2  1 1 0 0   0  0 0 #                                        usub _const_3  $ti  $t rinv_r16v    # 10",
"ISP 4 0 0 0 1 1 0 0 0  0 0 0 38 1 1  0 0 0 1 1  4c 1 0 1 0 0 1 1 0 0 1 1 0 1 2 2 1 1 0 0 1 0 0  a 1 0 0   0  0 0 #   fmul $ti       $ti        $t       ; upassa $lr56v $lr56v accz_lmv",
"ISP 4 0 0 0 1 1 0 0 0  0 0 0  0 1 0 30 1 1 1 1  44 1 0 1 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 1 1  a 1 0 0   0  0 0 #   fmul $ti       ahalf_r0v $t        ; upassa $lr48v $lr48v accy_lmv",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0 15 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 2  0 0 1 0   0  0 0 #                                        fsub f1p5_r21    $ti       $t",
"ISP 4 0 0 0 1 1 0 1 0 10 1 0 10 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul rinv_r16v $ti    $t rinv_r16v",
"ISP 4 0 0 0 1 1 0 1 1 30 1 1  0 0 0  0 0 0 0 0  64 1 0 1 0 0 1 1 0 0 1 1 0 1 2 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul $ti       $ti       $t        ; upassa accy2_lmv accy2_lmv $lr48v        # 15",
"ISP 4 0 0 0 1 1 0 1 1 38 1 1  0 1 0  0 0 0 0 0  6c 1 0 1 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul $ti       ahalf_r0v $t        ; upassa accz2_lmv accz2_lmv $lr56v     ",
"ISP 4 0 0 0 1 1 1 0 0  0 0 0  0 0 0  0 0 0 0 0  7c 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 1 3 2  0 0 1 0   0  0 0 #                                        fsub _const_0    $ti       $t",
"ISP 4 0 0 0 1 1 0 1 1 20 1 1 10 1 0  0 0 0 0 0  74 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul rinv_r16v $ti       $t        ; upassa pot2_lmv pot2_lmv    $lr32v       ",
"ISP 4 0 0 0 0 1 0 1 0 10 1 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 1 1 0 0 1 1 1 1 2 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul $ti       $ti      r2inv_r16v                                          # 20",
"ISP 4 0 0 0 1 0 0 1 1 28 1 1 1e 0 0  0 0 0 0 0  5c 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 3 3  a 1 0 0   0  0 0 #   fmul lmj_r30   $t         $t       ; upassa accx2_lmv accx2_lmv $lr40v     ",
"ISP 4 0 0 0 1 1 0 0 0  0 0 0 10 1 0 20 1 1 1 1  74 1 0 1 0 0 1 1 0 0 0 1 0 1 2 0 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul $ti       r2inv_r16v $t       ; fadd   $fb $lr32v pot2_lmv                ",
"ISP 4 0 0 0 0 1 0 0 0  0 0 0  c 1 0  0 0 0 0 0   0 0 0 0 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 0 0  0 0 0 0   0  0 0 #   fmul dx_r12v    $ti                 ",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  4 1 0 28 1 1 1 1  5c 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul dy_r4v   $t                   ; fadd   $fb $lr40v accx2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  8 1 0 30 1 1 1 1  64 1 0 1 0 0 0 1 0 0 1 1 0 1 0 2 1 1 0 0 1 6 1  0 0 1 0   0  0 0 #   fmul dz_r8v   $t                   ; fadd   $fb $lr48v accy2_lmv       # 25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0 38 1 1  0 0 0 1 1  6c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 6 0  0 0 1 0   0  0 0 #                                        fadd   $fb $lr56v accz2_lmv       "
};
static char* codes_3[]={
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  3c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accx_lmv accx_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accx_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  44 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accy_lmv accy_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accy_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  4c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accz_lmv accz_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accz_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  54 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa pot_lmv pot_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 pot_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  5c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accx2_lmv accx2_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accx2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  64 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accy2_lmv accy2_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accy2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  6c 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa accz2_lmv accz2_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 accz2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 1 1  0 1 1  0 0 0  0 0 0 0 0  74 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 3 3  a 1 0 0   0  0 0 # upassa pot2_lmv pot2_lmv $lr0v",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 700  0 1 # bm $lr0v $lb1792v  0",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 708  1 1 rrn 700 80 0 1 1 1 1 1 0 0 1 0 0 1 1 conv 0 # bm $lr0v $lb1800v  1 ; rrn fadd $lb1792v  128 flt72to64 pot2_lmv",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 710  2 1 # bm $lr0v $lb1808v  2",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 718  3 1 # bm $lr0v $lb1816v  3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 720  4 1 # bm $lr0v $lb1824v  4",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 728  5 1 # bm $lr0v $lb1832v  5",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 730  6 1 # bm $lr0v $lb1840v  6",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 738  7 1 # bm $lr0v $lb1848v  7",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 740  8 1 # bm $lr0v $lb1856v  8",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 748  9 1 # bm $lr0v $lb1864v  9",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 750  a 1 # bm $lr0v $lb1872v  10",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 758  b 1 # bm $lr0v $lb1880v  11",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 760  c 1 # bm $lr0v $lb1888v  12",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 768  d 1 # bm $lr0v $lb1896v  13",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 770  e 1 # bm $lr0v $lb1904v  14",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 778  f 1 # bm $lr0v $lb1912v  15",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 780 10 1 # bm $lr0v $lb1920v  16",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 788 11 1 # bm $lr0v $lb1928v  17",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 790 12 1 # bm $lr0v $lb1936v  18",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 798 13 1 # bm $lr0v $lb1944v  19",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a0 14 1 # bm $lr0v $lb1952v  20",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7a8 15 1 # bm $lr0v $lb1960v  21",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b0 16 1 # bm $lr0v $lb1968v  22",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7b8 17 1 # bm $lr0v $lb1976v  23",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c0 18 1 # bm $lr0v $lb1984v  24",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7c8 19 1 # bm $lr0v $lb1992v  25",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d0 1a 1 # bm $lr0v $lb2000v  26",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7d8 1b 1 # bm $lr0v $lb2008v  27",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e0 1c 1 # bm $lr0v $lb2016v  28",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7e8 1d 1 # bm $lr0v $lb2024v  29",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f0 1e 1 # bm $lr0v $lb2032v  30",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 1 1 0 0   0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0  0 0 0 1 7f8 1f 1 # bm $lr0v $lb2040v  31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 31",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 3",
"ISP 4 0 0 0 0 0 0 0 0  0 0 0  0 0 0  0 0 0 0 0   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0   0  0 0 # nop 3"
};
static SING_register_grape_codes(int id[])
{
    int k;
    for (k=0;k<4;k++) id[k]=-1;
    SING_iflush();
    id[1]=SING_iregister(13,codes_1);
    id[2]=SING_iregister(47,codes_2);
    id[3]=SING_iregister(525,codes_3);
}

static int ids[4];
int * SING_codes_pointer()
{
    return ids;
}

void SING_grape_init()
{
    SING_open();
    SING_send_vsm_constants();
    SING_setup_elt_data0();

    SING_register_i_particle_conversion();
    SING_register_grape_codes(ids);

}


int SING_grape_run(int n)
{
    return SING_execute(ids[1],ids[2],ids[3], n,
                        NULL, (void*) &SING_rvp);
}
