#include <stdio.h>
#include <stdlib.h>
#include "hibdrv.h"
#include "hibutil.h"
#include <sys/time.h>
#include <sys/resource.h>
#include <string.h>

void get_wcputime(laptime,splittime)
double *laptime;
double *splittime;
{
        struct timeval tval;
        void *dum=0;

        gettimeofday(&tval,dum);
        *laptime = tval.tv_sec + tval.tv_usec * 1.0e-6 - *splittime;
        *splittime = tval.tv_sec + tval.tv_usec * 1.0e-6 ;

}

void swapchar(ctmp,ctmp2)
char ctmp[];
char ctmp2[];
{
  if(strcmp(ctmp,"0")==0) strcpy(ctmp2,"0");
  if(strcmp(ctmp,"1")==0) strcpy(ctmp2,"8");
  if(strcmp(ctmp,"2")==0) strcpy(ctmp2,"4");
  if(strcmp(ctmp,"3")==0) strcpy(ctmp2,"c");
  if(strcmp(ctmp,"4")==0) strcpy(ctmp2,"2");
  if(strcmp(ctmp,"5")==0) strcpy(ctmp2,"a");
  if(strcmp(ctmp,"6")==0) strcpy(ctmp2,"6");
  if(strcmp(ctmp,"7")==0) strcpy(ctmp2,"e");
  if(strcmp(ctmp,"8")==0) strcpy(ctmp2,"1");
  if(strcmp(ctmp,"9")==0) strcpy(ctmp2,"9");
  if(strcmp(ctmp,"a")==0) strcpy(ctmp2,"5");
  if(strcmp(ctmp,"b")==0) strcpy(ctmp2,"d");
  if(strcmp(ctmp,"c")==0) strcpy(ctmp2,"3");
  if(strcmp(ctmp,"d")==0) strcpy(ctmp2,"b");
  if(strcmp(ctmp,"e")==0) strcpy(ctmp2,"7");
  if(strcmp(ctmp,"f")==0) strcpy(ctmp2,"f");
}

int
main(int argc, char **argv)
{
    Hib *h;
    UINT64 *rbuf;
    UINT64 *wbuf;
    static UINT64 piowbuf[1024];
    UINT64 data;
    int n,i,j,nn,ii;
    double drand48(),srend48();
    double lt,st;
    //    xhib_set_nclusters(1);
    UINT64 isp[1000];
    UINT64 idp00[1000];
    UINT64 idp01[1000];
    UINT64 idp10[1000];
    UINT64 idp11[1000];        
   static char odp[1000][30];
   
   static char strln[1024];
   static char cisp[1024];  
   static char cds[4][1024];
   static char cidp[4][1024];
   static char cdso[2][1024];
   static char codp[2][1024];      
   char ctmp[10];
   char ctmp2[10];
   static char ctmp3[1000];
   static char ctmp30[1000];   
   static char ctmp4[1000];
   static char ctmp5[1000];
   static char ctmp6[1000];
   static char ctmp7[1000];
   static char ctmp8[1000];
   static char ctmp9[1000];
   static char ctmp10[1000];
   static char ctmp11[1000];
   static char ctmp12[1000];      
   static char cswap[1024];
   int ic,devid=0;
   int par[14];

   sscanf(argv[1],"%d",&devid);
   printf("devid %d\n",devid);

   j=0;


   //   while(gets(strln)!=NULL){ // never use gets(). very dangerous.

   while(fgets(strln, sizeof(strln), stdin)!=NULL){

      sscanf(strln,"%s %s %s %s %s %s %s %s %s %s %s %s %s\n",cisp,cds[0],cidp[0],cds[1],cidp[1],
	 cds[2],cidp[2],cds[3],cidp[3],cdso[0],codp[0],cdso[1],codp[1]);

     for(ii=0;ii<4;ii++){
       strcpy(cswap,"");
       ic = strlen(cidp[ii]);
       if((ic!=18)&&(strcmp(cidp[ii],"0")!=0)){
         strcat(cswap,cidp[ii]);
         for(i=0;i<(18-ic);i++)strcat(cswap,"0");
         strcpy(cidp[ii],cswap);
       }
       if(strcmp(cidp[ii],"0")==0) strcpy(cidp[ii],"000000000000000000");
     }
     
     printf("%27s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s\n",cisp,cds[0],cidp[0],cds[1],cidp[1],
	    cds[2],cidp[2],cds[3],cidp[3],cdso[0],codp[0],cdso[1],codp[1]);

     strncpy(ctmp4,cisp,16);     
     sscanf(ctmp4,"%llx",&isp[j]);

     strncpy(ctmp5,cidp[0]+16,2);     
     sscanf(ctmp5,"%llx",&idp01[j]);
     idp01[j] = idp01[j]<<9;
     if(strcmp(cds[0],"1")==0) idp01[j] |= 0x1;

     strncpy(ctmp6,cidp[1]+16,2);     
     sscanf(ctmp6,"%llx",&idp11[j]);
     idp11[j] = idp11[j]<<9;
     if(strcmp(cds[1],"1")==0) idp11[j] |= 0x1;

     strncpy(ctmp9,cidp[0],16);     
     sscanf(ctmp9,"%llx",&idp00[j]);

     strncpy(ctmp10,cidp[1],16);     
     sscanf(ctmp10,"%llx",&idp10[j]);

     j++;     

     strncpy(ctmp3,cisp+16,11);
     sscanf(ctmp3,"%llx",&isp[j]);
     isp[j] = isp[j]<<20;

     strncpy(ctmp7,cidp[2]+16,2);
     sscanf(ctmp7,"%llx",&idp01[j]);
     idp01[j] = idp01[j]<<9;
     if(strcmp(cds[2],"1")==0) idp01[j] |= 0x1;

     strncpy(ctmp8,cidp[3]+16,2);
     sscanf(ctmp8,"%llx",&idp11[j]);
     idp11[j] = idp11[j]<<9;
     if(strcmp(cds[3],"1")==0) idp11[j] |= 0x1;

     strncpy(ctmp11,cidp[2],16);
     sscanf(ctmp11,"%llx",&idp00[j]);

     strncpy(ctmp12,cidp[3],16);
     sscanf(ctmp12,"%llx",&idp10[j]);

     j++;
   }

   n=j;

     h = hib_openMC(devid);
     hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
     rbuf = piowbuf;
     wbuf = h->dmaw_buf;

     //#define DMASTAT  (0x20)
     //    TBmemWrite(0, DMASTAT, 0x80000000);

     if (h->type == HIB_GRAPEDRG) {
         hib_mem_writeMC(devid, h->r->dma0cmd, (1 << h->r->dma0cmd_abort_bit));
         hib_mem_writeMC(devid, h->r->dma1cmd, (1 << h->r->dma1cmd_abort_bit));
     }
     else {
         hib_mem_writeMC(devid, h->r->command, (1<<h->r->command_dma_reset_bit));
     }

    for(i=0;i<n;i+=2){
      par[0] = (isp[i]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((isp[i]>>j) & 0x1);	
      par[1] = (isp[i]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((isp[i]>>j) & 0x1);	
      par[2] = (isp[i]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((isp[i]>>j) & 0x1);	
      par[3] = (isp[i]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((isp[i]>>j) & 0x1);	
      par[4] = (isp[i]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((isp[i]>>j) & 0x1);	
      par[5] = (isp[i]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((isp[i]>>j) & 0x1);
      par[6] = (isp[i]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((isp[i]>>j) & 0x1);	      
      par[7] = (isp[i]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((isp[i]>>j) & 0x1);	

      par[8] = (isp[i+1]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((isp[i+1]>>j) & 0x1);	
      par[9] = (isp[i+1]>>48) & 0x1; for(j=49;j<56;j++) par[9] = par[9] ^ ((isp[i+1]>>j) & 0x1);	
      par[10] = (isp[i+1]>>40) & 0x1; for(j=41;j<48;j++) par[10] = par[10] ^ ((isp[i+1]>>j) & 0x1);	
      par[11] = (isp[i+1]>>32) & 0x1; for(j=33;j<40;j++) par[11] = par[11] ^ ((isp[i+1]>>j) & 0x1);	
      par[12] = (isp[i+1]>>24) & 0x1; for(j=25;j<32;j++) par[12] = par[12] ^ ((isp[i+1]>>j) & 0x1);	
      par[13] = (isp[i+1]>>16) & 0x1; for(j=17;j<24;j++) par[13] = par[13] ^ ((isp[i+1]>>j) & 0x1);

      isp[i+1] = isp[i+1] | ((par[0]&0x1)<<15)|((par[1]&0x1)<<14)|((par[2]&0x1)<<13)|((par[3]&0x1)<<12)
        |((par[4]&0x1)<<11)|((par[5]&0x1)<<10)|((par[6]&0x1)<<9)|((par[7]&0x1)<<8)|((par[8]&0x1)<<7)|((par[9]&0x1)<<6)
	|((par[10]&0x1)<<5)|((par[11]&0x1)<<4)|((par[12]&0x1)<<3)|((par[13]&0x1)<<2);
      
    }

    for(i=0;i<n;i++){
      par[0] = (idp00[i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((idp00[i]>>j) & 0x1);	
      par[1] = (idp00[i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((idp00[i]>>j) & 0x1);	
      par[2] = (idp00[i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((idp00[i]>>j) & 0x1);	
      par[3] = (idp00[i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((idp00[i]>>j) & 0x1);	
      par[4] = (idp00[i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((idp00[i]>>j) & 0x1);	
      par[5] = (idp00[i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((idp00[i]>>j) & 0x1);
      par[6] = (idp00[i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((idp00[i]>>j) & 0x1);	      
      par[7] = (idp00[i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((idp01[i]>>j) & 0x1);	
      idp01[i] = idp01[i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
        |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1); 

      par[0] = (idp10[i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((idp10[i]>>j) & 0x1);	
      par[1] = (idp10[i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((idp10[i]>>j) & 0x1);	
      par[2] = (idp10[i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((idp10[i]>>j) & 0x1);	
      par[3] = (idp10[i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((idp10[i]>>j) & 0x1);	
      par[4] = (idp10[i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((idp10[i]>>j) & 0x1);	
      par[5] = (idp10[i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((idp10[i]>>j) & 0x1);
      par[6] = (idp10[i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((idp10[i]>>j) & 0x1);	      
      par[7] = (idp10[i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((idp11[i]>>j) & 0x1);	
      idp11[i] = idp11[i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
        |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1); 
    }
    
    //      sleep(1);
     /* ISP */
     rbuf[0] = 0x0000000400000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = isp[i];
     //for(i=0;i<n+1;i++) printf("i %x %d rbuf 0x%016llx isp 0x%016llx\n",i,i,rbuf[i],isp[i-1]);
//     hib_sendMC(devid, n+1, rbuf);


     /* IDP */
     nn = 5* (n/2);
     rbuf[0] = 0x0000000700000000ll | nn;
     for(i=0;i<(n/2);i++){
       rbuf[5*i+1] = ((UINT64)i)<<32 | (0x1&idp01[2*i])<<24 | (0x1&idp11[2*i])<<16 | (0x1&idp01[2*i+1])<<8 | (0x1&idp11[2*i+1]);
       rbuf[5*i+2] = idp00[2*i];       
       rbuf[5*i+3] = idp10[2*i];       
       rbuf[5*i+4] = idp00[2*i+1];
       rbuf[5*i+5] = idp10[2*i+1];       
     }
     for(i=0;i<nn+1;i++) printf("idp00 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, nn+1, rbuf);

     /* RUN */
     rbuf[0] = 0x0000000e00000002ll;
     rbuf[1] = 0x0000000000000001ll | ((UINT64)(n))<<24;
     rbuf[2] = 0x0000000000000000ll | ((UINT64)(n/2))<<32;

     for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, 3, rbuf);

     for(ii=0;ii<32;ii++){
       int perror;
       perror = 0;
       n=4;
       hib_recvMC(devid, n, wbuf);
       //       printf("wbuf %016llx %016llx\n",wbuf[1],wbuf[0]);

       par[0] = (wbuf[1]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((wbuf[1]>>j) & 0x1);	
       par[1] = (wbuf[1]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((wbuf[1]>>j) & 0x1);	
       par[2] = (wbuf[1]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((wbuf[1]>>j) & 0x1);	
       par[3] = (wbuf[1]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((wbuf[1]>>j) & 0x1);	
       par[4] = (wbuf[1]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((wbuf[1]>>j) & 0x1);	
       par[5] = (wbuf[1]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((wbuf[1]>>j) & 0x1);
       par[6] = (wbuf[1]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((wbuf[1]>>j) & 0x1);	      
       par[7] = (wbuf[1]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((wbuf[1]>>j) & 0x1);	
       par[8] = (wbuf[0]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((wbuf[0]>>j) & 0x1);	
       for(j=0;j<9;j++){
         if(par[j]!= ((wbuf[0]>>(55-j))&0x1)) perror = 1;
       }       
       par[0] = (wbuf[3]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((wbuf[3]>>j) & 0x1);	
       par[1] = (wbuf[3]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((wbuf[3]>>j) & 0x1);	
       par[2] = (wbuf[3]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((wbuf[3]>>j) & 0x1);	
       par[3] = (wbuf[3]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((wbuf[3]>>j) & 0x1);	
       par[4] = (wbuf[3]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((wbuf[3]>>j) & 0x1);	
       par[5] = (wbuf[3]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((wbuf[3]>>j) & 0x1);
       par[6] = (wbuf[3]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((wbuf[3]>>j) & 0x1);	      
       par[7] = (wbuf[3]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((wbuf[3]>>j) & 0x1);	
       par[8] = (wbuf[2]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((wbuf[2]>>j) & 0x1);	
       for(j=0;j<9;j++){
         if(par[j]!= ((wbuf[2]>>(55-j))&0x1)) perror = 1;
       }       

       if(perror==1){
         printf("wbuf %2x %2d %016llx %016llx %016llx %016llx ****\n",ii,ii,wbuf[1],wbuf[0],wbuf[3],wbuf[2] );
       }else{
         printf("wbuf %2x %2d %016llx %016llx %016llx %016llx\n",ii,ii,wbuf[1],wbuf[0],wbuf[3],wbuf[2] );       
       }
       
     }
 
    hib_closeMC(devid);

    exit(0);
}

