//  dgutil.c
//
//  from  matlib.c  J. Makino
//  Time-stamp: <2005/08/06 17:22:49 makino>

#include <stdio.h>

#define NPE 32
#define NBB 16
#define DIM0 (32*NBB)
#define DIM1 (8*NPE)

// #define TB3x8

#include "hibdrv.h"
#include "hibutil.h"
Hib *h;
UINT64 *rbuf;
UINT64 *wbuf;
static UINT64 piowbuf[1024];

static UINT64 isp[10000];
static UINT64 isp_run[10000];
static UINT64 idp00[10000];
static UINT64 idp01[10000];
static UINT64 idp10[10000];
static UINT64 idp11[10000];

static UINT64 isp00[1000];
static UINT64 isp01[1000];
static UINT64 isp0[1000];
static UINT64 isp1[1000];

void
gdrtb_sendMC(int devid, int size, UINT64 *buf)
{
#ifdef TB3x8
  int i;

  for(i=(size-1);i>=0;i--){
    buf[2*i] = buf[i];
    buf[2*i+1] = 0;
  }
  //  for(i=0;i<2*size;i++) printf("i %d buf %llx\n",i,buf[i]);

  hib_sendMC(devid, 2*size, buf);
#else
  hib_sendMC(devid, size, buf);
#endif
}

int
main(int argc, char **argv)
{
      int i0,i1,i,flag,devid,nn;

  sscanf(argv[1],"%d",&devid);
  printf("devid %d\n",devid);
  sscanf(argv[2],"%x",&flag);
  printf("odpflag %x\n",flag);

  h = hib_openMC(devid);
  hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
  rbuf = piowbuf;
  wbuf = h->dmaw_buf;

  //#define DMASTAT  (0x20)
  //    TBmemWrite(0, DMASTAT, 0x80000000);

  if (h->type == HIB_GRAPEDRG) {
    hib_mem_writeMC(devid, h->r->dma0cmd, (1 << h->r->dma0cmd_abort_bit));
    hib_mem_writeMC(devid, h->r->dma1cmd, (1 << h->r->dma1cmd_abort_bit));
  }
  else {
    hib_mem_writeMC(devid, h->r->command, (1<<h->r->command_dma_reset_bit));
  }

  rbuf[0] = 0x0000000b00000002ll;
  rbuf[1] = 0x0000000000000007ll;
  rbuf[2] = 0x0000000000000007ll;
    //      for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
    gdrtb_sendMC(devid, 3, rbuf);

   nn = 7; 
   rbuf[0] = 0x0000000b00000007ll;
   for(i=0;i<nn;i++) rbuf[i+1] = 0x0000000000000000ll | flag;
    //      for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
   gdrtb_sendMC(devid, nn+1, rbuf);

  hib_closeMC(devid);

}

