#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "hibdrv.h"
#include "hibutil.h"

void get_wcputime(laptime,splittime)
double *laptime;
double *splittime;
{
        struct timeval tval;
        void *dum=0;

        gettimeofday(&tval,dum);
        *laptime = tval.tv_sec + tval.tv_usec * 1.0e-6 - *splittime;
        *splittime = tval.tv_sec + tval.tv_usec * 1.0e-6 ;

}

int
main(int argc, char **argv)
{
    Hib *h;
    UINT64 *rbuf;
    UINT64 *wbuf;
    UINT64 *backend;
    static UINT64 piowbuf[1024];
    UINT64 data,g6data0,diff[5];
    int n,i,j,nn,ii,nlim;
    int devid=0;
    double drand48(),srend48();
    double lt,st;
    int sel,wadr,radr,radr0=0,wadr0=0,command,nread,nwrite,nrand,k,iii,resetdata;
    static UINT64 rdata[8388608][5];
    static UINT64 randata[8388608][5];    
    
    sscanf(argv[1],"%d",&devid);
    sscanf(argv[2],"%d",&command);    

    h = hib_openMC(devid);
    hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
    rbuf = piowbuf;
    wbuf = h->dmaw_buf;     

    if(argc==1){
      printf("testddr devid command ...\n");
      printf(" reset: testddr 0 data (s fifo, cnt, b fifo, cnt, ddr2)\n");
      printf(" write: testddr 1 address nwrite\n");    
      printf(" read : testddr 2 address nread\n");
      printf(" random test: testddr 3 nrand\n");
      printf(" random test(read only)\n\n");
      exit(1);
    }

    if(command==0){
        sscanf(argv[3],"%x",&resetdata);
        printf("reset\n");
        n=1;
        rbuf[0] = 0x0000000f00000001ll ;
	//        rbuf[1] = 0x000000000000001fll ;
	rbuf[1] = 0x0000000000000000ll | resetdata;
        hib_sendMC(devid, n+1, rbuf);
	sleep(1);
        rbuf[1] = 0x0000000000000000ll ;
//        hib_sendMC(devid, n+1, rbuf);
    }

    if(command==1){
      sscanf(argv[3],"%x",&wadr0);
      sscanf(argv[4],"%x",&nwrite);                    
      printf("write devid %d wadr0 %x nwrite %x\n",devid,wadr0,nwrite);
      if(nwrite>0x50) exit(1);

      n=nwrite*5;
      rbuf[0] = 0x0000000700000000ll | n;
      for(i=0;i<nwrite;i++){
        rbuf[5*i+1] = (((UINT64)(wadr0+i))<<32) | 0x0000000055555500ll | i;
        rbuf[5*i+2] = 0x4444444444444400ll | i;
        rbuf[5*i+3] = 0x3333333333333300ll | i;
        rbuf[5*i+4] = 0x2222222222222200ll | i;
        rbuf[5*i+5] = 0x1111111111111100ll | i;
      }
      for(i=0;i<n+1;i++) printf("rbuf %016llx\n",rbuf[i]);
      hib_sendMC(devid, n+1, rbuf);
    }

    if(command==2){
      sscanf(argv[3],"%x",&radr0);
      sscanf(argv[4],"%x",&nread);                    
      printf("read devid %d radr0 %x nread %x\n",devid,radr0,nread);
      if(nread>0x200) exit(1);
      
      for(iii=0;iii<5;iii++){

        rbuf[0] = 0x0000000f00000001ll ;
	rbuf[1] = 0x0000000000000000ll | iii<<4;
        hib_sendMC(devid, 2, rbuf);

        rbuf[0] = 0x0000000e00000002ll;
	//        rbuf[1] = 0x0000000010000000ll | (nread) ; 
	//        rbuf[2] = 0x0000000130000000ll | radr0 ;

	rbuf[1] = 0x0000000000000001ll | ((UINT64)(2*nread))<<24;
 	rbuf[2] = 0x0000000030000000ll | radr0 | ((UINT64)nread)<<32 ; 

        for(i=0;i<3;i++) printf("rbuf %016llx\n",rbuf[i]);
        hib_sendMC(devid, 3, rbuf);

        hib_recvMC(devid, nread, wbuf);
        for(ii=0;ii<nread;ii++) rdata[ii][iii] = wbuf[ii];

	//        for(i=0;i<n;i++) printf("wbuf %016llx\n",wbuf[i]);
      }

      for(ii=0;ii<nread;ii++){
	printf("%06x %016llx %016llx %016llx %016llx %016llx\n",
	       ii+radr0,rdata[ii][0],rdata[ii][1],rdata[ii][2],rdata[ii][3],rdata[ii][4]);
      }

    }

    if((command==3)||(command==4)){
      
      sscanf(argv[3],"%x",&nrand);                    
      printf("random test devid %d nrand %x\n",devid,nrand);
      srand(1);
      randata[0][0] = lrand48();

      for(j=0;j<3;j++){

      for(ii=0;ii<nrand;ii++){
        randata[ii][0] = lrand48();
        for(k=1;k<5;k++) randata[ii][k] = ((UINT64)lrand48())<<32 | lrand48();	
      }

      //      printf("randata %016llx %016llx %016llx %016llx %016llx\n",randata[0][1],randata[0][2],randata[0][3],randata[0][4],randata[0][5]);

      nlim=0x40;
      for(ii=0;ii<nrand;ii+=nlim){
	if((ii+nlim)>nrand){
          n = nrand-ii;
	}else{
	  n = nlim;
	}
        rbuf[0] = 0x0000000700000000ll | (5*n);
        for(i=0;i<n;i++){
          rbuf[5*i+1] = ((UINT64)(ii+i))<<32 | (0xffffffff&randata[ii+i][0]);
          rbuf[5*i+2] = randata[ii+i][1];
          rbuf[5*i+3] = randata[ii+i][2];
          rbuf[5*i+4] = randata[ii+i][3];
          rbuf[5*i+5] = randata[ii+i][4];	  
        }
	if(command!=4){
          hib_sendMC(devid, 5*n+1, rbuf);
	}
      }

      nlim=0x100;      
      for(ii=0;ii<nrand;ii+=nlim){
	if((ii+nlim)>nrand){
          n = nrand-ii;
	}else{
	  n = nlim;
	}
        for(iii=0;iii<5;iii++){

          rbuf[0] = 0x0000000f00000001ll ;
  	  rbuf[1] = 0x0000000000000000ll | iii<<4;
          hib_sendMC(devid, 2, rbuf);

          rbuf[0] = 0x0000000e00000002ll;
	  //          rbuf[1] = 0x0000000010000000ll | n ; 
	  //          rbuf[2] = 0x0000000130000000ll | ii ;
  	  rbuf[1] = 0x0000000000000001ll | ((UINT64)(2*n))<<24;
  	  rbuf[2] = 0x0000000030000000ll | ii | ((UINT64)n)<<32 ; 

          hib_sendMC(devid, 3, rbuf);

          hib_recvMC(devid, n, wbuf);
          for(i=0;i<n;i++) rdata[ii+i][iii] = wbuf[i];
        }

        if((ii%(nrand/8))==0){
 	  printf("write %06x %016llx %016llx %016llx %016llx %016llx\n",ii,randata[ii][0],randata[ii][1],randata[ii][2],randata[ii][3],randata[ii][4]);
          printf("read  %06x %016llx %016llx %016llx %016llx %016llx\n",ii,rdata[ii][0],rdata[ii][1],rdata[ii][2],rdata[ii][3],rdata[ii][4]);

	}
      }
      printf("\n");
	  
      for(i=0;i<nrand;i++) {	  
	UINT64 tmp64;
	diff[4] = rdata[i][4]^randata[i][4];
        diff[3] = rdata[i][3]^randata[i][3];
        diff[2] = rdata[i][2]^randata[i][2];
        diff[1] = rdata[i][1]^randata[i][1];
        diff[0] = (0xffffffffll & rdata[i][0])^randata[i][0];
	if((diff[4]!=0)||(diff[3]!=0)||(diff[2]!=0)||(diff[1]!=0)||(diff[0]!=0)){
  	  printf("%06x %016llx %016llx %016llx %016llx %016llx\n",i,diff[0],diff[1],diff[2],diff[3],diff[4]);
	   	  printf("write %06x %016llx %016llx %016llx %016llx %016llx\n",i,randata[i][0],randata[i][1],randata[i][2],randata[i][3],randata[i][4]);
	          printf("read  %06x %016llx %016llx %016llx %016llx %016llx\n",i,rdata[i][0],rdata[i][1],rdata[i][2],rdata[i][3],rdata[i][4]);
	}
      }
      printf("\n");
      }
    }

    hib_closeMC(devid);
}
