#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "hibdrv.h"
#include "hibutil.h"

void get_wcputime(laptime,splittime)
double *laptime;
double *splittime;
{
        struct timeval tval;
        void *dum=0;

        gettimeofday(&tval,dum);
        *laptime = tval.tv_sec + tval.tv_usec * 1.0e-6 - *splittime;
        *splittime = tval.tv_sec + tval.tv_usec * 1.0e-6 ;

}

Hib *h;
UINT64 *rbuf;
UINT64 *wbuf;
UINT64 *backend;
static UINT64 piowbuf[1024];

void reset_hib(int devid)
{
    if (h->type == HIB_GRAPEDRG) {
      hib_mem_writeMC(devid, h->r->dma0cmd, (1 << h->r->dma0cmd_abort_bit));
      hib_mem_writeMC(devid, h->r->dma1cmd, (1 << h->r->dma1cmd_abort_bit));
    }
    else {
      hib_mem_writeMC(devid, h->r->command, (1<<h->r->command_dma_reset_bit));
    }
}

void set_value(int devid, UINT64 clock, UINT64 data)
{
  int n,i;

    n=7;
    rbuf[0] = 0x0000000b00000000ll | n;
    for(i=1;i<n+1;i++)rbuf[i] = (clock<<21) |  (data<<20);
    //for(i=0;i<n+1;i++) printf("rbuf %016llx\n",rbuf[i]);
    hib_sendMC(devid, n+1, rbuf);
    usleep(5);
}

void read_value(int devid, UINT64 *value)
{
  int n,i;
    /* piodata */
    reset_hib(devid);
    n=1;
    rbuf[0] = 0x0000000a00000000ll | n;
    for(i=1;i<n+1;i++) rbuf[i] = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);
    hib_recvMC(devid, n, wbuf);
    *value = wbuf[n-1]>>63;
    //    for(i=0;i<n;i++) printf("wbuf %016llx\n",wbuf[i]);
    //    printf("\n");
}

void read_ack(int devid, UINT64 cvalue)
{
       UINT64 value;
      set_value(devid, 0, 1);   
      set_value(devid, 1, 1);   
      read_value(devid, &value);
      if(value!=cvalue) printf("incorrect ack %llx\n",value);
      set_value(devid, 0, 1);   
}
 
void set_start(int devid)
{
      set_value(devid, 1, 1);   // start
      set_value(devid, 1, 0);
      set_value(devid, 0, 0);    
}

void set_stop(int devid)
{
      set_value(devid, 1, 0);    
      set_value(devid, 1, 1);   
}
 
void set_value_oneclock(int devid, UINT64 data)
{
      set_value(devid, 0, data); 
      set_value(devid, 1, data);    
      set_value(devid, 0, data);   
}

void mtemp(int devid, int idata[])
{
  UINT64 a,d[3],value;
  int ii,i;

    a = 0x2b;
    //    a = 0x19;    
    d[0] = 0x10;   // local
    d[1] = 0x11;   // remote 1 IFPGA
    d[2] = 0x12;   // remote 2 3904     
    for(ii=0;ii<3;ii++){
      set_start(devid);                                                 // start
      for(i=6;i>=0;i--) set_value_oneclock(devid, 0x1LL&(a>>i));        // A6-0
      set_value_oneclock(devid,0);                                      // R/W
      read_ack(devid,0);                                                // ack
      for(i=7;i>=0;i--) set_value_oneclock(devid, (0x1LL&(d[ii]>>i)) ); // D7-0
      read_ack(devid,0);                                                // ack
      set_start(devid);                                                 // start
      for(i=6;i>=0;i--) set_value_oneclock(devid, 0x1LL&(a>>i));        // A6-0
      set_value_oneclock(devid, 1);                                     // R/W
      read_ack(devid,0);                                                // ack
      idata[ii] = 0;
      for(i=7;i>=0;i--){
        set_value(devid, 0, 1);                                         // D7-0
        set_value(devid, 1, 1);   
        read_value(devid, &value);
        idata[ii] |= (value<<i);
        set_value(devid, 0, 1);   
      }
      read_ack(devid,1);                                                // ack
      set_stop(devid);                                                  // stop
    }
}

int
main(int argc, char **argv)
{
    int devid=0,idata[3];

    sscanf(argv[1],"%d",&devid);
    printf("devid %d\n",devid);

    h = hib_openMC(devid);
    hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
    rbuf = piowbuf;
    wbuf = h->dmaw_buf;     
    reset_hib(devid);

    mtemp(devid, idata);
    printf("local,r1(if),r2(39) %d %d %d\n",idata[0],idata[1],idata[2]);

    hib_closeMC(devid);

}
