#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "hibdrv.h"
#include "hibutil.h"

void get_wcputime(laptime,splittime)
double *laptime;
double *splittime;
{
        struct timeval tval;
        void *dum=0;

        gettimeofday(&tval,dum);
        *laptime = tval.tv_sec + tval.tv_usec * 1.0e-6 - *splittime;
        *splittime = tval.tv_sec + tval.tv_usec * 1.0e-6 ;

}

int
main(int argc, char **argv)
{
    Hib *h;
    UINT64 *rbuf;
    UINT64 *wbuf;
    UINT64 *backend;
    static UINT64 piowbuf[1024];
    UINT64 data,g6data0;
    int n,i,j,nn,devid=0;
    double drand48(),srend48();
    double lt,st;
    UINT64 delayctl[5]; 
    UINT32 binfo,productid,modelid;
    
    sscanf(argv[1],"%d",&devid);
    printf("devid %d\n",devid);

    h = hib_openMC(devid);
    hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
    rbuf = piowbuf;
    wbuf = h->dmaw_buf;     

    if((argc==1)||(argc==2)){
    //    if(argc==1){      

    /* RUN */
    n=7;
    rbuf[0] = 0x0000000800000000ll | n;
    for(i=1;i<n+1;i++)rbuf[i] = 0x0000000000000000ll;    
    //    hib_sendMC(devid, n+1, rbuf);

    //    sleep(1);
    
    //    backend[0] = 0x0000000000000006ll;
    n=7;
    rbuf[0] = 0x0000000900000000ll | n;
    //    for(i=1;i<n+1;i++)rbuf[i] = 0x0000000000000000ll;
    for(i=1;i<n+1;i++)rbuf[i] = 0x0000000000000006ll;    
    hib_sendMC(devid, n+1, rbuf);

    printf("rstn = 0 ");

    //    sleep(1);
    usleep(10000);    

    binfo = hib_mem_readMC(devid, h->r->boardinfo);
    productid = (binfo >> 28) & 0xf;
    modelid = (binfo >> 24) & 0xf;

    if(modelid == 4){               // for model 2000

      delayctl[0] = 0x14;    /* 6bit */   // for model2000 380MHz 
      delayctl[1] = 0x14;    /* 6bit */
      delayctl[2] = 0x14;    /* 6bit */
      delayctl[3] = 0x12;    /* 6bit */
      delayctl[4] = 0x08;    /* 6bit */


    }else{

      delayctl[0] = 0x14;    /* 6bit */   // for model450/460/1800 380MHz 
      delayctl[1] = 0x14;    /* 6bit */
      delayctl[2] = 0x14;    /* 6bit */
      delayctl[3] = 0x12;    /* 6bit */
      delayctl[4] = 0x08;    /* 6bit */

    }

    //    sscanf(argv[1],"%d",&delayctl[4]);
    //    printf("delayctl[4] %d %x\n",delayctl[4],delayctl[4]);    

    //    backend[0] = 0x0000000100000007ll;

    n=7;
    rbuf[0] = 0x0000000900000000ll | n;    
    //    for(i=1;i<n+1;i++)rbuf[i] = 0x0000000000000201ll | (delayctl[4]<<44) | (delayctl[3]<<36) |(delayctl[2]<<28)|(delayctl[1]<<20)|(delayctl[0]<<12);
    for(i=1;i<n+1;i++)rbuf[i] = 0x0000000000000207ll | (delayctl[4]<<44) | (delayctl[3]<<36) |(delayctl[2]<<28)|(delayctl[1]<<20)|(delayctl[0]<<12);    
    hib_sendMC(devid, n+1, rbuf);

    printf(" 1\n");

    //    sleep(1);
    usleep(1000);    

    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);

    n=140;
    /* ISP */
    rbuf[0] = 0x0000000400000000ll | n ;
    for(i=1;i<n+1;i++) rbuf[i] = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);

    //    printf("finish isp fifo write\n");
    //    sleep(1);
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);
    //    sleep(1);

    /* IDP01 */
    //    rbuf[0] = 0x0000000100000000ll | n ;
    rbuf[0] = 0x0000000500000000ll | n ;    
    for(i=1;i<21;i++)    rbuf[i] = 0x0000000000000000ll;
    for(i=21;i<61;i++){
      if((i%2)==1) rbuf[i] = 0x000000000007ffffll;
      if((i%2)==0) rbuf[i] = 0x0000000000060000ll;
    }          
    for(i=61;i<81;i++){
      if((i%2)==1) rbuf[i] = 0x000000000003ffffll;
      if((i%2)==0) rbuf[i] = 0x0000000000020000ll;
    }
    for(i=81;i<121;i++)  rbuf[i] = 0x0000000000020000ll;    
    for(i=121;i<n+1;i++) rbuf[i] = 0x0000000000000000ll;

    hib_sendMC(devid, n+1, rbuf);

    //    printf("finish idp01 fifo write\n");
    //    sleep(1);
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);
    //    sleep(1);

    /* IDP00 */
    rbuf[0] = 0x0000000000000000ll | n ;
    for(i=1;i<21;i++)    rbuf[i] = 0x0000000000000000ll;
    for(i=21;i<81;i++){
      if((i%2)==1) rbuf[i] = 0xffffffffffffffffll;
      if((i%2)==0) rbuf[i] = 0x0000000000000000ll;
    }
    for(i=81;i<n+1;i++)  rbuf[i] = 0x0000000000000000ll;    
    hib_sendMC(devid, n+1, rbuf);

    //    printf("finish idp00 fifo write\n");
    //    sleep(1);
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);
    //    sleep(1);

    /* IDP10 */
    rbuf[0] = 0x0000000200000000ll | n ;
    for(i=1;i<21;i++) rbuf[i]  = 0x0000000000000000ll;
    for(i=21;i<81;i++){
      if((i%2)==1) rbuf[i] = 0xffffffffffffffffll;
      if((i%2)==0) rbuf[i] = 0x0000000000000000ll;
    }
    for(i=81;i<n+1;i++) rbuf[i]  = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);

    //    printf("finish idp10 fifo write\n");
    //    sleep(1);
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);
    //    sleep(1);

    /* IDP11 */
    rbuf[0] = 0x0000000300000000ll | n ;
    for(i=1;i<21;i++) rbuf[i]  = 0x0000000000000000ll;
    for(i=21;i<81;i++){
      if((i%2)==1) rbuf[i] = 0xffffffffffffffffll;
      if((i%2)==0) rbuf[i] = 0x0000000000000000ll;
    }
    for(i=81;i<n+1;i++) rbuf[i]  = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);

    //    printf("finish idp11 fifo write\n");
    //    sleep(1);
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);
    //    sleep(1);

    /* RUN */
    n=7;
    //    rbuf[0] = 0x0000001800000000ll | n;
    rbuf[0] = 0x0000000800000000ll | n;
    for(i=1;i<n+1;i++) rbuf[i] = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);

    printf("finish run\n");
    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);

    usleep(10000);

    //    data = backend[0];
    //    printf("data 0x%016llx\n", data);

    //       backend[0] = 0x0000040700000001ll;
    //       sleep(1);
       //       backend[0] = 0x0000080700000001ll;
       //                backend[0] = 0x0000000700000001ll;
       //        sleep(1);

    }

    /* piodata */
    n=7;
    rbuf[0] = 0x0000000a00000000ll | n;
    for(i=1;i<n+1;i++) rbuf[i] = 0x0000000000000000ll;
    hib_sendMC(devid, n+1, rbuf);

    n=7;
    hib_recvMC(devid, n, wbuf);
    for(i=4;i<n;i++) printf("wbuf %016llx\n",wbuf[i]);
    g6data0 = wbuf[n-1];

    printf("dsq_delayctlin0:                                    %2x\n",0x3f&(g6data0>>56));
    printf("lb_en & lb_sel:                                     %2x\n",0x7f&(g6data0>>44));    
    printf("odpsts1:                                             %1x\n",0x1&(g6data0>>40));
    printf("fifoodp1_empty & fifoodp0_empty & fifoisp_empty:     %1x\n",0x7&(g6data0>>37));        
    printf("fifoidp11_empty & fifoidp10_empty:                   %1x\n",0x3 &(g6data0>>35));
    printf("fifoidp01_empty & fifoidp00_empty:                   %1x\n",0x3 &(g6data0>>33));    
    printf("SG_PLLOUT & SG_PEOUT(7:0):                         %3x\n",0x1ff&(g6data0>>24));
    printf("SG_ISP_PERRO  & SG_ISP_CPERR & SG_ISP_PHSERR(3:0):  %2x\n",0x3f & (g6data0>>16));    
    printf("SG_IDP_PERRO  & SG_IDP_CPERR & SG_IDP_PHSERR(9:0): %3x\n",0xfff & (g6data0>>4));    
    printf("SG_ODP_STS & SG_ISP_STS & SG_IDP_STS:                %1x\n",0x7 & g6data0);    

    hib_closeMC(devid);
}
/*
 g6_piodata0 <=   "00" &  dqs_delayctrlin0 & "00000" & lb_en & lb_sel & "000" & odpsts1 & fifoodp1_empty & fifoodp0_empty
                  & fifoisp_empty &  fifoidp11_empty & fifoidp10_empty & fifoidp01_empty & fifoidp00_empty
                  & SG_PLLOUT & SG_PEOUT & "00" & SG_ISP_PERRO  & SG_ISP_CPERR & SG_ISP_PHSERR
                  & SG_IDP_PERRO  & SG_IDP_CPERR & SG_IDP_PHSERR & "0" & SG_ODP_STS & SG_ISP_STS & SG_IDP_STS;
*/
