#include <stdio.h>
#include <stdlib.h>
#include "hibdrv.h"
#include "hibutil.h"
Hib *h;
UINT64 *rbuf;
UINT64 *wbuf;
static UINT64 piowbuf[1024];

void set_counter(int devid, int ctype, int cparm, int cdata)
{
  int i;
  rbuf[0] = 0x0000001000000003ll;
  rbuf[1] = 0x0000000000000000ll | ctype << 12 | cparm << 9 | cdata;
  rbuf[2] = 0x0000000000000000ll | (0x1)<<16 | ctype << 12 | cparm << 9 | cdata;
  rbuf[3] = 0x0000000000000000ll | ctype << 12 | cparm << 9 | cdata;
  //  for(i=0;i<4;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
  hib_sendMC(devid, 4, rbuf);
  usleep(100000);
}

int main(int argc, char **argv)
{
  int i0,i1,i,flag,devid;
  int m,mby,n,nby;
  int c0h,c0l,c0o;
  int c1h,c1l,c1o;
  int c2h,c2l,c2o;
  int c3h,c3l,c3o;  

  sscanf(argv[1],"%d",&devid);
  printf("devid %d\n",devid);

  if(argc==3){
    sscanf(argv[2],"%d",&m);
    //    printf("odpflag %x\n",flag);
  }else{
    m = 34;
    //    m = 264;    
  }

  h = hib_openMC(devid);

  hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
  rbuf = piowbuf;
  wbuf = h->dmaw_buf;
  //#define DMASTAT  (0x20)
  //    TBmemWrite(0, DMASTAT, 0x80000000);

  if (h->type == HIB_GRAPEDRG) {
      hib_mem_writeMC(devid, h->r->dma0cmd, (1 << h->r->dma0cmd_abort_bit));
      hib_mem_writeMC(devid, h->r->dma1cmd, (1 << h->r->dma1cmd_abort_bit));
  }
  else {
      hib_mem_writeMC(devid, h->r->command, (1<<h->r->command_dma_reset_bit));
  }

  /*  reset */
  rbuf[0] = 0x0000001000000003ll;
  rbuf[1] = 0x0000000000000000ll;
  rbuf[2] = 0x0000000000000000ll | (0x1)<<18;
  rbuf[3] = 0x0000000000000000ll;  
  //  for(i=0;i<4;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
  hib_sendMC(devid, 4, rbuf);
  usleep(100000);
  
  /*  read param */
  rbuf[0] = 0x0000001000000003ll;
  rbuf[1] = 0x0000000000000000ll;
  rbuf[2] = 0x0000000000000000ll | (0x1)<<17;
  rbuf[3] = 0x0000000000000000ll;  
  //  for(i=0;i<4;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
  hib_sendMC(devid, 4, rbuf);
  usleep(100000);

   mby = 0;
  n = 7;   nby = 0;
   //  n = 50;   nby = 0;   

  c0h = 3; c0l= 3; c0o = 0;
  c1h = 3; c1l= 3; c1o = 0;
  c2h = 2; c2l= 1; c2o = 1;
  c3h = 3; c3l= 3; c3o = 0;  
    
  printf("m,n,c %d %d %d %d 125*m/(cx*n) %g MHz\n",m,n,c0h,c0l,125.0*m/n/(c0h+c0l));
  printf("m,n,c %d %d %d %d 125*m/(cx*n) %g MHz %g MHz\n",m,n,c1h,c1l,125.0*m/n/(c1h+c1l),4*125.0*m/n/(c1h+c1l));
  printf("m,n,c %d %d %d %d 125*m/(cx*n) %g MHz\n",m,n,c2h,c2l,125.0*m/n/(c2h+c2l));
  printf("m,n,c %d %d %d %d 125*m/(cx*n) %g MHz\n",m,n,c3h,c3l,125.0*m/n/(c3h+c3l));

  //  set_counter(devid, 0x2, 0x0, 1);   // charge pump current
  //  set_counter(devid, 0x2, 0x1, 26);   // loop filter resistance
  set_counter(devid, 0x2, 0x0, 6);   // charge pump current
  set_counter(devid, 0x2, 0x1, 1);   // loop filter resistance

  set_counter(devid, 0x0, 0x0, n);   // N nominal count     
  set_counter(devid, 0x0, 0x4, nby);   // N bypass bit
  set_counter(devid, 0x1, 0x0, m);  // M nominal count
  set_counter(devid, 0x1, 0x4, mby);   // M bypass bit
  set_counter(devid, 0x4, 0x0, c0h);   // c0 count   clk
  set_counter(devid, 0x4, 0x1, c0l);   
  set_counter(devid, 0x4, 0x5, c0o);
  set_counter(devid, 0x5, 0x0, c1h);   // c1 count   clkisph,refclk
  set_counter(devid, 0x5, 0x1, c1l);   
  set_counter(devid, 0x5, 0x5, c1o);
  set_counter(devid, 0x6, 0x0, c2h);   // c2 count   clk_isp
  set_counter(devid, 0x6, 0x1, c2l);   
  set_counter(devid, 0x6, 0x5, c2o);
  set_counter(devid, 0x7, 0x0, c3h);   // c3 count   clk_ddr2
  set_counter(devid, 0x7, 0x1, c3l);
  set_counter(devid, 0x7, 0x5, c3o);  

  /*
  set_counter(devid, 0x2, 0x0, 13);   // charge pump current
  set_counter(devid, 0x2, 0x1, 1);   // loop filter resistance

  set_counter(devid, 0x0, 0x0, 6);   // N nominal count     
  set_counter(devid, 0x0, 0x4, 0);   // N bypass bit

  m = 49;
  set_counter(devid, 0x1, 0x0, m);  // M nominal count
  set_counter(devid, 0x1, 0x4, 0);   // M bypass bit
  
  set_counter(devid, 0x4, 0x0, 5);   // c0 count 
  set_counter(devid, 0x4, 0x1, 5);
  set_counter(devid, 0x4, 0x5, 0);     

  set_counter(devid, 0x5, 0x0, 5);   // c1 count 
  set_counter(devid, 0x5, 0x1, 5);
  set_counter(devid, 0x5, 0x5, 0);     

  set_counter(devid, 0x6, 0x0, 3);   // c2 count 
  set_counter(devid, 0x6, 0x1, 2);
  set_counter(devid, 0x6, 0x5, 1);     

  set_counter(devid, 0x7, 0x0, 5);   // c3 count 
  set_counter(devid, 0x7, 0x1, 5);
  set_counter(devid, 0x7, 0x5, 0);     
  printf("m %d 4*(125*m/60) %g MHz\n",m,4.0*125.0*m/60.0);
  */

  /*
  set_counter(devid, 0x2, 0x0, 15);   // charge pump current
  set_counter(devid, 0x2, 0x1, 0);   // loop filter resistance

  set_counter(devid, 0x0, 0x0, 0);   // N nominal count
  set_counter(devid, 0x0, 0x4, 1);   // N bypass bit

  set_counter(devid, 0x1, 0x0, 8);   // M nominal count
  set_counter(devid, 0x1, 0x4, 0);   // M bypass bit

  set_counter(devid, 0x4, 0x0, 5);   // c0 count 
  set_counter(devid, 0x4, 0x1, 5);   
  set_counter(devid, 0x5, 0x0, 5);   // c1 count 
  set_counter(devid, 0x5, 0x1, 5);   
  set_counter(devid, 0x6, 0x0, 3);   // c2 count 
  set_counter(devid, 0x6, 0x1, 2);   
  set_counter(devid, 0x7, 0x0, 5);   // c3 count 
  set_counter(devid, 0x7, 0x1, 5);
  */
  
  /* reconfig */
  rbuf[0] = 0x0000001000000003ll;
  rbuf[1] = 0x0000000000000000ll;
  rbuf[2] = 0x0000000000000000ll | (0x1)<<19 ;
  rbuf[3] = 0x0000000000000000ll;  
  //  for(i=0;i<4;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
  hib_sendMC(devid, 4, rbuf);

  hib_closeMC(devid);
  exit(0);
}

