#!/bin/csh -f

if (! $#argv == 2) then
  cat << DESC_END
   usage: configsub <devid> <freqM>
DESC_END
  exit 1
endif
set devid = $1
set freqM = $2

set cmdname  = $0:t;
set rootpath = $0:h/../..
pushd $rootpath > /dev/null
set rootpath = `pwd`
popd > /dev/null

cd ${rootpath}/gdr

echo -------------------------------
echo  GRAPE-DR configuration
echo -------------------------------
#echo  set clock frequency
#echo -------------------------------
cd testv
./pllconfig ${devid} ${freqM}
echo -------------------------------
echo  Reset memory controller
echo -------------------------------
./testddr ${devid} 0 1
./testddr ${devid} 0 0
echo -------------------------------
echo  GDR chip configuration
echo -------------------------------
${rootpath}/hibutil/hibtest 1 ${devid}
${rootpath}/hibutil/hibtest 2 ${devid}
./testodp ${devid} fff
./testodp ${devid} 0
./sample ${devid}
${rootpath}/hibutil/hibtest 1 ${devid}
./sample ${devid}
echo -------------------------------
echo  GDR chip simple test 1
echo -------------------------------
./testvec2 ${devid} < testgravity
cd basic-grape
echo
./testvec ${devid} < basic-grape0.vec | tail -3
echo -------------------------------
echo  GDR chip simple test 2
echo -------------------------------
foreach i (0 1 2 3)
  ./testvec ${devid} < basic-grape0.vec | grep -v devid | grep -v flag > result.gdrtb3
  grep -v flag result3 > result3.0
  diff result.gdrtb3 result3.0 > /dev/null
  set s = ${status}
  if (${s} == 0) then
    tail -3 result.gdrtb3
    echo OK
  else
    diff -y result.gdrtb3 result3 | tail
    echo NG 
    echo check failed. 
    exit 1
  endif
  echo
end

# cd ${rootpath}
