#include <stdio.h>
#include <stdlib.h>
#include "hibdrv.h"
#include "hibutil.h"
#include <sys/time.h>
#include <sys/resource.h>
#include <string.h>

int devid=0;
Hib *h;
UINT64 *rbuf;
UINT64 *wbuf;
static UINT64 piowbuf[1024];

void send_vector(devid,i0,i1,isp,idp00,idp01,idp10,idp11)
int devid,i0,i1;
UINT64 isp[];
UINT64 idp00[];
UINT64 idp01[];
UINT64 idp10[];
UINT64 idp11[];        
{
  int i,nn,data,n;

  n= i1-i0 +1;
  printf("isp,idp n; %d\n", n);

     /* ISP */
     rbuf[0] = 0x0000000400000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = isp[i0+i];
     //for(i=0;i<n+1;i++) printf("i %x %d rbuf 0x%016llx isp 0x%016llx\n",i,i,rbuf[i],isp[i]);
     hib_sendMC(devid, n+1, rbuf);

     //    printf("isp; flags data 0x%016llx\n", data);
 
     /* IDP00 */
     rbuf[0] = 0x0000000000000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = idp00[i0+i];
     //     for(i=0;i<n+1;i++) printf("idp00 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, n+1, rbuf);

     //     printf("idp00; flags data 0x%016llx\n", data);

     /* IDP01 */
     rbuf[0] = 0x0000000100000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = idp01[i0+i];
     //     for(i=0;i<n+1;i++) printf("idp01 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, n+1, rbuf);

     //     printf("idp01; flags data 0x%016llx\n", data);

     /* IDP10 */
     rbuf[0] = 0x0000000200000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = idp10[i0+i];
     //     for(i=0;i<n+1;i++) printf("idp10 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, n+1, rbuf);

     //     printf("idp10; flags data 0x%016llx\n", data);

     /* IDP11 */
     rbuf[0] = 0x0000000300000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = idp11[i0+i];
     //    for(i=0;i<n+1;i++) printf("idp11 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, n+1, rbuf);

     //     printf("idp11; flags data 0x%016llx\n", data);

     /* RUN */
     nn=1;
     rbuf[0] = 0x0000000800000000ll | nn;
    for(i=1;i<nn+1;i++) rbuf[i] = 0x0000000000000000ll;
     //     for(i=0;i<n;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, nn+1, rbuf);

}

void send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11)
int devid,i0,i1;
UINT64 isp[];
UINT64 idp00[];
UINT64 idp01[];
UINT64 idp10[];
UINT64 idp11[];        
{
  int i,nn,data,n;

  n= i1-i0 +1;
  printf("isp     n; %d\n", n);

     /* ISP */
     rbuf[0] = 0x0000000600000000ll | n ;
     for(i=0;i<n;i++) rbuf[i+1] = isp[i0+i];
     //for(i=0;i<n+1;i++) printf("i %x %d rbuf 0x%016llx isp 0x%016llx\n",i,i,rbuf[i],isp[i]);
     hib_sendMC(devid, n+1, rbuf);

     //     printf("isp; flags data 0x%016llx\n", data);
 
     /* RUN */
     nn=2;
     rbuf[0] = 0x0000000e00000002ll | ((UINT64)n)<<48;
     rbuf[1] = 0x0000010000000000ll ;
     rbuf[2] = 0x0000000000000000ll ;
     //     for(i=0;i<n;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, nn+1, rbuf);

}

void send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11)
int devid,i0,i1;
UINT64 isp[];
UINT64 idp00[];
UINT64 idp01[];
UINT64 idp10[];
UINT64 idp11[];        
{
  int i,nn,data,n;

  n= i1-i0 +1;
  printf("idp     n; %d\n", n);

     /* IDP */

     nn = 5* (n/2);
     rbuf[0] = 0x0000000700000000ll | nn;
     for(i=0;i<(n/2);i++){
       rbuf[5*i+1] = ((UINT64)i)<<32 | (0x1&idp01[2*i+i0])<<24 | (0x1&idp11[2*i+i0])<<16 | (0x1&idp01[2*i+1+i0])<<8 | (0x1&idp11[2*i+1+i0]);
       rbuf[5*i+2] = idp00[2*i+i0];
       rbuf[5*i+3] = idp10[2*i+i0];
       rbuf[5*i+4] = idp00[2*i+1+i0];
       rbuf[5*i+5] = idp10[2*i+1+i0];
     }
//     for(i=0;i<nn+1;i++) printf("idp00 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, nn+1, rbuf);

     /* RUN */
     rbuf[0] = 0x0000000e00000002ll;
     rbuf[1] = 0x0000000000000001ll | ((UINT64)(n))<<24;
     rbuf[2] = 0x0000000000000000ll | ((UINT64)(n/2))<<32;

     //     for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
     hib_sendMC(devid, 3, rbuf);

}


void send_vector_isp_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11,ntimes)
int devid,i0,i1;
UINT64 isp[];
UINT64 idp00[];
UINT64 idp01[];
UINT64 idp10[];
UINT64 idp11[];
int ntimes;
{
  int i,nn,data,n,ii,nidp,iii,ispplus;

  n= i1-i0 +1;

     printf("isp+idp  n: %d   ntimes: %d\n", n,ntimes);

     ispplus = 26;
     ii=0;
     /* ISP */
     rbuf[0] = 0x0000000600000000ll | (n+ispplus) ;
     for(i=0;i<n;i++) rbuf[i+1] = isp[i0+i];
     for(i=0;i<ispplus;i++) rbuf[i+1+n] = 0;
     //for(i=0;i<n+1+ispplus;i++) printf("i %x %d rbuf 0x%016llx isp 0x%016llx\n",i,i,rbuf[i],isp[i]);
     hib_sendMC(devid, n+1+ispplus, rbuf);

     nidp = 21;
     for(ii=0;ii<ntimes;ii++){
       /* IDP */
       nn = 5*nidp;
       rbuf[0] = 0x0000000700000000ll | nn;
       for(i=0;i<nidp;i++){
	 iii = 2*i+i0+ii*n+8;
         rbuf[5*i+1] = ((UINT64)(i+ii*nidp))<<32 | (0x1&idp01[iii])<<24 | (0x1&idp11[iii])<<16 | (0x1&idp01[iii+1])<<8 | (0x1&idp11[iii+1]);
         rbuf[5*i+2] = idp00[iii];
         rbuf[5*i+3] = idp10[iii];
         rbuf[5*i+4] = idp00[iii+1];
         rbuf[5*i+5] = idp10[iii+1];
       }
       //     for(i=0;i<nn+1;i++) printf("idp00 i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
       hib_sendMC(devid, nn+1, rbuf);
     }

     usleep(10000);

       /* RUN */
       nn=2;
       rbuf[0] = 0x0000000e00000002ll | ((UINT64)(n+ispplus))<<48;
       rbuf[1] = 0x0000000000000000ll | ((UINT64)(n+ispplus))<<24 | ((UINT64)ntimes)<<40 | ((UINT64)ntimes);
       rbuf[2] = 0x0000000000000000ll | ((UINT64)nidp)<<32 ;

       for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
       hib_sendMC(devid, 3, rbuf);

#ifdef OLD
     for(ii=0;ii<ntimes;ii++){
       /* RUN */
       nn=2;
       rbuf[0] = 0x0000000e00000002ll | ((UINT64)n)<<48;
       rbuf[1] = 0x0000010000000001ll | ((UINT64)n)<<24;
       rbuf[2] = 0x0000000000000000ll | ((UINT64)nidp)<<32 | ii*nidp;

 //     for(i=0;i<3;i++) printf("i %x %d rbuf 0x%016llx\n",i,i,rbuf[i]);
       hib_sendMC(devid, 3, rbuf);
       usleep(1000);
     }
#endif
}

void print_wbuf()
{
     int ii,j,perror,par[9];

     for(ii=0;ii<64;ii++){
       perror = 0;
       par[0] = (wbuf[4*ii+1]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[1] = (wbuf[4*ii+1]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[2] = (wbuf[4*ii+1]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[3] = (wbuf[4*ii+1]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[4] = (wbuf[4*ii+1]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[5] = (wbuf[4*ii+1]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[6] = (wbuf[4*ii+1]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[7] = (wbuf[4*ii+1]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((wbuf[4*ii+1]>>j) & 0x1);
       par[8] = (wbuf[4*ii+0]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((wbuf[4*ii+0]>>j) & 0x1);
       for(j=0;j<9;j++){
         if(par[j]!= ((wbuf[4*ii+0]>>(55-j))&0x1)) perror = 1;
       }
       par[0] = (wbuf[4*ii+3]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[1] = (wbuf[4*ii+3]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[2] = (wbuf[4*ii+3]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[3] = (wbuf[4*ii+3]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[4] = (wbuf[4*ii+3]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[5] = (wbuf[4*ii+3]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[6] = (wbuf[4*ii+3]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[7] = (wbuf[4*ii+3]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((wbuf[4*ii+3]>>j) & 0x1);
       par[8] = (wbuf[4*ii+2]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((wbuf[4*ii+2]>>j) & 0x1);
       for(j=0;j<9;j++){
         if(par[j]!= ((wbuf[4*ii+2]>>(55-j))&0x1)) perror = 1;
       }

       if(perror==1){
	 //         printf("%016llx%02x %016llx%02x *****\n",wbuf[4*ii+1],0xff&(wbuf[4*ii+0]>>56),wbuf[4*ii+3],0xff&(wbuf[4*ii+2]>>56));
         printf("%016llx%02x %03x %016llx%02x %03x *****\n",wbuf[4*ii+1],0xff&(wbuf[4*ii+0]>>56),0x1ff&(wbuf[4*ii+0]>>47),
		wbuf[4*ii+3],0xff&(wbuf[4*ii+2]>>56),0x1ff&(wbuf[4*ii+2]>>47));
       }else{
         printf("%016llx%02x %03x %016llx%02x %03x\n",wbuf[4*ii+1],0xff&(wbuf[4*ii+0]>>56),0x1ff&(wbuf[4*ii+0]>>47),
		wbuf[4*ii+3],0xff&(wbuf[4*ii+2]>>56),0x1ff&(wbuf[4*ii+2]>>47));
       }
     }
}

int
main(int argc, char **argv)
{
    UINT64 data;
    int n,i,j,nn,ii,i0,i1;
    double drand48(),srend48();
    double lt,st;
    //    xhib_set_nclusters(1);
    static UINT64 isp[10000];
    static UINT64 idp00[10000];
    static UINT64 idp01[10000];
    static UINT64 idp10[10000];
    static UINT64 idp11[10000];        
   
   static char strln[1024];
   static char cisp[1024];  
   static char cds[4][1024];
   static char cidp[4][1024];
   static char cdso[2][1024];
   static char codp[2][1024];      
   char ctmp[10];
   char ctmp2[10];
   static char ctmp3[1000];
   static char ctmp30[1000];   
   static char ctmp4[1000];
   static char ctmp5[1000];
   static char ctmp6[1000];
   static char ctmp7[1000];
   static char ctmp8[1000];
   static char ctmp9[1000];
   static char ctmp10[1000];
   static char ctmp11[1000];
   static char ctmp12[1000];      
   static char cswap[1024];
   int ic;
   int par[14],perror,l0,l1,ntimes;

   sscanf(argv[1],"%d",&devid);
   printf("devid %d\n",devid);

   j=0;

   while(fgets(strln, sizeof(strln), stdin)!=NULL){

      sscanf(strln,"%s %s %s %s %s %s %s %s %s %s %s %s %s\n",cisp,cds[0],cidp[0],cds[1],cidp[1],
	 cds[2],cidp[2],cds[3],cidp[3],cdso[0],codp[0],cdso[1],codp[1]);

      //     printf("%s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s\n",cisp,cds[0],cidp[0],cds[1],cidp[1],
      //       cds[2],cidp[2],cds[3],cidp[3],cdso[0],codp[0],cdso[1],codp[1]);

     for(ii=0;ii<4;ii++){
       strcpy(cswap,"");
       ic = strlen(cidp[ii]);
       if((ic!=18)&&(strcmp(cidp[ii],"0")!=0)){
         strcat(cswap,cidp[ii]);
         for(i=0;i<(18-ic);i++)strcat(cswap,"0");
         strcpy(cidp[ii],cswap);
       }
       if(strcmp(cidp[ii],"0")==0) strcpy(cidp[ii],"000000000000000000");
     }
     /*
     printf("%27s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s %1s %18s\n",cisp,cds[0],cidp[0],cds[1],cidp[1],
	    cds[2],cidp[2],cds[3],cidp[3],cdso[0],codp[0],cdso[1],codp[1]);
     */
     //     printf("\n");

     strncpy(ctmp4,cisp,16);     
     sscanf(ctmp4,"%llx",&isp[j]);

     strncpy(ctmp5,cidp[0]+16,2);     
     sscanf(ctmp5,"%llx",&idp01[j]);
     idp01[j] = idp01[j]<<9;
     if(strcmp(cds[0],"1")==0) idp01[j] |= 0x1;

     strncpy(ctmp6,cidp[1]+16,2);     
     sscanf(ctmp6,"%llx",&idp11[j]);
     idp11[j] = idp11[j]<<9;
     if(strcmp(cds[1],"1")==0) idp11[j] |= 0x1;

     strncpy(ctmp9,cidp[0],16);     
     sscanf(ctmp9,"%llx",&idp00[j]);

     strncpy(ctmp10,cidp[1],16);     
     sscanf(ctmp10,"%llx",&idp10[j]);
     
     j++;     

     strncpy(ctmp3,cisp+16,11);
     sscanf(ctmp3,"%llx",&isp[j]);
     isp[j] = isp[j]<<20;

     strncpy(ctmp7,cidp[2]+16,2);
     sscanf(ctmp7,"%llx",&idp01[j]);
     idp01[j] = idp01[j]<<9;
     if(strcmp(cds[2],"1")==0) idp01[j] |= 0x1;

     strncpy(ctmp8,cidp[3]+16,2);
     sscanf(ctmp8,"%llx",&idp11[j]);
     idp11[j] = idp11[j]<<9;
     if(strcmp(cds[3],"1")==0) idp11[j] |= 0x1;

     strncpy(ctmp11,cidp[2],16);
     sscanf(ctmp11,"%llx",&idp00[j]);

     strncpy(ctmp12,cidp[3],16);
     sscanf(ctmp12,"%llx",&idp10[j]);

     j++;
   }

   n=j;

    for(i=0;i<n;i+=2){
      par[0] = (isp[i]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((isp[i]>>j) & 0x1);
      par[1] = (isp[i]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((isp[i]>>j) & 0x1);
      par[2] = (isp[i]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((isp[i]>>j) & 0x1);
      par[3] = (isp[i]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((isp[i]>>j) & 0x1);
      par[4] = (isp[i]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((isp[i]>>j) & 0x1);
      par[5] = (isp[i]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((isp[i]>>j) & 0x1);
      par[6] = (isp[i]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((isp[i]>>j) & 0x1);
      par[7] = (isp[i]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((isp[i]>>j) & 0x1);

      par[8] = (isp[i+1]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((isp[i+1]>>j) & 0x1);
      par[9] = (isp[i+1]>>48) & 0x1; for(j=49;j<56;j++) par[9] = par[9] ^ ((isp[i+1]>>j) & 0x1);
      par[10] = (isp[i+1]>>40) & 0x1; for(j=41;j<48;j++) par[10] = par[10] ^ ((isp[i+1]>>j) & 0x1);
      par[11] = (isp[i+1]>>32) & 0x1; for(j=33;j<40;j++) par[11] = par[11] ^ ((isp[i+1]>>j) & 0x1);
      par[12] = (isp[i+1]>>24) & 0x1; for(j=25;j<32;j++) par[12] = par[12] ^ ((isp[i+1]>>j) & 0x1);
      par[13] = (isp[i+1]>>16) & 0x1; for(j=17;j<24;j++) par[13] = par[13] ^ ((isp[i+1]>>j) & 0x1);

      isp[i+1] = isp[i+1] | ((par[0]&0x1)<<15)|((par[1]&0x1)<<14)|((par[2]&0x1)<<13)|((par[3]&0x1)<<12)
        |((par[4]&0x1)<<11)|((par[5]&0x1)<<10)|((par[6]&0x1)<<9)|((par[7]&0x1)<<8)|((par[8]&0x1)<<7)|((par[9]&0x1)<<6)
        |((par[10]&0x1)<<5)|((par[11]&0x1)<<4)|((par[12]&0x1)<<3)|((par[13]&0x1)<<2);

    }

    for(i=0;i<n;i++){
      par[0] = (idp00[i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((idp00[i]>>j) & 0x1);
      par[1] = (idp00[i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((idp00[i]>>j) & 0x1);
      par[2] = (idp00[i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((idp00[i]>>j) & 0x1);
      par[3] = (idp00[i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((idp00[i]>>j) & 0x1);
      par[4] = (idp00[i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((idp00[i]>>j) & 0x1);
      par[5] = (idp00[i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((idp00[i]>>j) & 0x1);
      par[6] = (idp00[i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((idp00[i]>>j) & 0x1);
      par[7] = (idp00[i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((idp01[i]>>j) & 0x1);
      idp01[i] = idp01[i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
        |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1);

      par[0] = (idp10[i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((idp10[i]>>j) & 0x1);
      par[1] = (idp10[i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((idp10[i]>>j) & 0x1);
      par[2] = (idp10[i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((idp10[i]>>j) & 0x1);
      par[3] = (idp10[i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((idp10[i]>>j) & 0x1);
      par[4] = (idp10[i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((idp10[i]>>j) & 0x1);
      par[5] = (idp10[i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((idp10[i]>>j) & 0x1);
      par[6] = (idp10[i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((idp10[i]>>j) & 0x1);
      par[7] = (idp10[i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((idp11[i]>>j) & 0x1);
      idp11[i] = idp11[i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
        |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1);
    }

     h = hib_openMC(devid);
     hib_set_sendfuncMC(devid, SENDFUNC_PIOW);
     rbuf = piowbuf;
     wbuf = h->dmaw_buf;

     //#define DMASTAT  (0x20)
     //    TBmemWrite(0, DMASTAT, 0x80000000);
     if (h->type == HIB_GRAPEDRG) {
         hib_mem_writeMC(devid, h->r->dma0cmd, (1 << h->r->dma0cmd_abort_bit));
         hib_mem_writeMC(devid, h->r->dma1cmd, (1 << h->r->dma1cmd_abort_bit));
     }
     else {
         hib_mem_writeMC(devid, h->r->command, (1<<h->r->command_dma_reset_bit));
     }

     //     sleep(1);
     printf("flags data 0x%016llx n %d\n", data,n);

     /*  const */
     l0 = 1; l1 = 5;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector(devid,i0,i1,isp,idp00,idp01,idp10,idp11);

     /*  ip */

     l0 = 6; l1 = 71;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 72; l1 = 121;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     
     l0 = 122; l1 = 225;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 226; l1 = 317;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     
     /*  inst */
     
     l0 = 318; l1 = 339;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);

     l0 = 318; l1 = 339;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);

     ntimes = 32;
     l0 = 340; l1 = 398;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11,ntimes);

     usleep(100000);

     /* fo */

     l0 = 2230; l1 = 2264;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 2233; l1 = 2234;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);     
     hib_recvMC(devid, 256, wbuf);
     print_wbuf();
     
     l0 = 2295; l1 = 2329;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 2298; l1 = 2299;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     hib_recvMC(devid, 256, wbuf);
     print_wbuf();

     l0 = 2360; l1 = 2394;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 2363; l1 = 2364;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     hib_recvMC(devid, 256, wbuf);
     print_wbuf();

     l0 = 2425; l1 = 2459;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_isp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     l0 = 2428; l1 = 2429;  i0 =2*(l0-1); i1=2*(l1-1)+1;
     send_vector_idp(devid,i0,i1,isp,idp00,idp01,idp10,idp11);
     hib_recvMC(devid, 256, wbuf);
     print_wbuf();

     hib_closeMC(devid);

    exit(0);
}

