// function for temperature measurement

static void set_value(int clusterid, UINT64 clock, UINT64 data)
{
  int n,i;

  n=7;
  Rbuf[clusterid][0] = 0x0000000b00000000ll | n;
  for(i=1;i<n+1;i++)Rbuf[clusterid][i] = (clock<<21) |  (data<<20);
  //for(i=0;i<n+1;i++) printf("rbuf %016llx\n",Rbuf[i]);
  hib_sendMC(clusterid, n+1, Rbuf[clusterid]);
  usleep(5);
}

static void read_value(int clusterid, UINT64 *value)
{
  int n,i;
  /* piodata */
  reset_hib(clusterid);
  n=1;
  Rbuf[clusterid][0] = 0x0000000a00000000ll | n;
  for(i=1;i<n+1;i++) Rbuf[clusterid][i] = 0x0000000000000000ll;
  hib_sendMC(clusterid, n+1, Rbuf[clusterid]);
  hib_recvMC(clusterid, n, Wbuf[clusterid]);
  *value = Wbuf[clusterid][n-1]>>63;
  //    for(i=0;i<n;i++) printf("wbuf %016llx\n",Wbuf[i]);
  //    printf("\n");
}

static void read_ack(int clusterid, UINT64 cvalue)
{
  UINT64 value;
  set_value(clusterid, 0, 1);
  set_value(clusterid, 1, 1);
  read_value(clusterid, &value);
  if(value!=cvalue) fprintf(stderr,"incorrect ack %llx\n",value);
  set_value(clusterid, 0, 1);
}

static void set_start(int clusterid)
{
  set_value(clusterid, 1, 1);   // start
  set_value(clusterid, 1, 0);
  set_value(clusterid, 0, 0);
}

static void set_stop(int clusterid)
{
  set_value(clusterid, 1, 0);
  set_value(clusterid, 1, 1);
}

static void set_value_oneclock(int clusterid, UINT64 data)
{
  set_value(clusterid, 0, data);
  set_value(clusterid, 1, data);
  set_value(clusterid, 0, data);
}

void mtempMC(int clusterid)
{
  UINT64 a,d[3],value;
  int ii,i,iii;
  int idata[3],idatalimit;
  UINT32 binfo,productid,modelid;

  binfo = hib_mem_readMC(clusterid, H[clusterid]->r->boardinfo);
  productid = (binfo >> 28) & 0xf;
  modelid = (binfo >> 24) & 0xf;
  if(modelid==3) idatalimit = 55;
  if(modelid==4) idatalimit = 65;

  a = 0x2b;
  d[0] = 0x10;   // local
  d[1] = 0x11;   // remote 1 IFPGA
  d[2] = 0x12;   // remote 2 3904
  for(ii=0;ii<3;ii++){
    set_start(clusterid);                                                 // start
    for(i=6;i>=0;i--) set_value_oneclock(clusterid, 0x1LL&(a>>i));        // A6-0
    set_value_oneclock(clusterid,0);                                      // R/W
    read_ack(clusterid,0);                                                // ack
    for(i=7;i>=0;i--) set_value_oneclock(clusterid, (0x1LL&(d[ii]>>i)) ); // D7-0
    read_ack(clusterid,0);                                                // ack
    set_start(clusterid);                                                 // start
    for(i=6;i>=0;i--) set_value_oneclock(clusterid, 0x1LL&(a>>i));        // A6-0
    set_value_oneclock(clusterid, 1);                                     // R/W
    read_ack(clusterid,0);                                                // ack
    idata[ii] = 0;
    for(i=7;i>=0;i--){
      set_value(clusterid, 0, 1);                                         // D7-0
      set_value(clusterid, 1, 1);
      read_value(clusterid, &value);
      idata[ii] |= (value<<i);
      set_value(clusterid, 0, 1);
    }
    read_ack(clusterid,1);                                                // ack
    set_stop(clusterid);                                                  // stop
  }

  fprintf(stderr,"clusterid %d temp %d %d %d\n",clusterid,idata[0],idata[1],idata[2]);

  iii = 0;
  while(idata[1] > idatalimit){
    iii++;
    if(iii>3){
      fprintf(stderr,"\nGRAPE-DR board seems too hot. Please check the cooling.\n\n");
      exit(1);
    }
    ii=1;
    set_start(clusterid);                                                 // start
    for(i=6;i>=0;i--) set_value_oneclock(clusterid, 0x1LL&(a>>i));        // A6-0
    set_value_oneclock(clusterid,0);                                      // R/W
    read_ack(clusterid,0);                                                // ack
    for(i=7;i>=0;i--) set_value_oneclock(clusterid, (0x1LL&(d[ii]>>i)) ); // D7-0
    read_ack(clusterid,0);                                                // ack
    set_start(clusterid);                                                 // start
    for(i=6;i>=0;i--) set_value_oneclock(clusterid, 0x1LL&(a>>i));        // A6-0
    set_value_oneclock(clusterid, 1);                                     // R/W
    read_ack(clusterid,0);                                                // ack
    idata[ii] = 0;
    for(i=7;i>=0;i--){
      set_value(clusterid, 0, 1);                                         // D7-0
      set_value(clusterid, 1, 1);
      read_value(clusterid, &value);
      idata[ii] |= (value<<i);
      set_value(clusterid, 0, 1);
    }
    read_ack(clusterid,1);                                                // ack
    set_stop(clusterid);                                                  // stop

    fprintf(stderr,"clusterid %d temp %d %d %d\n",clusterid,idata[0],idata[1],idata[2]);

  }  


    reset_odp(clusterid); 
    reset_hib(clusterid);
    reset_hib(clusterid);
    reset_hib(clusterid);
    set_odp_64bitmode(clusterid);


}

void mtemp()
{
  int ic;

  for (ic = 0; ic < hib_ndevice(); ic++) {
    if (Device[ic] == 0) continue;
    mtempMC(ic);
  }
}

