/*
 * GRAPE-6 global functions
 */

void g6_open_all(void)
{
    int ic;

    init_envs();
    set_resend_flags();
    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	g6_open(ic);
    }
}

void g6_close_all(void)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	g6_close(ic);
    }
}

int g6_set_j_particle_all(int address, int index, double tj, double dtj, double mass,
                          double a2by18[3], double a1by6[3], double aby2[3], double v[3], double x[3])
{
    int ic, ndev, ndev0, adr0;

    ndev0 = address % Ndevice;
    adr0 = address / Ndevice;

    for (ic = 0, ndev = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
        if (ndev == ndev0) {
            g6_set_j_particle(ic, adr0, index, tj, dtj, mass, a2by18, a1by6, aby2, v, x);
            break;
        }
        ndev++;
    }
}

int g6_set_j_particle_mxonly_all(int address, int index, double mass, double x[3])
{
    int ic, ndev, ndev0, adr0;

    ndev0 = address % Ndevice;
    adr0 = address / Ndevice;

    for (ic = 0, ndev = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
        if (ndev == ndev0) {
            g6_set_j_particle_mxonly(ic, adr0, index, mass, x);
            break;
        }
        ndev++;
    }

}

void g6_set_ti_all(double ti)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	g6_set_ti(ic, ti);
    }
}

void g6calc_firsthalf_all(int nj, int ni, int index[], double xi[][3], double vi[][3], 
                          double fold[][3], double jold[][3], double phiold[], double eps2, double h2[])
{
    int ic, ii, njj, ndev;

    for (ic = 0, ndev = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;

        // an identical set of i-particles is shared among all devices.
        for (ii= 0; ii< ni; ii++){
            g6_set_i_particle(ic, ii, index[ii], xi[ii], vi[ii], eps2, h2[ii]);
        }
        g6_set_nip(ic, ni);

        // j-particles are splited into Ndevice pieces, each containing njj particles.
        njj = nj / Ndevice;
        if (ndev < nj % Ndevice) {
	  //            njj + 1;
	  njj = njj + 1;	    
        }
        g6_set_njp(ic, njj);
        ndev++;
    }
}
void g6calc_firsthalf0_all(int nj, int ni, int index[], double xi[][3], double vi[][3], 
                           double fold[][3], double jold[][3], double phiold[], double *eps2, double h2[], int mode)
{
    int ic, ii, njj, ndev;

    for (ic = 0, ndev = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;

        // an identical set of i-particles is shared among all devices.
        if (mode == 0) {
            for (ii= 0; ii< ni; ii++){
                g6_set_i_particle(ic, ii, index[ii], xi[ii], vi[ii], eps2[ii], h2[ii]);
            }
        }
        else {
            for (ii= 0; ii< ni; ii++){
                g6_set_i_particle(ic, ii, index[ii], xi[ii], vi[ii], eps2[0], h2[ii]);
            }
        }
        g6_set_nip(ic, ni);

        // j-particles are splited into Ndevice pieces, each containing njj particles.
        njj = nj / Ndevice;
        if (ndev < nj % Ndevice) {
	  //            njj + 1;
	  njj = njj + 1;	    
        }
        g6_set_njp(ic, njj);
        ndev++;
    }
}

int g6calc_lasthalf_all(int nj, int ni, int index[], double xi[][3], double vi[][3], 
                        double eps2, double h2[], double acc[][3], double jerk[][3], double pot[])
{
    int flag[NFOMAX]; // dummy.
    g6_get_force_all(acc, jerk, pot, flag);
    return 0;
}

int g6calc_lasthalf0_all(int nj, int ni, int index[], double xi[][3], double vi[][3], 
                         double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[], int mode)
{
    int flag[NFOMAX]; // dummy.
    g6_get_force_all(acc, jerk, pot, flag);
    return 0;
}

int g6calc_lasthalf2_all(int nj, int ni, int index[], double xi[][3], double vi[][3],
                         double eps2, double h2[],
                         double acc[][3], double jerk[][3], double pot[], int nnbindex[])
{
    int flag[NFOMAX]; // dummy.
    g6_get_force_etc_all(acc, jerk, pot, nnbindex, flag);
    return 0;
}

int g6_read_neighbour_list_all(void)
{
    // to be written.
}

int g6_get_neighbour_list_all(int ipipe, int maxlength, int *nblen, int nbl[])
{
    // to be written.
}

void g6_set_nip_all(int nip)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	g6_set_nip(ic, nip);
    }
}

void g6_set_njp_all(int njp)
{
    int ic, njj, ndev;

    for (ic = 0, ndev = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;

        // j-particles are splited into Ndevice pieces, each containing njj particles.
        njj = njp / Ndevice;
        if (ndev < njp % Ndevice) {
	  //            njj + 1;
            njj = njj + 1;	    
        }
        g6_set_njp(ic, njj);
        ndev++;
    }
}

void g6_set_i_particle_scales_from_real_value_all(int address, double acc[3], double jerk[3], double phi,
                                                  double jfactor, double ffactor)
{
    // nop
}

void g6_set_i_particle_all(int address, int index, double x[3], double v[3], double eps2, double h2)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	g6_set_i_particle(ic, address, index, x, v, eps2, h2);
    }
}

int g6_get_force_all(double acc[][3], double jerk[][3], double phi[], int flag[])
{
    int ic, i, k;
    int nipmax = 0;
    static double atmp[NFOMAX][3];
    static double jtmp[NFOMAX][3];
    static double ptmp[NFOMAX];

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
        nipmax = nipmax > Nip[ic] ? nipmax : Nip[ic];
    }
    for (i = 0; i < nipmax; i++) {
        for (k = 0; k < 3; k++) {
            acc[i][k] = 0.0;
        }
        for (k = 0; k < 3; k++) {
            jerk[i][k] = 0.0;
        }
        phi[i] = 0.0;
    }

    // accumulate calculation results retrieved from all devices.
    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
        g6_get_force(ic, atmp, jtmp, ptmp, flag);
        for (i = 0; i < Nip[ic]; i++) {
            for (k = 0; k < 3; k++) {
                acc[i][k] += atmp[i][k];
            }
            for (k = 0; k < 3; k++) {
                jerk[i][k] += jtmp[i][k];
            }
            phi[i] += ptmp[i];
        }
    }
    return 0;
}

int g6_get_force_etc_all(double acc[][3], double jerk[][3], double phi[], int nnbindex[], int flag[])
{
    int           ic, i, k;
    int           nipmax = 0;
    static double atmp[NFOMAX][3];
    static double jtmp[NFOMAX][3];
    static double ptmp[NFOMAX];
    static int    ntmp[NFOMAX];    // index of the nearest neighbor.
    static double rtmp[NFOMAX];
    static double rad[NFOMAX];     // distance from the nearest neighbor.

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
        nipmax = nipmax > Nip[ic] ? nipmax : Nip[ic];
    }
    for (i = 0; i < nipmax; i++) {
        for (k = 0; k < 3; k++) {
            acc[i][k] = 0.0;
        }
        for (k = 0; k < 3; k++) {
            jerk[i][k] = 0.0;
        }
        phi[i] = 0.0;
        rad[i] = -1.0;
    }

    // accumulate calculation results retrieved from all devices.
    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;

        // this should not be replaced with g6_get_force_etc(),
        // since rtmp is used to calculate nnbindex.
        get_force_etc0(ic, atmp, jtmp, ptmp, ntmp, rtmp);

        for (i = 0; i < Nip[ic]; i++) {
            for (k = 0; k < 3; k++) {
                acc[i][k] += atmp[i][k];
            }
            for (k = 0; k < 3; k++) {
                jerk[i][k] += jtmp[i][k];
            }
            phi[i] += ptmp[i];

            // update the nearest neighbor if necessary.
            if (rad[i] < 0.0 || rad[i] > rtmp[i]) {
                rad[i] = rtmp[i];
                nnbindex[i] = ntmp[i];
            }
        }
    }
#if 0
    fprintf(stderr, "rad: ");
    for (i = 0; i < Nip[ic]; i++) {
        fprintf(stderr, "%e ", rad[i]);
    }
    fprintf(stderr, "\n");
    fprintf(stderr, "nnbindex: ");
    for (i = 0; i < Nip[ic]; i++) {
        fprintf(stderr, "%d ", nnbindex[i]);
    }
    fprintf(stderr, "\n");
    fprintf(stderr, "\n");
#endif
    return 0;
}

int g6_getnjmax_all(void)
{
    int ic;
    int njmax = 0;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (Device[ic] == 0) continue;
	njmax += g6_getnjmax(ic);
    }
    return njmax;
}
