/*
 * local variables
 */

#define NFOMAX (256) // number of forces calculated in parallel.
#define NPIPE_DEFAULT (256)
//#define DEFECT
#define DEFECTPE (15)

#define JMEMSIZE (1048576) // !!! to be checked
 
static int    Ndevice = 0;
static int    Device[NHIBMAX];
static int    Sendfunc = SENDFUNC_PIOW;
static Hib    *H[NHIBMAX];
static UINT64 *Rbuf[NHIBMAX];
static UINT64 *Wbuf[NHIBMAX];
static UINT64 Piowbuf[NHIBMAX][1024];
static UINT64 Isp[NHIBMAX][10000];
static UINT64 Idp00[NHIBMAX][10000];
static UINT64 Idp01[NHIBMAX][10000];
static UINT64 Idp10[NHIBMAX][10000];
static UINT64 Idp11[NHIBMAX][10000];        
static double Ti[NHIBMAX];
static double X_ip[NHIBMAX][NFOMAX][3];
static double V_ip[NHIBMAX][NFOMAX][3];
static double Eps2_ip[NHIBMAX][NFOMAX];
static int    Index_ip[NHIBMAX][NFOMAX];
static int    Nip[NHIBMAX];
static int    Nnbflag[NHIBMAX];
static int    Prev_njp[NHIBMAX];
static int    Resend_ip[NHIBMAX];
static int    Resend_jp[NHIBMAX];
static int    Resend_fo[NHIBMAX];
static int    Resend_nnb[NHIBMAX];
static int    Model[NHIBMAX];
static int    Npipe[NHIBMAX];
static int    Nisp[NHIBMAX];
static int    Nplus[NHIBMAX];
static int    Nispinit[NHIBMAX];


#define WARN(lv, fmt, args...) if (lv <= Warn_level) fprintf(stderr, fmt, ## args);
static int Warn_level = 2; /* warning message output level. the higher the more verbose.
                              0: no warning (may cause wrong result with g7pkg/scripts/check.csh)
                              1: minimum
                              2: default
                              3: for debugging purpose
                           */

// local fuction prototypes:
static void print_wbuf(int clusterid);
static void send_vector(int clusterid, int i0, int i1);
static void em_write(int clusterid, int nidp, int adrem);
static void run_counter(int clusterid, int nisp, int adrisp, int nrepisp, int ncntidp,int nidp,int adridp, int memadr,int nrepidp);
static void send_ispdata(int clusterid, int n, int ibegin, UINT64 ispdata[]);
static int get_force0(int clusterid, double acc[][3], double jerk[][3], double phi[], int nnbindex[], double rad[]);
static int get_force_etc0(int clusterid, double acc[][3], double jerk[][3], double phi[], int nnbindex[], double rad[]);
static void init_envs(void);
static void set_resend_flags(void);

/*
 * local functions
 */
static void send_vector(int clusterid, int i0, int i1)
{
    int i,nn,data,n;
    int par[14],j;

    n= i1-i0 +1;
    //    printf("n; %d\n", n);

    //  for(i=0;i<n;i++) printf("0x%016llx 0x%016llx %5x 0x%016llx %5x\n",Isp[clusterid][i],Idp00[clusterid][i],Idp01[clusterid][i],Idp10[clusterid][i],Idp11[clusterid][i]);

    //  for(i=0;i<n;i+=2) printf("%016llx%011llx %016llx %5x %016llx %5x %016llx %5x %016llx %5x\n",
    //			   Isp[clusterid][i],Isp[clusterid][i+1]>>20,Idp00[clusterid][i],Idp01[clusterid][i],Idp10[clusterid][i],Idp11[clusterid][i],Idp00[clusterid][i+1],Idp01[clusterid][i+1],Idp10[clusterid][i+1],Idp11[clusterid][i+1]);  
    /*
      for(i=0;i<n;i+=2){
      par[0] = (Isp[clusterid][i0+i]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[1] = (Isp[clusterid][i0+i]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[2] = (Isp[clusterid][i0+i]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[3] = (Isp[clusterid][i0+i]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[4] = (Isp[clusterid][i0+i]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[5] = (Isp[clusterid][i0+i]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[6] = (Isp[clusterid][i0+i]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);
      par[7] = (Isp[clusterid][i0+i]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((Isp[clusterid][i0+i]>>j) & 0x1);

      par[8] = (Isp[clusterid][i0+i+1]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);
      par[9] = (Isp[clusterid][i0+i+1]>>48) & 0x1; for(j=49;j<56;j++) par[9] = par[9] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);
      par[10] = (Isp[clusterid][i0+i+1]>>40) & 0x1; for(j=41;j<48;j++) par[10] = par[10] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);
      par[11] = (Isp[clusterid][i0+i+1]>>32) & 0x1; for(j=33;j<40;j++) par[11] = par[11] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);
      par[12] = (Isp[clusterid][i0+i+1]>>24) & 0x1; for(j=25;j<32;j++) par[12] = par[12] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);
      par[13] = (Isp[clusterid][i0+i+1]>>16) & 0x1; for(j=17;j<24;j++) par[13] = par[13] ^ ((Isp[clusterid][i0+i+1]>>j) & 0x1);

      Isp[clusterid][i0+i+1] = Isp[clusterid][i0+i+1] | ((par[0]&0x1)<<15)|((par[1]&0x1)<<14)|((par[2]&0x1)<<13)|((par[3]&0x1)<<12)
      |((par[4]&0x1)<<11)|((par[5]&0x1)<<10)|((par[6]&0x1)<<9)|((par[7]&0x1)<<8)|((par[8]&0x1)<<7)|((par[9]&0x1)<<6)
      |((par[10]&0x1)<<5)|((par[11]&0x1)<<4)|((par[12]&0x1)<<3)|((par[13]&0x1)<<2);

      }

      for(i=0;i<n;i++){
      par[0] = (Idp00[clusterid][i0+i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[1] = (Idp00[clusterid][i0+i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[2] = (Idp00[clusterid][i0+i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[3] = (Idp00[clusterid][i0+i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[4] = (Idp00[clusterid][i0+i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[5] = (Idp00[clusterid][i0+i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[6] = (Idp00[clusterid][i0+i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((Idp00[clusterid][i0+i]>>j) & 0x1);
      par[7] = (Idp00[clusterid][i0+i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((Idp01[clusterid][i0+i]>>j) & 0x1);
      Idp01[clusterid][i0+i] = Idp01[clusterid][i0+i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
      |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1);

      par[0] = (Idp10[clusterid][i0+i]>>55) & 0x1; for(j=56;j<64;j++) par[0] = par[0] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[1] = (Idp10[clusterid][i0+i]>>46) & 0x1; for(j=47;j<55;j++) par[1] = par[1] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[2] = (Idp10[clusterid][i0+i]>>37) & 0x1; for(j=38;j<46;j++) par[2] = par[2] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[3] = (Idp10[clusterid][i0+i]>>28) & 0x1; for(j=29;j<37;j++) par[3] = par[3] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[4] = (Idp10[clusterid][i0+i]>>19) & 0x1; for(j=20;j<28;j++) par[4] = par[4] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[5] = (Idp10[clusterid][i0+i]>>10) & 0x1; for(j=11;j<19;j++) par[5] = par[5] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[6] = (Idp10[clusterid][i0+i]>> 1) & 0x1; for(j= 2;j<10;j++) par[6] = par[6] ^ ((Idp10[clusterid][i0+i]>>j) & 0x1);
      par[7] = (Idp10[clusterid][i0+i]    ) & 0x1; for(j= 9;j<17;j++) par[7] = par[7] ^ ((Idp11[clusterid][i0+i]>>j) & 0x1);
      Idp11[clusterid][i0+i] = Idp11[clusterid][i0+i] | ((par[0]&0x1)<<8)|((par[1]&0x1)<<7)|((par[2]&0x1)<<6)|((par[3]&0x1)<<5)
      |((par[4]&0x1)<<4)|((par[5]&0x1)<<3)|((par[6]&0x1)<<2)|((par[7]&0x1)<<1);
      }
    */
    /* ISP */
    Rbuf[clusterid][0] = 0x0000000400000000ll | n ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = Isp[clusterid][i0+i];
    //for(i=0;i<n+1;i++) printf("i %x %d Rbuf 0x%016llx isp 0x%016llx\n",i,i,Rbuf[clusterid][i],Isp[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

    //     printf("isp; flags data 0x%016llx\n", data);
 
    /* IDP00 */
    Rbuf[clusterid][0] = 0x0000000000000000ll | n ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = Idp00[clusterid][i0+i];
    //for(i=0;i<n+1;i++) printf("idp00 i %x %d Rbuf 0x%016llx\n",i,i,Rbuf[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

    //     printf("idp00; flags data 0x%016llx\n", data);

    /* IDP01 */
    Rbuf[clusterid][0] = 0x0000000100000000ll | n ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = Idp01[clusterid][i0+i];
    //for(i=0;i<n+1;i++) printf("idp01 i %x %d Rbuf 0x%016llx\n",i,i,Rbuf[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

    //     printf("idp01; flags data 0x%016llx\n", data);

    /* IDP10 */
    Rbuf[clusterid][0] = 0x0000000200000000ll | n ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = Idp10[clusterid][i0+i];
    //for(i=0;i<n+1;i++) printf("idp10 i %x %d Rbuf 0x%016llx\n",i,i,Rbuf[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

    //     printf("idp10; flags data 0x%016llx\n", data);

    /* IDP11 */
    Rbuf[clusterid][0] = 0x0000000300000000ll | n ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = Idp11[clusterid][i0+i];
    //for(i=0;i<n+1;i++) printf("idp11 i %x %d Rbuf 0x%016llx\n",i,i,Rbuf[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

    //     printf("idp11; flags data 0x%016llx\n", data);

    /* RUN */
    nn=1;
    Rbuf[clusterid][0] = 0x0000000800000000ll | nn;
    for(i=1;i<nn+1;i++) Rbuf[clusterid][i] = 0x0000000000000000ll;
    //for(i=0;i<n;i++) printf("i %x %d Rbuf 0x%016llx\n",i,i,Rbuf[clusterid][i]);
    hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);


}

static void em_write(int clusterid, int nidp, int adrem)
{
    int nn,ii;

    nn = 5*nidp;
    Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
    for(ii=0;ii<nidp;ii++){
        Rbuf[clusterid][5*ii+1] = ((UINT64)(ii+adrem))<<32 | (0xff&Idp01[clusterid][2*ii])<<24 | (0xff&Idp11[clusterid][2*ii])<<16
            | (0xff&Idp01[clusterid][2*ii+1])<<8 | (0xff&Idp11[clusterid][2*ii+1]);
        Rbuf[clusterid][5*ii+2] = Idp00[clusterid][2*ii];
        Rbuf[clusterid][5*ii+3] = Idp10[clusterid][2*ii];
        Rbuf[clusterid][5*ii+4] = Idp00[clusterid][2*ii+1];
        Rbuf[clusterid][5*ii+5] = Idp10[clusterid][2*ii+1];
    }
    //   for(ii=0;ii<nn+1;ii++) printf("idp00 ii %x %d Rbuf 0x%016llx\n",ii,ii,Rbuf[clusterid][ii]);
    hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);
}

static void run_counter(int clusterid, int nisp,int adrisp,int nrepisp,
                        int ncntidp,int nidp,int adridp, int memadr,int nrepidp)
{
    int i,id,size;

    Rbuf[clusterid][0] = 0x0000000e00000002ll | ((UINT64)nisp)<<48 | adrisp<<16;
    Rbuf[clusterid][1] = 0x0000000000000000ll | ((UINT64)nrepisp)<<40 | ((UINT64)ncntidp)<<24 | nrepidp;
    Rbuf[clusterid][2] = 0x0000000000000000ll | ((UINT64)adridp)<<48 | ((UINT64)nidp)<<32 | memadr ;

    hib_sendMC(clusterid, 3, Rbuf[clusterid]);
}

static void send_ispdata(int clusterid, int n, int ibegin, UINT64 ispdata[])
{
    int i;

    Rbuf[clusterid][0] = 0x0000000600000000ll | n | ibegin<<16 ;
    for(i=0;i<n;i++) Rbuf[clusterid][i+1] = ispdata[i];
    //for(i=0;i<n+1;i++) printf("i %x %d Rbuf 0x%016llx isp 0x%016llx\n",i,i,Rbuf[clusterid][i],Isp[clusterid][i]);
    hib_sendMC(clusterid, n+1, Rbuf[clusterid]);

}

static void reset_odp(int clusterid)
{
    Rbuf[clusterid][0] = 0x0000000b00000007ll;
    Rbuf[clusterid][1] = 0x0000000000000000ll;
    Rbuf[clusterid][2] = 0x0000000000000000ll;
    Rbuf[clusterid][3] = 0x0000000000000007ll;
    Rbuf[clusterid][4] = 0x0000000000000007ll;
    Rbuf[clusterid][5] = 0x0000000000000007ll;            
    Rbuf[clusterid][6] = 0x0000000000000007ll;
    Rbuf[clusterid][7] = 0x0000000000000000ll;            

    hib_sendMC(clusterid, 8, Rbuf[clusterid]);
}

static void set_odp_64bitmode(int clusterid)
{
  int i;

    Rbuf[clusterid][0] = 0x0000000b00000007ll;
    for(i=1;i<8;i++) Rbuf[clusterid][i] = 0x0000000000000008ll;
    hib_sendMC(clusterid, 8, Rbuf[clusterid]);
}

static void reset_hib(int clusterid)
{
    if (H[clusterid]->type == HIB_GRAPEDRG) {
        hib_mem_writeMC(clusterid, H[clusterid]->r->dma0cmd, (1 << H[clusterid]->r->dma0cmd_abort_bit));
        hib_mem_writeMC(clusterid, H[clusterid]->r->dma1cmd, (1 << H[clusterid]->r->dma1cmd_abort_bit));
    }
    else {
        hib_mem_writeMC(clusterid, H[clusterid]->r->command, (1<<H[clusterid]->r->command_dma_reset_bit));
    }
}

static void print_wbuf(int clusterid)
{
    int ii,j,perror,par[9];
      
    perror=0;
    /*      
            for(ii=0;ii<64;ii++){
            par[0] = (Wbuf[clusterid][4*ii+1]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[1] = (Wbuf[clusterid][4*ii+1]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[2] = (Wbuf[clusterid][4*ii+1]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[3] = (Wbuf[clusterid][4*ii+1]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[4] = (Wbuf[clusterid][4*ii+1]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[5] = (Wbuf[clusterid][4*ii+1]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[6] = (Wbuf[clusterid][4*ii+1]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[7] = (Wbuf[clusterid][4*ii+1]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((Wbuf[clusterid][4*ii+1]>>j) & 0x1);
            par[8] = (Wbuf[clusterid][4*ii+0]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((Wbuf[clusterid][4*ii+0]>>j) & 0x1);
            for(j=0;j<9;j++){
            if(par[j]!= ((Wbuf[clusterid][4*ii+0]>>(55-j))&0x1)) perror = 1;
            }
            par[0] = (Wbuf[clusterid][4*ii+3]>>56) & 0x1; for(j=57;j<64;j++) par[0] = par[0] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[1] = (Wbuf[clusterid][4*ii+3]>>48) & 0x1; for(j=49;j<56;j++) par[1] = par[1] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[2] = (Wbuf[clusterid][4*ii+3]>>40) & 0x1; for(j=41;j<48;j++) par[2] = par[2] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[3] = (Wbuf[clusterid][4*ii+3]>>32) & 0x1; for(j=33;j<40;j++) par[3] = par[3] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[4] = (Wbuf[clusterid][4*ii+3]>>24) & 0x1; for(j=25;j<32;j++) par[4] = par[4] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[5] = (Wbuf[clusterid][4*ii+3]>>16) & 0x1; for(j=17;j<24;j++) par[5] = par[5] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[6] = (Wbuf[clusterid][4*ii+3]>> 8) & 0x1; for(j= 9;j<16;j++) par[6] = par[6] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[7] = (Wbuf[clusterid][4*ii+3]    ) & 0x1; for(j= 1;j< 8;j++) par[7] = par[7] ^ ((Wbuf[clusterid][4*ii+3]>>j) & 0x1);
            par[8] = (Wbuf[clusterid][4*ii+2]>>56) & 0x1; for(j=57;j<64;j++) par[8] = par[8] ^ ((Wbuf[clusterid][4*ii+2]>>j) & 0x1);
            for(j=0;j<9;j++){
            if(par[j]!= ((Wbuf[clusterid][4*ii+2]>>(55-j))&0x1)) perror = 1;
            }

            if(perror==1){
            //         printf("%016llx%02x %03x %016llx%02x %03x *****\n",Wbuf[clusterid][4*ii+1],0xff&(Wbuf[clusterid][4*ii+0]>>56),0x1ff&(Wbuf[clusterid][4*ii+0]>>47),
            //                Wbuf[clusterid][4*ii+3],0xff&(Wbuf[clusterid][4*ii+2]>>56),0x1ff&(Wbuf[clusterid][4*ii+2]>>47));
            }
            }
    */
}

#include "./mtemp.c"

/*
 * initialize variables used for "standard" functions.  this
 * initialization is not necessary for "primitive" functions, or even
 * harmful for use in multi-threaded application.
 */
static void init_envs(void)
{
    int ic;
    int dummy[NHIBMAX];
    char *p;
    char *cardno;
    static int firstcall = 1;

    if (firstcall) {
        firstcall = 0;

        for (ic = 0; ic < hib_ndevice(); ic++) {
            Nip[ic] = 0;
            Nnbflag[ic] = 0;
            Prev_njp[ic] = 0;
        }

	p = getenv("G6_WARNLEVEL");
        if (p) {
            int tmp;
            tmp = atoi(strtok(p, " "));
            if (0 <= tmp) {
                Warn_level = tmp;
            }
            WARN(3, "Warn_level: %d\n", Warn_level);
        }
        hib_set_warn_level(Warn_level);

	p = getenv("G6_SENDFUNC");
        if (p) {
	    if (0 == strcmp("DMAR", p)) {
		Sendfunc = SENDFUNC_DMAR;
	    }
        }
    }

    if (Ndevice == 0) {
        /* cards are not allocated yet.
           try to allocate cards specified by environment variable "GDEVICE".
           try to allocate all cards, if GDEVICE is not set. */

	p = getenv("GDEVICE");	
	if (p) { // parse GDEVICE
	    for (ic = 0; ic < hib_ndevice(); ic++) {
		Device[ic] = 0;
	    }
            cardno = strtok(p, " ");
            while (cardno) {
                ic = atoi(cardno);
                if (ic < 0 || ic >= hib_ndevice()) {
                    fprintf(stderr, "GDEVICE have device_id out of range: %d\n", ic);
                    exit(2);
                }
                Device[ic] = 1;
                Ndevice++;
                cardno = strtok(NULL, " ");
            }
            
	}
	else { // GDEVICE is not set
	    Ndevice = hib_ndevice();
	    for (ic = 0; ic < hib_ndevice(); ic++) {
		Device[ic] = 1;
	    }
	}
    }
}

static void set_resend_flags(void)
{
    int ic;
    for (ic = 0; ic < hib_ndevice(); ic++) {
        Resend_ip[ic] = 1;
        Resend_jp[ic] = 1;
        Resend_fo[ic] = 1;
        Resend_nnb[ic] = 1;
    }
}

/*
 * GRAPE-6 primitive functions
 */


#include "vsm/vsmconst0.c"
#include "vsm/vsmconst.hermite.c"
#include "vsm/vsmconst.hermite2.c"
#include "vsm/vsmconst.hermite2_nnb.c"

void g6_open(int clusterid)
{    
    int i0,i1,i;
    UINT32 binfo,productid,modelid;

    init_envs();
    set_resend_flags();

    H[clusterid] = hib_openMC(clusterid);

    hib_set_sendfuncMC(clusterid, SENDFUNC_PIOW);
    Rbuf[clusterid] = Piowbuf[clusterid];

    //     hib_set_sendfuncMC(clusterid, SENDFUNC_DMAR);
    //     Rbuf = H[clusterid]->dmar_buf;

    Wbuf[clusterid] = H[clusterid]->dmaw_buf;

    //#define DMASTAT  (0x20)
    //    TBmemWrite(0, DMASTAT, 0x80000000);
    reset_hib(clusterid);

    Npipe[clusterid] = NPIPE_DEFAULT;

    if(Npipe[clusterid] == 128)  hermite_send_vsm_constant(clusterid);
    if(Npipe[clusterid] == 256)  hermite2_send_vsm_constant(clusterid);

    binfo = hib_mem_readMC(clusterid, H[clusterid]->r->boardinfo);
    productid = (binfo >> 28) & 0xf;
    modelid = (binfo >> 24) & 0xf;
    if(modelid==3) Model[clusterid] = 460;
    if(modelid==4) Model[clusterid] = 460;    

    if(Model[clusterid]==460) mtempMC(clusterid);

    reset_odp(clusterid);   // reset odpfifo and flag
    reset_hib(clusterid);
    reset_hib(clusterid);
    reset_hib(clusterid);
    if(Model[clusterid]==460) set_odp_64bitmode(clusterid);
    
}

void g6_close(int clusterid)
{
    hib_closeMC(clusterid);
}

void g6_set_tunit(int newtunit)
{
    // nop
}

void g6_set_xunit(int newxunit)
{
    // nop
}

int g6_set_j_particle(int clusterid, int address,
                      int index,
                      double tj, /* particle time */
                      double dtj, /* particle time */
                      double mass,
                      double a2by18[3], /* a2dot divided by 18 */
                      double a1by6[3], /* a1dot divided by 6 */
                      double aby2[3], /* a divided by 2 */
                      double v[3], /* velocity */
                      double x[3] /* position */)
{

    int i0,i1,i,nn,ii;
    UINT64 id,adrbm,tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9,ibb;
    UINT64 tmp10,tmp11,tmp12;
    int adrem,nidp;

    adrem = (address /16) *49 + 1 + 3*(address % 16);

    Idp00[clusterid][0] = *((UINT64 *)(&x[0]));    Idp01[clusterid][0] = 0x1;
    Idp10[clusterid][0] = *((UINT64 *)(&x[1]));    Idp11[clusterid][0] = 0x1;

    Idp00[clusterid][1] = *((UINT64 *)(&x[2]));    Idp01[clusterid][1] = 0x1;
    Idp10[clusterid][1] = *((UINT64 *)(&tj));      Idp11[clusterid][1] = 0x1;

    tmp0 =  *((UINT64 *)(&a2by18[0]));
    tmp1 =  *((UINT64 *)(&a2by18[1]));
    tmp2 =  *((UINT64 *)(&a2by18[2]));
    tmp3 =  *((UINT64 *)(&a1by6[0]));
    tmp4 =  *((UINT64 *)(&a1by6[1]));
    tmp5 =  *((UINT64 *)(&a1by6[2]));
    tmp6 =  *((UINT64 *)(&aby2[0]));
    tmp7 =  *((UINT64 *)(&aby2[1]));
    tmp8 =  *((UINT64 *)(&aby2[2]));
    tmp9 =  *((UINT64 *)(&v[0]));
    tmp10 =  *((UINT64 *)(&v[1]));
    tmp11 =  *((UINT64 *)(&v[2]));

    if(Model[clusterid]==460){

      Idp00[clusterid][2] =  (0xc000000000000000&tmp0) | (0x3fffffff00000000&(tmp0<<3)) | (0xc0000000&(tmp1>>32)) | (0x3fffffff&(tmp1>>29));
      Idp01[clusterid][2] =  0x13;
      Idp10[clusterid][2] =  (0xc000000000000000&tmp2) | (0x3fffffff00000000&(tmp2<<3)) | (0xc0000000&(tmp3>>32)) | (0x3fffffff&(tmp3>>29));
      Idp11[clusterid][2] =  0x13;
      Idp00[clusterid][3] =  (0xc000000000000000&tmp4) | (0x3fffffff00000000&(tmp4<<3)) | (0xc0000000&(tmp5>>32)) | (0x3fffffff&(tmp5>>29));
      Idp01[clusterid][3] =  0x13;
      Idp10[clusterid][3] =  (0xc000000000000000&tmp6) | (0x3fffffff00000000&(tmp6<<3)) | (0xc0000000&(tmp7>>32)) | (0x3fffffff&(tmp7>>29));
      Idp11[clusterid][3] =  0x13;
      Idp00[clusterid][4] =  (0xc000000000000000&tmp8) | (0x3fffffff00000000&(tmp8<<3)) | (0xc0000000&(tmp9>>32)) | (0x3fffffff&(tmp9>>29));
      Idp01[clusterid][4] =  0x13;
      Idp10[clusterid][4] =  (0xc000000000000000&tmp10) | (0x3fffffff00000000&(tmp10<<3)) | (0xc0000000&(tmp11>>32)) | (0x3fffffff&(tmp11>>29));
      Idp11[clusterid][4] =  0x13;
      tmp12 = (*((UINT64 *)(&mass)));
      Idp00[clusterid][5] =  (0xc000000000000000&tmp12) | (0x3fffffff00000000&(tmp12<<3));
      Idp01[clusterid][5] =  0x13;
      Idp10[clusterid][5] =  ((UINT64)index)<<32;
      Idp11[clusterid][5] =  0x25;

    }else{

      Idp00[clusterid][2] =  (0xfffffffff0000000&tmp0) | (0xfffffff&(tmp1>>36));
      Idp01[clusterid][2] =  (0xff&(tmp1>>28))<<9 | 0x1;
      Idp10[clusterid][2] =  (0xfffffffff0000000&tmp2) | (0xfffffff&(tmp3>>36));
      Idp11[clusterid][2] =  (0xff&(tmp3>>28))<<9 | 0x1;
      Idp00[clusterid][3] =  (0xfffffffff0000000&tmp4) | (0xfffffff&(tmp5>>36));
      Idp01[clusterid][3] =  (0xff&(tmp5>>28))<<9 | 0x1;
      Idp10[clusterid][3] =  (0xfffffffff0000000&tmp6) | (0xfffffff&(tmp7>>36));
      Idp11[clusterid][3] =  (0xff&(tmp7>>28))<<9 | 0x1;
      Idp00[clusterid][4] =  (0xfffffffff0000000&tmp8) | (0xfffffff&(tmp9>>36));
      Idp01[clusterid][4] =  (0xff&(tmp9>>28))<<9 | 0x1;
      Idp10[clusterid][4] =  (0xfffffffff0000000&tmp10) | (0xfffffff&(tmp11>>36));
      Idp11[clusterid][4] =  (0xff&(tmp11>>28))<<9 | 0x1;
      Idp00[clusterid][5] =  0xfffffffff0000000&(*((UINT64 *)(&mass))); Idp01[clusterid][5] = 0x1;
      Idp10[clusterid][5] =  ((UINT64)index)<<28;  Idp11[clusterid][5] = 0x1;

    } 

    nidp = 3;
    em_write(clusterid, nidp, adrem);

}

int g6_set_j_particle_mxonly(int  clusterid,
                             int address,
                             int index,
                             double mass,
                             double x[3] /* position */)
{
    double tj = 0.0;
    double dtj = 1.0;
    double a2by18[3];
    double a1by6[3];
    double aby2[3];
    double v[3];
    int k;
    for(k=0;k<3;k++){
        a2by18[k] = 0.0;
        a1by6[k] = 0.0;
        aby2[k] = 0.0;
        v[k] = 0.0;
    }
    return g6_set_j_particle(clusterid,address,index,tj,dtj,mass,
                             a2by18, a1by6, aby2, v, x);
}

void g6_set_ti(int clusterid, double ti)
{
    Ti[clusterid] = ti;
}

void g6calc_firsthalf(int clusterid, 
                      int nj,  
                      int ni,  
                      int index[],  
                      double xi[][3],  
                      double vi[][3],  
                      double fold[][3],
                      double jold[][3],  
                      double phiold[],  
                      double eps2,   
                      double h2[])  
{
    int ii;

    for (ii= 0; ii< ni; ii++){
        g6_set_i_particle(clusterid, ii, index[ii], xi[ii], vi[ii], eps2, h2[ii]);
    }
    g6_set_nip(clusterid, ni);
    g6_set_njp(clusterid, nj);
}

void g6calc_firsthalf0(int clusterid,
                       int nj,
                       int ni,
                       int index[],
                       double xi[][3],
                       double vi[][3], 
                       double fold[][3],
                       double jold[][3],
                       double phiold[],
                       double *eps2,
                       double h2[],
                       int mode)
{
    int ii;

    if (mode == 0) {
        for (ii= 0; ii< ni; ii++){
            g6_set_i_particle(clusterid, ii, index[ii], xi[ii], vi[ii], eps2[ii], h2[ii]);
        }
    }
    else {
        for (ii= 0; ii< ni; ii++){
            g6_set_i_particle(clusterid, ii, index[ii], xi[ii], vi[ii], eps2[0], h2[ii]);
        }
    }
    g6_set_nip(clusterid, ni);
    g6_set_njp(clusterid, nj);
}

int g6calc_lasthalf(int clusterid,
                    int nj,
                    int ni,
                    int index[],
                    double xi[][3],
                    double vi[][3],
                    double eps2,
                    double h2[], 
                    double acc[][3],
                    double jerk[][3],
                    double pot[])     
{
    int flag[NFOMAX]; // dummy.
    g6_get_force(clusterid, acc, jerk,pot,flag);
    return 0;
}

int g6calc_lasthalf0(int clusterid,
                     int nj,
                     int ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double *eps2,
                     double h2[],
                     double acc[][3],
                     double jerk[][3],
                     double pot[],
                     int mode)
{
    int flag[NFOMAX]; // dummy.
    g6_get_force(clusterid, acc, jerk,pot,flag);
    return 0;
}

int g6calc_lasthalf2(int clusterid,
                     int nj,
                     int ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double eps2,
                     double h2[], 
                     double acc[][3],
                     double jerk[][3],
                     double pot[],     
                     int nnbindex[])
{
    int flag[NFOMAX]; // dummy.
    g6_get_force_etc(clusterid, acc, jerk,pot,nnbindex,flag);
    return 0;
}

int g6_read_neighbour_list(int clusterid)
{
    // to be written.
}

int g6_get_neighbour_list(int clusterid,
                          int ipipe,
                          int maxlength,
                          int *nblen,
                          int nbl[])
{
    // to be written.
}

void g6_set_neighbour_list_sort_mode(int mode)
{
    // nop
}

int g6_get_neighbour_list_sort_mode(void)
{
    // nop
}

int g6_npipes(void)
{
#ifdef DEFECT
  return NPIPE_DEFAULT-8 ;   
#else
  return NPIPE_DEFAULT ;   // caution  
#endif
}

void g6_set_nip(int clusterid, int nip)
{
  int i,ii,i0,i1,iii,k,ibegin,n,nn,nidp,adrem,niii,ni,ni2,ni3,offset;
    UINT64 id,ipe;
    UINT64 tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7;
    UINT64 adr_xi[3][3],adr_vi[3][3],adr_eps2i[3],adr_idxi[3],adr_tih[3];

    Nip[clusterid] = nip;

    if(Npipe[clusterid] == 128){
      adr_xi[0][0] = 0x0;   adr_xi[0][1] = 0x8;  adr_xi[0][2] = 0x10;
      adr_vi[0][0] = 0x18;  adr_vi[0][1] = 0x1c;  adr_vi[0][2] = 0x20;
      adr_eps2i[0] = 0x24;  adr_idxi[0] = 0x28;   adr_tih[0] = 0x30;
      niii = 1;
    }

    if(Npipe[clusterid] == 256){
      adr_xi[0][0] = 0x0;   adr_xi[0][1] = 0x8;  adr_xi[0][2] = 0x10;
      adr_vi[0][0] = 0x18;  adr_vi[0][1] = 0x1c;  adr_vi[0][2] = 0x20;
      adr_eps2i[0] = 0x24;  adr_idxi[0] = 0x28;   adr_tih[0] = 0x30;
      adr_xi[1][0] = 0x34;  adr_xi[1][1] = 0x3c;  adr_xi[1][2] = 0x44;
      adr_vi[1][0] = 0x4c;  adr_vi[1][1] = 0x50;  adr_vi[1][2] = 0x54;
      adr_eps2i[1] = 0x58;  adr_idxi[1] = 0x5c;   adr_tih[1] = 0x64;
#ifdef DEFECT
      if(Nip[clusterid]<125){
#else
      if(Nip[clusterid]<129){
#endif
        niii = 1;
      }else{
        niii = 2;
      }
    }

    if(Model[clusterid]==460){
      int ioffset[10];
      for(k=0;k<6;k++) ioffset[k] = 0;

      for(iii=0;iii<niii;iii++){
#ifdef DEFECT
	if(((iii+1)*124)>Nip[clusterid]){
	  ni = (Nip[clusterid]-iii*124+3+4)/4;
#else
	if(((iii+1)*128)>Nip[clusterid]){
	  ni = (Nip[clusterid]-iii*128+3)/4;
#endif
	}else{
	  ni = 32;
	}
        ni2 = ni;
        //	if(ni<10) ni2 = 9;   /** required **/
	//        if(ni<15) ni2 = 14;   /** required **/
        ni2 = 32;   /** required **/
	offset = 0;

          /**  X_ip[clusterid][0],X_ip[clusterid][1],X_ip[clusterid][2] **/

        for(k=0;k<3;k++){

          Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
          Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = ((UINT64)(ni2*4))<<56; Idp11[clusterid][1] = 0x1;  
          for(i=0;i<ni;i++){
            Idp00[clusterid][2+2*i]   = *((UINT64 *)(&X_ip[clusterid][4*i  +128*iii+ioffset[k]][k]));
            Idp10[clusterid][2+2*i]   = *((UINT64 *)(&X_ip[clusterid][4*i+1+128*iii+ioffset[k]][k]));
            Idp00[clusterid][2+2*i+1] = *((UINT64 *)(&X_ip[clusterid][4*i+2+128*iii+ioffset[k]][k]));
            Idp10[clusterid][2+2*i+1] = *((UINT64 *)(&X_ip[clusterid][4*i+3+128*iii+ioffset[k]][k]));
#ifdef DEFECT
            if((4*i+3)==DEFECTPE){
              if(iii == 0) ioffset[k] = -4;
              if(iii == 1) ioffset[k] = -8;          
            }
#endif
	  }
          for(i=0;i<ni2;i++){
            Idp01[clusterid][2+2*i] = 0x1;
	    Idp11[clusterid][2+2*i] = 0x1;  
            Idp01[clusterid][2+2*i+1] = 0x1;
	    Idp11[clusterid][2+2*i+1] = 0x1;  
          }
          nidp = 1+ni2; adrem = 0x700000;
          em_write(clusterid, nidp, adrem);
          run_counter(clusterid,0,0,0,8*nidp+offset,nidp,0,adrem,1);  

          if(Resend_ip[clusterid]==1){
            Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
            Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
            i=4;
            for(ipe=0;ipe<32;ipe++){
              Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
              Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
              Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_xi[iii][k]<<11);
              Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 
              i+=6; 
            }
            n = i; ibegin = 2000 + 200*k + 1400*iii;
            send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
          }
          n = 4+ni*6; ibegin = 2000 + 200*k + 1400*iii ;
          run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

        }

          /**  V_ip[clusterid][0],V_ip[clusterid][1] **/

        Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
        Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = ((UINT64)(ni2*4))<<56; Idp11[clusterid][1] = 0x1;  
        for(i=0;i<ni;i++){
          tmp0 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii+ioffset[3]][0]));
          tmp1 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii+ioffset[3]][0]));
          tmp2 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii+ioffset[3]][0]));
          tmp3 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii+ioffset[3]][0]));
          tmp4 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii+ioffset[3]][1]));
          tmp5 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii+ioffset[3]][1]));
          tmp6 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii+ioffset[3]][1]));
          tmp7 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii+ioffset[3]][1]));
#ifdef DEFECT
            if((4*i+3)==DEFECTPE){
              if(iii == 0) ioffset[3] = -4;
              if(iii == 1) ioffset[3] = -8;          
            }
#endif
          Idp00[clusterid][2+2*i] = (0xc000000000000000&tmp0) | (0x3fffffff00000000&(tmp0<<3)) | (0xc0000000&(tmp1>>32)) | (0x3fffffff&(tmp1>>29));
          Idp10[clusterid][2+2*i] =  (0xc000000000000000&tmp2) | (0x3fffffff00000000&(tmp2<<3)) | (0xc0000000&(tmp3>>32)) | (0x3fffffff&(tmp3>>29));
          Idp00[clusterid][2+2*i+1] =  (0xc000000000000000&tmp4) | (0x3fffffff00000000&(tmp4<<3)) | (0xc0000000&(tmp5>>32)) | (0x3fffffff&(tmp5>>29));
          Idp10[clusterid][2+2*i+1] =  (0xc000000000000000&tmp6) | (0x3fffffff00000000&(tmp6<<3)) | (0xc0000000&(tmp7>>32)) | (0x3fffffff&(tmp7>>29));
	}
        for(i=0;i<ni2;i++){
          Idp01[clusterid][2+2*i] =  0x13;
          Idp11[clusterid][2+2*i] =  0x13;
          Idp01[clusterid][2+2*i+1] =  0x13;
          Idp11[clusterid][2+2*i+1] =  0x13;
        }
        nidp = ni2+1; adrem = 0x700000;
        em_write(clusterid, nidp, adrem);
        run_counter(clusterid,0,0,0,8*nidp+offset,nidp,0,adrem,1);  

        if(Resend_ip[clusterid]==1){
          Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
          Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
          i=4;
          for(ipe=0;ipe<32;ipe++){
            Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
            Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
            Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_vi[iii][0]<<11);
            Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 	
            i+=6; 
          }
          n = i; ibegin = 2600 + 1400*iii ;
          send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
	}
        n = 4+ni*6; ibegin = 2600 + 1400*iii ;
        run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

          /**  V_ip[clusterid][2],Eps2_ip[clusterid] **/

        Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
        Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = ((UINT64)(ni2*4))<<56; Idp11[clusterid][1] = 0x1;  
        for(i=0;i<ni;i++){
          tmp0 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii+ioffset[4]][2]));
          tmp1 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii+ioffset[4]][2]));
          tmp2 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii+ioffset[4]][2]));
          tmp3 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii+ioffset[4]][2]));
          tmp4 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i  +128*iii+ioffset[4]]));
          tmp5 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+1+128*iii+ioffset[4]]));
          tmp6 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+2+128*iii+ioffset[4]]));
          tmp7 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+3+128*iii+ioffset[4]]));
#ifdef DEFECT
            if((4*i+3)==DEFECTPE){
              if(iii == 0) ioffset[4] = -4;
              if(iii == 1) ioffset[4] = -8;          
            }
#endif
          Idp00[clusterid][2+2*i] = (0xc000000000000000&tmp0) | (0x3fffffff00000000&(tmp0<<3)) | (0xc0000000&(tmp1>>32)) | (0x3fffffff&(tmp1>>29));
          Idp10[clusterid][2+2*i] = (0xc000000000000000&tmp2) | (0x3fffffff00000000&(tmp2<<3)) | (0xc0000000&(tmp3>>32)) | (0x3fffffff&(tmp3>>29));
          Idp00[clusterid][2+2*i+1] =  (0xc000000000000000&tmp4) | (0x3fffffff00000000&(tmp4<<3)) | (0xc0000000&(tmp5>>32)) | (0x3fffffff&(tmp5>>29));
          Idp10[clusterid][2+2*i+1] =  (0xc000000000000000&tmp6) | (0x3fffffff00000000&(tmp6<<3)) | (0xc0000000&(tmp7>>32)) | (0x3fffffff&(tmp7>>29));
	}
        for(i=0;i<ni2;i++){
          Idp01[clusterid][2+2*i] =  0x13;
          Idp11[clusterid][2+2*i] =  0x13;
          Idp01[clusterid][2+2*i+1] =  0x13;
          Idp11[clusterid][2+2*i+1] =  0x13;
        }
        nidp = 1+ni2; adrem = 0x700000;
        em_write(clusterid, nidp, adrem);
        run_counter(clusterid,0,0,0,8*nidp+offset,nidp,0,adrem,1);  

        if(Resend_ip[clusterid]==1){
          Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
          Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
          i=4;
          for(ipe=0;ipe<32;ipe++){
            Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
            Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
            Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_vi[iii][2]<<11);
            Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 
            i+=6; 
          }
          n = i; ibegin = 2800 + 1400*iii ;
          send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
	}
        n = 4+ni*6; ibegin = 2800 + 1400*iii ;
        run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM
    
          /**  Index_ip[clusterid], ti(half) **/

        Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
        Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = ((UINT64)(ni2*4))<<56; Idp11[clusterid][1] = 0x1;  
        for(i=0;i<ni;i++){
          tmp0 =  (UINT64)Index_ip[clusterid][4*i  +128*iii+ioffset[5]];
          tmp1 =  (UINT64)Index_ip[clusterid][4*i+1+128*iii+ioffset[5]];
          tmp2 =  (UINT64)Index_ip[clusterid][4*i+2+128*iii+ioffset[5]];
          tmp3 =  (UINT64)Index_ip[clusterid][4*i+3+128*iii+ioffset[5]];
#ifdef DEFECT
            if((4*i+3)==DEFECTPE){
              if(iii == 0) ioffset[5] = -4;
              if(iii == 1) ioffset[5] = -8;          
            }
#endif
          Idp00[clusterid][2+2*i] =  (tmp0<<32) | tmp1;
          Idp10[clusterid][2+2*i] =  (tmp2<<32) | tmp3;
          Idp00[clusterid][2+2*i+1]   = *((UINT64 *)(&(Ti[clusterid]))) ;
          Idp10[clusterid][2+2*i+1]   = *((UINT64 *)(&(Ti[clusterid]))) ; 
	}
        for(i=0;i<ni2;i++){
	  Idp01[clusterid][2+2*i] =  0x25;
          Idp11[clusterid][2+2*i] =  0x25;
          Idp01[clusterid][2+2*i+1] = 0x1;
          Idp11[clusterid][2+2*i+1] = 0x1;
        }
        nidp = 1+ni2; adrem = 0x700000;
        em_write(clusterid, nidp, adrem);
        run_counter(clusterid,0,0,0,8*nidp+offset,nidp,0,adrem,1);  

        if(Resend_ip[clusterid]==1){
          Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
          Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
          i=4;
          for(ipe=0;ipe<32;ipe++){
            Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
            Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
            Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_idxi[iii]<<11);
            Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 	
            i+=6; 
          }
          n = i; ibegin = 3000 + 1400*iii ;
          send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
	}
        n = 4+ni*6; ibegin = 3000 + 1400*iii ;
        run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

          /**  ti(half) **/
	ni3 = (ni2+1)/2;
        Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
        Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = ((UINT64)(ni3*4))<<56; Idp11[clusterid][1] = 0x1;  
        for(i=0;i<ni;i++){
          Idp00[clusterid][2+i]   = *((UINT64 *)(&(Ti[clusterid]))) ; 
          Idp10[clusterid][2+i]   = *((UINT64 *)(&(Ti[clusterid]))) ; 
	}
        for(i=0;i<ni3;i++){
	  Idp01[clusterid][2+2*i] = 0x1;
	  Idp11[clusterid][2+2*i] = 0x1;
	  Idp01[clusterid][2+2*i+1] = 0x1;
	  Idp11[clusterid][2+2*i+1] = 0x1;
        }
        nidp = 1+ni3; adrem = 0x700000;
        em_write(clusterid, nidp, adrem);
        run_counter(clusterid,0,0,0,8*nidp+offset,nidp,0,adrem,1);  

        if(Resend_ip[clusterid]==1){
          Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
          Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
          i=4;
          for(ipe=0;ipe<32;ipe++){
            Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
            Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
            Isp[clusterid][i+4]  = 0x44000000006000a0 | (adr_tih[iii]<<11); 
            Isp[clusterid][i+5]  = (0x00000000001 + (4*ipe << 6)) <<20; 	
            i+=6; 
          }
          n = i; ibegin = 3200 + 1400*iii ;
          send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
	}
        n = 4+ni*6; ibegin = 3200 + 1400*iii ;
        run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

      }  // iii loop end

      Resend_ip[clusterid] = 0;


    }else{ // if model ///////////////////////////////////////////////

    /**  X_ip[clusterid][0],X_ip[clusterid][1],X_ip[clusterid][2] **/

    for(iii=0;iii<niii;iii++){

      for(k=0;k<3;k++){
        Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
        Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = 0x8000000000000000 ;  Idp11[clusterid][1] = 0x1;  
        for(i=0;i<64;i++){
            Idp00[clusterid][2+i]   = *((UINT64 *)(&X_ip[clusterid][2*i  +128*iii][k]));   Idp01[clusterid][2+i] = 0x1;
            Idp10[clusterid][2+i]   = *((UINT64 *)(&X_ip[clusterid][2*i+1+128*iii][k]));   Idp11[clusterid][2+i] = 0x1;  
        }
        nidp = 33; adrem = 0x700000;
        em_write(clusterid, nidp, adrem);
        run_counter(clusterid,0,0,0,8*nidp,nidp,0,adrem,1);  

        if(Resend_ip[clusterid]==1){

          Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
          Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
          i=4;
          for(ipe=0;ipe<32;ipe++){
            Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
            Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
            Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_xi[iii][k]<<11);
            Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 
            i+=6; 
          }
          n = i; ibegin = 2000 + 200*k + 1400*iii;
          send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
        }

        n = 196; ibegin = 2000 + 200*k + 1400*iii ;
        run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM
      }
    }

     Resend_ip[clusterid] = 0;

    for(iii=0;iii<niii;iii++){

    /**  V_ip[clusterid][0],V_ip[clusterid][1] **/

    for(i=0;i<66;i+=2){
        Isp[clusterid][i] = 0x8000000000000000;
        Isp[clusterid][i+1] = 0x0;
    }
    Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
    Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = 0x8000000000000000 ;  Idp11[clusterid][1] = 0x1;  
    for(i=0;i<32;i++){

        tmp0 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii][0]));
        tmp1 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii][0]));
        tmp2 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii][0]));
        tmp3 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii][0]));
        tmp4 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii][1]));
        tmp5 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii][1]));
        tmp6 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii][1]));
        tmp7 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii][1]));

        Idp00[clusterid][2+2*i] =  (0xfffffffff0000000&tmp0) | (0xfffffff&(tmp1>>36));
        Idp01[clusterid][2+2*i] =  (0xff&(tmp1>>28))<<9 | 0x1;
        Idp10[clusterid][2+2*i] =  (0xfffffffff0000000&tmp2) | (0xfffffff&(tmp3>>36));
        Idp11[clusterid][2+2*i] =  (0xff&(tmp3>>28))<<9 | 0x1;
        Idp00[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp4) | (0xfffffff&(tmp5>>36));
        Idp01[clusterid][2+2*i+1] =  (0xff&(tmp5>>28))<<9 | 0x1;
        Idp10[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp6) | (0xfffffff&(tmp7>>36));
        Idp11[clusterid][2+2*i+1] =  (0xff&(tmp7>>28))<<9 | 0x1;

      /*
      Idp00[clusterid][2+2*i] = (0xfffffffff0000000&tmp0) | (0xfffffff&(tmp1>>36));
      Idp01[clusterid][2+2*i] =  0x1;
      Idp10[clusterid][2+2*i] =  (0xfffffffff0000000&tmp2) | (0xfffffff&(tmp3>>36));
      Idp11[clusterid][2+2*i] =  0x1;
      Idp00[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp4) | (0xfffffff&(tmp5>>36));
      Idp01[clusterid][2+2*i+1] =  0x1;
      Idp10[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp6) | (0xfffffff&(tmp7>>36));
      Idp11[clusterid][2+2*i+1] =  0x1;
      */
    }
    Idp00[clusterid][66] = Idp01[clusterid][66] = Idp10[clusterid][66] = Idp11[clusterid][66] = 0;
    Idp00[clusterid][67] = Idp01[clusterid][67] = Idp10[clusterid][67] = Idp11[clusterid][67] = 0;

    i0 =0; i1=67;
    send_vector(clusterid,i0,i1);
    /*
    nidp = 33; adrem = 0x700000;
    em_write(clusterid, nidp, adrem);
    run_counter(clusterid,0,0,0,8*nidp,nidp,0,adrem,1);  
    */

    //    for(i=0;i<196;i++) Idp00[clusterid][i] = Idp01[clusterid][i] = Idp10[clusterid][i] = Idp11[clusterid][i] = 0;
    Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
    Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
    i=4;
    for(ipe=0;ipe<32;ipe++){
        Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
        Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
        Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_vi[iii][0]<<11);
        Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 	
        i+=6; 
    }
    n = i; ibegin = 2600 + 1400*iii ;
    send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

    //    n = 196; ibegin = 2600 + 1400*iii ;
    run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

    }

    for(iii=0;iii<niii;iii++){

    /**  V_ip[clusterid][2],Eps2_ip[clusterid] **/

    for(i=0;i<66;i+=2){
        Isp[clusterid][i] = 0x8000000000000000;
        Isp[clusterid][i+1] = 0x0;
    }
    Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
    Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = 0x8000000000000000 ;  Idp11[clusterid][1] = 0x1;  
    for(i=0;i<32;i++){
        tmp0 =  *((UINT64 *)(&V_ip[clusterid][4*i  +128*iii][2]));
        tmp1 =  *((UINT64 *)(&V_ip[clusterid][4*i+1+128*iii][2]));
        tmp2 =  *((UINT64 *)(&V_ip[clusterid][4*i+2+128*iii][2]));
        tmp3 =  *((UINT64 *)(&V_ip[clusterid][4*i+3+128*iii][2]));
        tmp4 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i  +128*iii]));
        tmp5 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+1+128*iii]));
        tmp6 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+2+128*iii]));
        tmp7 =  *((UINT64 *)(&Eps2_ip[clusterid][4*i+3+128*iii]));

        Idp00[clusterid][2+2*i] =  (0xfffffffff0000000&tmp0) | (0xfffffff&(tmp1>>36));
        Idp01[clusterid][2+2*i] =  (0xff&(tmp1>>28))<<9 | 0x1;
        Idp10[clusterid][2+2*i] =  (0xfffffffff0000000&tmp2) | (0xfffffff&(tmp3>>36));
        Idp11[clusterid][2+2*i] =  (0xff&(tmp3>>28))<<9 | 0x1;
        Idp00[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp4) | (0xfffffff&(tmp5>>36));
        Idp01[clusterid][2+2*i+1] =  (0xff&(tmp5>>28))<<9 | 0x1;
        Idp10[clusterid][2+2*i+1] =  (0xfffffffff0000000&tmp6) | (0xfffffff&(tmp7>>36));
        Idp11[clusterid][2+2*i+1] =  (0xff&(tmp7>>28))<<9 | 0x1;
    }
    Idp00[clusterid][66] = Idp01[clusterid][66] = Idp10[clusterid][66] = Idp11[clusterid][66] = 0;
    Idp00[clusterid][67] = Idp01[clusterid][67] = Idp10[clusterid][67] = Idp11[clusterid][67] = 0;
    i0 =0; i1=67;
    send_vector(clusterid,i0,i1);

    //    for(i=0;i<196;i++) Idp00[clusterid][i] = Idp01[clusterid][i] = Idp10[clusterid][i] = Idp11[clusterid][i] = 0;
    Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
    Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
    i=4;
    for(ipe=0;ipe<32;ipe++){
        Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
        Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
        Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_vi[iii][2]<<11);
        Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 
        i+=6; 
    }
    n = i; ibegin = 2800 + 1400*iii ;
    send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
    run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

    /**  Index_ip[clusterid], ti(half) **/

    for(i=0;i<66;i+=2){
        Isp[clusterid][i] = 0x8000000000000000;
        Isp[clusterid][i+1] = 0x0;
    }
    Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
    Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = 0x8000000000000000 ;  Idp11[clusterid][1] = 0x1;  
    for(i=0;i<32;i++){
        tmp0 =  (UINT64)Index_ip[clusterid][4*i  +128*iii];
        tmp1 =  (UINT64)Index_ip[clusterid][4*i+1+128*iii];
        tmp2 =  (UINT64)Index_ip[clusterid][4*i+2+128*iii];
        tmp3 =  (UINT64)Index_ip[clusterid][4*i+3+128*iii];

        Idp00[clusterid][2+2*i] =  (tmp0<<28) | (tmp1>>8);
        Idp01[clusterid][2+2*i] =  (0xff&tmp1)<<9 | 0x1;
        Idp10[clusterid][2+2*i] =  (tmp2<<28) | (tmp3>>8);
        Idp11[clusterid][2+2*i] =  (0xff&tmp3)<<9 | 0x1;
        Idp00[clusterid][2+2*i+1]   = *((UINT64 *)(&(Ti[clusterid]))) ; Idp01[clusterid][2+2*i+1] = 0x1;
        Idp10[clusterid][2+2*i+1]   = *((UINT64 *)(&(Ti[clusterid]))) ; Idp11[clusterid][2+2*i+1] = 0x1;
    }
    Idp00[clusterid][66] = Idp01[clusterid][66] = Idp10[clusterid][66] = Idp11[clusterid][66] = 0;
    Idp00[clusterid][67] = Idp01[clusterid][67] = Idp10[clusterid][67] = Idp11[clusterid][67] = 0;
    i0 =0; i1=67;
    send_vector(clusterid,i0,i1);

    //    for(i=0;i<196;i++) Idp00[clusterid][i] = Idp01[clusterid][i] = Idp10[clusterid][i] = Idp11[clusterid][i] = 0;
    Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
    Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
    i=4;
    for(ipe=0;ipe<32;ipe++){
        Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
        Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
        Isp[clusterid][i+4]  = 0x84000000006000a0 | (adr_idxi[iii]<<11);
        Isp[clusterid][i+5]  = (0x00000000001 + (8*ipe << 6)) <<20; 	
        i+=6; 
    }
    n = i; ibegin = 3000 + 1400*iii ;
    send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
    run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

    /**  ti(half) **/

    for(i=0;i<34;i+=2){
        Isp[clusterid][i] = 0x8000000000000000;
        Isp[clusterid][i+1] = 0x0;
    }
    Idp00[clusterid][0] = 0;   Idp01[clusterid][0] = 0;   Idp10[clusterid][0] = 0 ;                   Idp11[clusterid][0] = 0;
    Idp00[clusterid][1] = 0;   Idp01[clusterid][1] = 0;   Idp10[clusterid][1] = 0x4000000000000000 ;  Idp11[clusterid][1] = 0x1;  
    for(i=0;i<32;i++){
        Idp00[clusterid][2+i]   = *((UINT64 *)(&(Ti[clusterid]))) ; Idp01[clusterid][2+i] = 0x1;
        Idp10[clusterid][2+i]   = *((UINT64 *)(&(Ti[clusterid]))) ; Idp11[clusterid][2+i] = 0x1;
    }
    Idp00[clusterid][34] = Idp01[clusterid][34] = Idp10[clusterid][34] = Idp11[clusterid][34] = 0;
    Idp00[clusterid][35] = Idp01[clusterid][35] = Idp10[clusterid][35] = Idp11[clusterid][35] = 0;
    i0 =0; i1=35;
    send_vector(clusterid,i0,i1);

    //    for(i=0;i<196;i++) Idp00[clusterid][i] = Idp01[clusterid][i] = Idp10[clusterid][i] = Idp11[clusterid][i] = 0;
    Isp[clusterid][0] = 0x8024000000000000; Isp[clusterid][1] = 0x0001470000000000;
    Isp[clusterid][2] = 0x8024000000000000; Isp[clusterid][3] = 0x0001470000000000;
    i=4;
    for(ipe=0;ipe<32;ipe++){
        Isp[clusterid][i]    = 0x8080000000000000; Isp[clusterid][i+1]  = 0x0002470000000000;
        Isp[clusterid][i+2]  = 0x8024000000000000; Isp[clusterid][i+3]  = 0x0001420000000000;
        Isp[clusterid][i+4]  = 0x44000000006000a0 | (adr_tih[iii]<<11); 
        Isp[clusterid][i+5]  = (0x00000000001 + (4*ipe << 6)) <<20; 	
        i+=6; 
    }
    n = i; ibegin = 3200 + 1400*iii ;
    send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
    run_counter(clusterid,n,ibegin,1,0,0,0,0,0);       // BM -> LM

    }  // iii loop end

    } // if model end

}

void g6_set_njp(int clusterid, int njp)
{
    /* also run func. in G6 */ 
    int i0,i1,nn,i,j,ibegin,n,nidp,adrem,ii;

    if(Prev_njp[clusterid] != njp){
        if((njp%16)!=0){
            adrem = (njp/16) * 49;
            i0 = (njp%16)*3 + 1;
      
            nidp = 49 ;
            nn = 5*(nidp-i0);
            Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
            for(i=i0;i<nidp;i++){
                Rbuf[clusterid][5*(i-i0)+1] = ((UINT64)(i+adrem))<<32  | 0x01010101;
                // Rbuf[clusterid][5*(i-i0)+2] = 0x7ff00000000000000ll;
                Rbuf[clusterid][5*(i-i0)+2] = 0x5000000000000000ll; // !!! 2010/06/02
                Rbuf[clusterid][5*(i-i0)+3] = 0;
                Rbuf[clusterid][5*(i-i0)+4] = 0;
                Rbuf[clusterid][5*(i-i0)+5] = 0;
            }
            hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);
        }
        Prev_njp[clusterid] = njp;  

        /* set 0 in 48 particle after nj */
        adrem = ((njp-1)/16 + 1) * 49;
        nidp = 49;
        nn = 5*nidp;
        Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
        for(i=0;i<nidp;i++){
            Rbuf[clusterid][5*i+1] = ((UINT64)(i+adrem))<<32 ;
            Rbuf[clusterid][5*i+2] = 0;
            Rbuf[clusterid][5*i+3] = 0;
            Rbuf[clusterid][5*i+4] = 0;
            Rbuf[clusterid][5*i+5] = 0;
        }
        hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);

        /* send 0x0c00003f to first line for each 49 */
        for(j=0;j<((njp-1)/16+1);j++){
            adrem = 49 * j;
            nidp = 1;
            nn = 5*nidp;
            Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
            for(i=0;i<nidp;i++){
                Rbuf[clusterid][5*i+1] = ((UINT64)(i+adrem))<<32  | 0x1;
                Rbuf[clusterid][5*i+2] = 0;
                Rbuf[clusterid][5*i+3] = 0;
                Rbuf[clusterid][5*i+4] = 0;
                Rbuf[clusterid][5*i+5] = 0x0c00003f00000000;
            }
            hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);
        }
 
        usleep(10000);

    }

    if(Resend_jp[clusterid]==1){
        usleep(10000);

        /* set 0 in 48 particle after nj */
        adrem = ((njp-1)/16 + 1) * 49;
        nidp = 49;
        nn = 5*nidp;
        Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
        for(i=0;i<nidp;i++){
            Rbuf[clusterid][5*i+1] = ((UINT64)(i+adrem))<<32 ;
            Rbuf[clusterid][5*i+2] = 0;
            Rbuf[clusterid][5*i+3] = 0;
            Rbuf[clusterid][5*i+4] = 0;
            Rbuf[clusterid][5*i+5] = 0;
        }
        hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);

        /* send 0x0c00003f to first line for each 49 */
        for(j=0;j<((njp-1)/16+1);j++){
            adrem = 49 * j;
            nidp = 1;
            nn = 5*nidp;
            Rbuf[clusterid][0] = 0x0000000700000000ll | nn;
            for(i=0;i<nidp;i++){
                Rbuf[clusterid][5*i+1] = ((UINT64)(i+adrem))<<32  | 0x1;
                Rbuf[clusterid][5*i+2] = 0;
                Rbuf[clusterid][5*i+3] = 0;
                Rbuf[clusterid][5*i+4] = 0;
                Rbuf[clusterid][5*i+5] = 0x0c00003f00000000;
            }
            hib_sendMC(clusterid, nn+1, Rbuf[clusterid]);
        }
 
        usleep(10000);

        // ISP init

        ii=0;
        if(Npipe[clusterid] == 128){
#include "./vsm/ispinitloop.hermite.dat"
	}
        if(Npipe[clusterid] == 256){
	  if(Nnbflag[clusterid] == 1){
#include "./vsm/ispinitloop.hermite2_nnb.dat"
	  }else{
#include "./vsm/ispinitloop.hermite2.dat"
	  }
	}
        Nispinit[clusterid] = ii;

        n = Nispinit[clusterid]; ibegin = 1000;	
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        usleep(10000);

        // ISP loop
        ii = 0;

//#include "./g6isploop.dat"
        if(Npipe[clusterid] == 128){
#include "./vsm/isploop.hermite.dat"
          if(Model[clusterid]==460){
            Nplus[clusterid] = 32;
          }else{
            Nplus[clusterid] = 76;	  
          }
	}

        if(Npipe[clusterid] == 256){
	  if(Nnbflag[clusterid] == 1){
#include "./vsm/isploop.hermite2_nnb.dat"
	  }else{
#include "./vsm/isploop.hermite2.dat"
	  }
          Nplus[clusterid] = 0;
	}

        Nisp[clusterid] = ii;
        for(i=0;i<Nplus[clusterid];i++) Isp[clusterid][Nisp[clusterid]+i] = 0; 
        n = Nisp[clusterid] + Nplus[clusterid]; ibegin = 0;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        // printf("nisp %d/%d nplus %d/%d %g %g\n",Nisp[clusterid], Nisp[clusterid]/2,Nplus[clusterid],
        //	       Nplus[clusterid]/2,29.0/(Nisp[clusterid]/2),29.0/((Nisp[clusterid]+Nplus[clusterid])/2));
        Resend_jp[clusterid] = 0;
        usleep(10000);
  
    }

    n = Nispinit[clusterid]; ibegin = 1000;    
    run_counter(clusterid,n,ibegin,1,0,0,0,0,0);          // run ISP init

    nidp = 49;
    run_counter(clusterid,0,0,0,10*nidp,nidp,0,0,1);      // first IDP

    nn = (njp-1)/16 + 1;    nidp = 49;
    n = Nisp[clusterid] + Nplus[clusterid]; ibegin = 0;
#ifdef DEFECT
    if((Npipe[clusterid] == 256)&&(Nip[clusterid]<124)){
#else
    if((Npipe[clusterid] == 256)&&(Nip[clusterid]<128)){
#endif
      if(Model[clusterid]==460){
	 n = 156;
      }else{
	 n = 200;
      }
    }

    run_counter(clusterid,n,ibegin,nn,n,nidp,0,nidp,nn);  // run ISP loop

}

void g6_set_i_particle_scales_from_real_value(int clusterid,
					      int address,
					      double acc[3],
					      double jerk[3],
					      double phi,
					      double jfactor,
					      double ffactor)
{
    // nop
}

void g6_set_i_particle(int clusterid, int address,
		       int index,
                       double x[3], /* position */
                       double v[3], /* velocity */
 		       double eps2,
		       double h2)
{
    int k;

    for(k=0;k<3;k++) X_ip[clusterid][address][k] = x[k];
    for(k=0;k<3;k++) V_ip[clusterid][address][k] = v[k];
    Eps2_ip[clusterid][address] = eps2;
    Index_ip[clusterid][address] = index;
}

int g6_get_force(int clusterid,
                 double acc[][3],
                 double jerk[][3],
                 double phi[],
                 int flag[])
{
    int nnbindex[NFOMAX]; // dummy.
    double rad[NFOMAX]; // dummy.

    //    if (Resend_nnb[clusterid] == 1) {
    //        Nnbflag[clusterid] = 0;
    //        Resend_nnb[clusterid] = 0;
    //    }
    Nnbflag[clusterid] = 0;
    Resend_nnb[clusterid] = 1;
    get_force0(clusterid, acc, jerk, phi, nnbindex, rad);
    return 0;
}

int g6_get_force_etc(int clusterid,
                     double acc[][3],
                     double jerk[][3],
                     double phi[],
                     int nnbindex[],
                     int flag[])
{
    double rad[NFOMAX]; // dummy.

    if (Resend_nnb[clusterid] == 1) {
        Nnbflag[clusterid] = 1;
        Resend_nnb[clusterid] = 0;
	usleep(10000);
        hermite2_nnb_send_vsm_constant(clusterid);
	Resend_jp[clusterid] = 1; 
	Resend_fo[clusterid] = 1;
	g6_set_njp(clusterid, Prev_njp[clusterid]);
    }
    get_force0(clusterid, acc, jerk, phi, nnbindex, rad);
    return 0;
}

/*
 * This function is defined only to implement g6_get_force_etc_all().
 * A user should not call this directly. Use g6_get_force_etc() instead.
 */
static int get_force_etc0(int clusterid,
                          double acc[][3],
                          double jerk[][3],
                          double phi[],
                          int nnbindex[],
                          double rad[])
{
    if (Resend_nnb[clusterid] == 1) {
        Nnbflag[clusterid] = 1;
        Resend_nnb[clusterid] = 0;
	usleep(10000);
        hermite2_nnb_send_vsm_constant(clusterid);
	Resend_jp[clusterid] = 1;
	Resend_fo[clusterid] = 1; 	
	g6_set_njp(clusterid, Prev_njp[clusterid]);
    }
    get_force0(clusterid, acc, jerk, phi, nnbindex, rad);
	
}

static int get_force0(int clusterid,
                      double acc[][3],
                      double jerk[][3],
                      double phi[],
                      int nnbindex[],
                      double rad[])
{
  int i0,i1,i,ii,n,nidp,ibegin,nn,memadr,k,iii,niii,ni;
    UINT64 ir0, ir1;
    UINT64 adr_ax[3],adr_ay[3],adr_az[3],adr_p[3];
    UINT64 adr_jx[3],adr_jy[3],adr_jz[3],adr_nnb[3]; 

  if(Npipe[clusterid] == 128){
    adr_ax[0] = 0x44; adr_ay[0] = 0x4c; adr_az[0] = 0x54; adr_jx[0] = 0x5c;
    adr_jy[0] = 0x64; adr_jz[0] = 0x6c; adr_p[0] = 0x74; adr_nnb[0] = 0x7c;    
    niii = 1;
  }
  if(Npipe[clusterid] == 256){
    int npe;
    adr_ax[0] = 0x78; adr_ay[0] = 0x80; adr_az[0] = 0x88; adr_jx[0] = 0x90;
    adr_jy[0] = 0x98; adr_jz[0] = 0xa0; adr_p[0] = 0xa8; adr_nnb[0] = 0xb0;    
    adr_ax[1] = 0xb8; adr_ay[1] = 0xc0; adr_az[1] = 0xc8; adr_jx[1] = 0xd0;
    adr_jy[1] = 0xd8; adr_jz[1] = 0xe0; adr_p[1] = 0xe8; adr_nnb[1] = 0xf0;    

#ifdef DEFECT
    if(Nip[clusterid]<125){
#else
    if(Nip[clusterid]<129){
#endif
      niii = 1;
    }else{
      niii = 2;
    }
  }

    if(Resend_fo[clusterid]==1){
        usleep(100000);

        Isp[clusterid][0]  = 0x8000000000000000; Isp[clusterid][1]  = 0x00000000000;       
        Isp[clusterid][2]  = 0x80028180000220a6; Isp[clusterid][3]  = 0x6865ea80000 << 20; 
        Isp[clusterid][4]  = 0x8000000000000000; Isp[clusterid][5]  = 0x00000000000;       
        Isp[clusterid][6]  = 0x8000000001800006; Isp[clusterid][7]  = 0x6864003c001 << 20; 
        Isp[clusterid][8]  = 0x8000000001800006; Isp[clusterid][9]  = 0x6864003c203 << 20;
        Isp[clusterid][10] = 0x8000000001800006; Isp[clusterid][11] = 0x6864003c405 << 20;
        Isp[clusterid][12] = 0x8000000001800006; Isp[clusterid][13] = 0x6864003c607 << 20;
        Isp[clusterid][14] = 0x8000000001800006; Isp[clusterid][15] = 0x6864003c809 << 20;
        Isp[clusterid][16] = 0x8000000001800006; Isp[clusterid][17] = 0x6864003ca0b << 20;
        Isp[clusterid][18] = 0x8000000001800006; Isp[clusterid][19] = 0x6864003cc0d << 20;
        Isp[clusterid][20] = 0x8000000001800006; Isp[clusterid][21] = 0x6864003ce0f << 20;
        Isp[clusterid][22] = 0x8000000001800006; Isp[clusterid][23] = 0x6864003d011 << 20;
        Isp[clusterid][24] = 0x8000000001800006; Isp[clusterid][25] = 0x6864003d213 << 20;
        Isp[clusterid][26] = 0x8000000001800006; Isp[clusterid][27] = 0x6864003d415 << 20;
        Isp[clusterid][28] = 0x8000000001800006; Isp[clusterid][29] = 0x6864003d617 << 20;
        Isp[clusterid][30] = 0x8000000001800006; Isp[clusterid][31] = 0x6864003d819 << 20;
        Isp[clusterid][32] = 0x8000000001800006; Isp[clusterid][33] = 0x6864003da1b << 20;
        Isp[clusterid][34] = 0x8000000001800006; Isp[clusterid][35] = 0x6864003dc1d << 20;
        Isp[clusterid][36] = 0x8000000001800006; Isp[clusterid][37] = 0x6864003de1f << 20;
        Isp[clusterid][38] = 0x8000000001800006; Isp[clusterid][39] = 0x6864003e021 << 20;
        Isp[clusterid][40] = 0x8000000001800006; Isp[clusterid][41] = 0x6864003e223 << 20;
        Isp[clusterid][42] = 0x8000000001800006; Isp[clusterid][43] = 0x6864003e425 << 20;
        Isp[clusterid][44] = 0x8000000001800006; Isp[clusterid][45] = 0x6864003e627 << 20;
        Isp[clusterid][46] = 0x8000000001800006; Isp[clusterid][47] = 0x6864003e829 << 20;
        Isp[clusterid][48] = 0x8000000001800006; Isp[clusterid][49] = 0x6864003ea2b << 20;
        Isp[clusterid][50] = 0x8000000001800006; Isp[clusterid][51] = 0x6864003ec2d << 20;
        Isp[clusterid][52] = 0x8000000001800006; Isp[clusterid][53] = 0x6864003ee2f << 20;
        Isp[clusterid][54] = 0x8000000001800006; Isp[clusterid][55] = 0x6864003f031 << 20;
        Isp[clusterid][56] = 0x8000000001800006; Isp[clusterid][57] = 0x6864003f233 << 20;
        Isp[clusterid][58] = 0x8000000001800006; Isp[clusterid][59] = 0x6864003f435 << 20;
        Isp[clusterid][60] = 0x8000000001800006; Isp[clusterid][61] = 0x6864003f637 << 20;
        Isp[clusterid][62] = 0x8000000001800006; Isp[clusterid][63] = 0x6864003f839 << 20;
        Isp[clusterid][64] = 0x8000000001800006; Isp[clusterid][65] = 0x6864003fa3b << 20;
        Isp[clusterid][66] = 0x8000000001800006; Isp[clusterid][67] = 0x6864003fc3d << 20;
        Isp[clusterid][68] = 0x8000000001800006; Isp[clusterid][69] = 0x6864003fe3f << 20;
        Isp[clusterid][70] = 0x8000000000000000; Isp[clusterid][71] = 0x00000000000;

        Idp00[clusterid][0] = 0x0000000000000000; Idp01[clusterid][0] = 0x0; Idp10[clusterid][0] = 0x0000000000000000; Idp11[clusterid][0] = 0x0;
        Idp00[clusterid][1] = 0x0180000000000000; Idp01[clusterid][1] = 0x1; Idp10[clusterid][1] = 0x3804003e40c00000; Idp11[clusterid][1] = 0x1;    

        nidp = 1; memadr = 0x7f0000;
        em_write(clusterid, nidp, memadr);

        for(iii=0;iii<niii;iii++){

        Isp[clusterid][2] = 0x80028180000000a6 | (adr_ax[iii]<<11);
        n = 72; ibegin = 4800 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        Isp[clusterid][2] = 0x80028180000000a6 | (adr_ay[iii]<<11);
        n = 72; ibegin = 4900 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        Isp[clusterid][2] = 0x80028180000000a6 | (adr_az[iii]<<11);
        n = 72; ibegin = 5000 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        Isp[clusterid][2] = 0x80028180000000a6 | (adr_jx[iii]<<11);
        n = 72; ibegin = 5100 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        Isp[clusterid][2] = 0x80028180000000a6 | (adr_jy[iii]<<11);
        n = 72; ibegin = 5200 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
     
        Isp[clusterid][2] = 0x80028180000000a6 | (adr_jz[iii]<<11);
        n = 72; ibegin = 5300 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

        Isp[clusterid][2] = 0x80028180000000a6  | (adr_p[iii]<<11);
        n = 72; ibegin = 5400 + 800*iii;
        send_ispdata(clusterid,n,ibegin,Isp[clusterid]);

	}

        for(iii=0;iii<niii;iii++){
         if(Nnbflag[clusterid]==1){
            Idp00[clusterid][1] = 0x0180000000000000; Idp01[clusterid][1] = 0x1; 
            Idp10[clusterid][1] = 0x3804003653c00000; Idp11[clusterid][1] = 0x1;
            nidp = 1; memadr = 0x7f0001;
            em_write(clusterid, nidp, memadr);

            Isp[clusterid][2] = 0x80028180000000a6 | (adr_nnb[iii]<<11);
            n = 72; ibegin = 5500 + 800*iii;
            send_ispdata(clusterid,n,ibegin,Isp[clusterid]);
          }
	}

        Resend_fo[clusterid] = 0;
        usleep(100000);
    }

    /******************************************************/

    if(Model[clusterid]==460){
      int iioffset[7];
      for(k=0;k<7;k++) iioffset[k] = 0;

       for(iii=0;iii<niii;iii++){

#ifdef DEFECT
	if(((iii+1)*124)>Nip[clusterid]){
	  ni = Nip[clusterid]-iii*124+4;
#else
  	 if(((iii+1)*128)>Nip[clusterid]){
	   ni = Nip[clusterid]-iii*128;
#endif	   
	 }else{
	   ni = 128;
	 }

         for(k=0;k<3;k++){
           n = 72; ibegin = 4800 + 100*k + 800*iii ; memadr = 0x7f0000;
           run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
           hib_recvMC(clusterid, 128, Wbuf[clusterid]);
           for(ii=0;ii<ni;ii++){
	     acc[ii+128*iii+iioffset[k]][k] = *((double *)(Wbuf[clusterid]+ii));
#ifdef DEFECT
	     if(ii==DEFECTPE){
	       if(iii == 0) iioffset[k] = -4;
	       if(iii == 1) iioffset[k] = -8;          
	     }
#endif
	   }
         }

         for(k=0;k<3;k++){
           n = 72; ibegin = 5100 + 100*k + 800*iii ; memadr = 0x7f0000;
           run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
           hib_recvMC(clusterid, 128, Wbuf[clusterid]);
           for(ii=0;ii<ni;ii++) {
	     jerk[ii+128*iii+iioffset[k+3]][k] = *((double *)(Wbuf[clusterid]+ii));
#ifdef DEFECT
	     if(ii==DEFECTPE){
	       if(iii == 0) iioffset[k+3] = -4;
	       if(iii == 1) iioffset[k+3] = -8;          
	     }
#endif	   
	   }
         }

         n = 72; ibegin = 5400 + 800*iii ; memadr = 0x7f0000;
         run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
         hib_recvMC(clusterid, 128, Wbuf[clusterid]);
         for(ii=0;ii<ni;ii++) {
	   phi[ii+128*iii+iioffset[6]] = (*((double *)(Wbuf[clusterid]+ii)));
#ifdef DEFECT
	   if(ii==DEFECTPE){
	     if(iii == 0) iioffset[6] = -4;
	     if(iii == 1) iioffset[6] = -8;          
	   }
#endif
	 }

       }

       if(Nnbflag[clusterid]==1){

         reset_odp(clusterid);
         reset_hib(clusterid);
         reset_hib(clusterid);
         reset_hib(clusterid);       

         for(iii=0;iii<niii;iii++){

           n = 72; ibegin = 5500 + 800*iii ; memadr = 0x7f0001;
           run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
           hib_recvMC(clusterid, 256, Wbuf[clusterid]);
           print_wbuf(clusterid);
           for(ii=0;ii<64;ii++){
             nnbindex[2*ii  +128*iii] = (int)((0xffffff & Wbuf[clusterid][4*ii+1])<<8 | (0xff & (Wbuf[clusterid][4*ii+0]>>56)));
             nnbindex[2*ii+1+128*iii] = (int)((0xffffff & Wbuf[clusterid][4*ii+3])<<8 | (0xff & (Wbuf[clusterid][4*ii+2]>>56)));
//           ir0 = (0xffffffffff000000LL & Wbuf[clusterid][4*ii+1]);
             ir0 = (0xfffffffff0000000LL & Wbuf[clusterid][4*ii+1]); // !!! 2010/06/11
             rad[2*ii+0+128*iii] = *((double *)&ir0);
//           ir1 = (0xffffffffff000000LL & Wbuf[clusterid][4*ii+3]); // !!! 2010/06/11
             ir1 = (0xfffffffff0000000LL & Wbuf[clusterid][4*ii+3]);
             rad[2*ii+1+128*iii] = *((double *)&ir1);
           }
         }
          set_odp_64bitmode(clusterid);
       }

    }else{

      for(iii=0;iii<niii;iii++){

        for(k=0;k<3;k++){
          n = 72; ibegin = 4800 + 100*k + 800*iii ; memadr = 0x7f0000;
          run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
          hib_recvMC(clusterid, 256, Wbuf[clusterid]);
          print_wbuf(clusterid);
          for(ii=0;ii<64;ii++){
            acc[2*ii  +128*iii][k]   = *((double *)(Wbuf[clusterid]+4*ii+1));
            acc[2*ii+1+128*iii][k] = *((double *)(Wbuf[clusterid]+4*ii+3));         
	    //                printf("a[%d] %e %e\n",k,acc[2*ii][k],acc[2*ii+1][k]);
          }
        }
        for(k=0;k<3;k++){
          n = 72; ibegin = 5100 + 100*k + 800*iii ; memadr = 0x7f0000;
          run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
          hib_recvMC(clusterid, 256, Wbuf[clusterid]);
          print_wbuf(clusterid);
          for(ii=0;ii<64;ii++){
            jerk[2*ii  +128*iii][k]   = *((double *)(Wbuf[clusterid]+4*ii+1));
            jerk[2*ii+1+128*iii][k] = *((double *)(Wbuf[clusterid]+4*ii+3));
	    //	    printf("jerk[%d] %e %e\n",k,jerk[2*ii][k],jerk[2*ii+1][k]);
          }
        }

        n = 72; ibegin = 5400 + 800*iii ; memadr = 0x7f0000;
        run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
        hib_recvMC(clusterid, 256, Wbuf[clusterid]);
        print_wbuf(clusterid);
        for(ii=0;ii<64;ii++){
          phi[2*ii  +128*iii]   = (*((double *)(Wbuf[clusterid]+4*ii+1)));
          phi[2*ii+1+128*iii] = (*((double *)(Wbuf[clusterid]+4*ii+3)));         
	//              printf("pot %e %e\n",phi[2*ii],phi[2*ii+1]);
        }

      }

      for(iii=0;iii<niii;iii++){
        if(Nnbflag[clusterid]==1){
          n = 72; ibegin = 5500 + 800*iii ; memadr = 0x7f0001;
          run_counter(clusterid,n,ibegin,1,n,1,0,memadr,1);
          hib_recvMC(clusterid, 256, Wbuf[clusterid]);
          print_wbuf(clusterid);
          for(ii=0;ii<64;ii++){
            nnbindex[2*ii  +128*iii] = (int)((0xffffff & Wbuf[clusterid][4*ii+1])<<8 | (0xff & (Wbuf[clusterid][4*ii+0]>>56)));
            nnbindex[2*ii+1+128*iii] = (int)((0xffffff & Wbuf[clusterid][4*ii+3])<<8 | (0xff & (Wbuf[clusterid][4*ii+2]>>56)));
            ir0 = (0xffffffffff000000LL & Wbuf[clusterid][4*ii+1]);
            rad[2*ii+0+128*iii] = *((double *)&ir0);
            ir1 = (0xffffffffff000000LL & Wbuf[clusterid][4*ii+3]);
            rad[2*ii+1+128*iii] = *((double *)&ir1);

	  //               printf("nnbindex %x %x\n",nnbindex[2*ii],nnbindex[2*ii+1]);
	  //          printf("Wbuf[0..3]  0x%016llx 0x%016llx 0x%016llx 0x%016llx\n",
	  //	             Wbuf[clusterid][4*ii+0], Wbuf[clusterid][4*ii+1], Wbuf[clusterid][4*ii+2], Wbuf[clusterid][4*ii+3]);
            // printf("rad  %e %e\n", rad[2*ii+0], rad[2*ii+1]);
            // printf("\n");
          }
        }
      }

    }
}

void g6_initialize_jp_buffer(int clusterid, int N)
{
}

void g6_set_overflow_flag_test_mode(int force_test_mode,int jerk_test_mode, int pot_test_mode)
{
}

void g6_flush_jp_buffer(int clusterid)
{
}

void g6_reinitialize(int clusterid)
{
}

int g6_getnjmax(int clusterid)
{
    return JMEMSIZE;
}
