/* 
 * GRAPE-DR G5 library
 * Fortran interface
 */

#include <stdio.h>
#include <math.h>
#include <assert.h>
#include "g5util.h"

void
g5_open_(void)
{
    g5_open();
}

void
g5_close_(void)
{
    g5_close();
}

void
g5_set_range_(double *xmin, double *xmax, double *mmin)
{
    g5_set_range(*xmin, *xmax, *mmin);
}

void
g5_set_jp_(int *adr, int *nj, double *mj, double (*xj)[3])
{
    g5_set_jp(*adr, *nj, mj, xj);
}

void
g5_calculate_force_on_x_(double (*x)[3], double (*a)[3], double *p, int *ni)
{
    g5_calculate_force_on_x(x, a, p, *ni);
}

void
g5_set_xi_(int *ni, double (*xi)[3])
{
    g5_set_xi(*ni, xi);
}

void
g5_run_(void)
{
    g5_run();
}

void
g5_set_n_(int *n)
{
    g5_set_n(*n);
}

void
g5_set_eps2_(int *ni, double *eps2)
{
    g5_set_eps2(*ni, eps2);
}

void
g5_set_eps2_to_all_(double *eps2)
{
    g5_set_eps2_to_all(*eps2);
}

void
g5_get_force_(int *ni, double (*a)[3], double *p)
{
    g5_get_force(*ni, a, p);
}

int
g5_get_number_of_pipelines_(void)
{
    return g5_get_number_of_pipelines();
}

int
g5_get_jmemsize_(void)
{
    return g5_get_jmemsize();
}

void
g5_set_eta_(double *eta)
{
    g5_set_eta(*eta);
}

void
g5n_set_jp_(int *adr, int *nj, double *m, double (*x)[3], int *index)
{
    g5n_set_jp(*adr, *nj, m, x, index);
}

void
g5_set_index_(int *ni, int *index)
{
    g5_set_index(*ni, index);
}

void
g5n_get_force_(int *ni, double (*a)[3], double *pot, double *rnnb2, int *innb)
{
    g5n_get_force(*ni, a, pot, rnnb2, innb);
}

void
g5n_calculate_force_on_x_(double (*x)[3], int *index, double (*a)[3], double *p, double *rnnb2, int *innb, int *ni)
{
    g5n_calculate_force_on_x(x, index, a, p, rnnb2, innb, *ni);
}


/*
 * primitive functions to control individual cards.
 * the user needs to specify card's device id explicitly.
 */

void
g5_openMC_(int *devid)
{
    g5_openMC(*devid);
}

void
g5_closeMC_(int *devid)
{
    g5_closeMC(*devid);
}

void
g5_set_rangeMC_(int *devid, double *xmin, double *xmax, double *mmin)
{
    g5_set_rangeMC(*devid, *xmin, *xmax, *mmin);
}

void
g5_set_jpMC_(int *devid, int *adr, int *nj, double *mj, double (*xj)[3])
{
    g5_set_jpMC(*devid, *adr, *nj, mj, xj);
}

void
g5_set_xiMC_(int *devid, int *ni, double (*xi)[3])
{
    g5_set_xiMC(*devid, *ni, xi);
}

void
g5_runMC_(int *devid)
{
    g5_runMC(*devid);
}

void
g5_set_nMC_(int *devid, int *n)
{
    g5_set_nMC(*devid, *n);
}

void
g5_set_eps2MC_(int *devid, int *ni, double *eps2)
{
    g5_set_eps2MC(*devid, *ni, eps2);
}

void
g5_set_eps2_to_allMC_(int *devid, double *eps2)
{
    g5_set_eps2_to_allMC(*devid, *eps2);
}

void
g5_get_forceMC_(int *devid, int *ni, double (*a)[3], double *p)
{
    g5_get_forceMC(*devid, *ni, a, p);
}

int
g5_get_number_of_pipelinesMC_(int *devid)
{
    return g5_get_number_of_pipelinesMC(*devid);
}

int
g5_get_jmemsizeMC_(int *devid)
{
    return g5_get_jmemsizeMC(*devid);
}

void
g5_set_etaMC_(int *devid, double *eta)
{
    g5_set_etaMC(*devid, *eta);
}

void
g5n_set_jpMC_(int *devid, int *adr, int *nj, double *m, double (*x)[3], int *index)
{
    g5n_set_jpMC(*devid, *adr, *nj, m, x, index);
}

void
g5_set_indexMC_(int *devid, int *ni, int *index)
{
    g5_set_indexMC(*devid, *ni, index);
}

void
g5n_get_forceMC_(int *devid, int *ni, double (*a)[3], double *pot, double *rnnb2, int *innb)
{
    g5n_get_forceMC(*devid, *ni, a, pot, rnnb2, innb);
}

void
g5n_calculate_force_on_xMC_(int *devid, double (*x)[3], int *index, double (*a)[3], double *p, double *rnnb2, int *innb, int *ni)
{
    g5n_calculate_force_on_xMC(*devid, x, index, a, p, rnnb2, innb, *ni);
}

/*
 * include definitions of library functions specific to G5nbPIPE,
 * if defined a constant 'G5NBUTIL'.
 */

#ifdef G5NBUTIL
#include "g5nbfapi.c"
#endif
