#ifndef PG2G6UTIL_H
#define PG2G6UTIL_H

#include "hibdrv.h"
#include "hibutil.h"

/* constant definitions */
#if !defined(__LANGUAGE_FORTRAN__) && !defined(_LANGUAGE_FORTRAN)

#if defined(__cplusplus)
extern "C"
{
#endif

    /* C interface */

    /*
     * standard functions
     * (the number of the cards is hidden to the user)
     */
    typedef struct {
        int ndevice;
        int deviceid[NHIBMAX];
    } pg2g6_devices_t;

    typedef struct {
        unsigned int boardinfo;
    } pg2g6_device_info_t;

    int    pg2g6_get_warn_level(void);
    void   pg2g6_devices(pg2g6_devices_t *devs);
    void   pg2g6_device_info(pg2g6_device_info_t **devinfos);
    void   pg2g6_open(void);
    void   pg2g6_close(void);
    void   pg2g6_set_coeff(double ti);
    void   pg2g6_set_jp(int adr, int nj, double *mj, double (*xj)[3], double (*vj)[3], double *tj, double (*acc0by2)[3], double (*jerk0by6)[3], int *indexj);
    void   pg2g6_set_ip(int ni, double (*xi)[3], double (*vi)[3], double *epsi2, int *indexi);
    void   pg2g6_run(void);
    void   pg2g6_set_n(int nj);
    void   pg2g6_get_fout(int ni, double (*acc)[3], double (*jerk)[3]);
    int    pg2g6_get_number_of_pipelines(void);
    int    pg2g6_get_jmemsize(void);

    /*
     * primitive functions to control multiple cards individually.
     * the user needs to specify card's device id explicitly.
     */
    void   pg2g6_device_infoMC(int devid, pg2g6_device_info_t *devinfo);
    void   pg2g6_openMC(int devid);
    void   pg2g6_closeMC(int devid);
    void   pg2g6_set_coeffMC(int devid, double ti);
    void   pg2g6_set_jpMC(int devid, int adr, int nj, double *mj, double (*xj)[3], double (*vj)[3], double *tj, double (*acc0by2)[3], double (*jerk0by6)[3], int *indexj);
    void   pg2g6_set_ipMC(int devid, int ni, double (*xi)[3], double (*vi)[3], double *epsi2, int *indexi);
    void   pg2g6_runMC(int devid);
    void   pg2g6_set_nMC(int devid, int n);
    void   pg2g6_get_foutMC(int devid, int ni, double (*acc)[3], double (*jerk)[3]);
    int    pg2g6_get_number_of_pipelinesMC(int devid);
    int    pg2g6_get_jmemsizeMC(int devid);



    /*
     * scaling functions
     */
    inline void   pg2g6_set_scale_ti(double scale);
    inline void   pg2g6_set_scale_tiMC(int devid, double scale);
    inline double pg2g6_get_scale_ti(void);
    inline double pg2g6_get_scale_tiMC(int devid);

    inline void   pg2g6_set_scale_mj(double scale);
    inline void   pg2g6_set_scale_mjMC(int devid, double scale);
    inline double pg2g6_get_scale_mj(void);
    inline double pg2g6_get_scale_mjMC(int devid);
    void pg2g6_set_range_xj(double min, double max);
    void pg2g6_set_range_xjMC(int devid, double min, double max);
    void pg2g6_get_range_xj(double *min, double *max);
    void pg2g6_get_range_xjMC(int devid, double *min, double *max);
    inline double pg2g6_get_scale_xj(void);
    inline double pg2g6_get_scale_xjMC(int devid);
    inline double pg2g6_get_offset_xj(void);
    inline double pg2g6_get_offset_xjMC(int devid);
    inline void   pg2g6_set_scale_vj(double scale);
    inline void   pg2g6_set_scale_vjMC(int devid, double scale);
    inline double pg2g6_get_scale_vj(void);
    inline double pg2g6_get_scale_vjMC(int devid);
    inline void   pg2g6_set_scale_tj(double scale);
    inline void   pg2g6_set_scale_tjMC(int devid, double scale);
    inline double pg2g6_get_scale_tj(void);
    inline double pg2g6_get_scale_tjMC(int devid);
    inline void   pg2g6_set_scale_acc0by2(double scale);
    inline void   pg2g6_set_scale_acc0by2MC(int devid, double scale);
    inline double pg2g6_get_scale_acc0by2(void);
    inline double pg2g6_get_scale_acc0by2MC(int devid);
    inline void   pg2g6_set_scale_jerk0by6(double scale);
    inline void   pg2g6_set_scale_jerk0by6MC(int devid, double scale);
    inline double pg2g6_get_scale_jerk0by6(void);
    inline double pg2g6_get_scale_jerk0by6MC(int devid);

    void pg2g6_set_range_xi(double min, double max);
    void pg2g6_set_range_xiMC(int devid, double min, double max);
    void pg2g6_get_range_xi(double *min, double *max);
    void pg2g6_get_range_xiMC(int devid, double *min, double *max);
    inline double pg2g6_get_scale_xi(void);
    inline double pg2g6_get_scale_xiMC(int devid);
    inline double pg2g6_get_offset_xi(void);
    inline double pg2g6_get_offset_xiMC(int devid);
    inline void   pg2g6_set_scale_vi(double scale);
    inline void   pg2g6_set_scale_viMC(int devid, double scale);
    inline double pg2g6_get_scale_vi(void);
    inline double pg2g6_get_scale_viMC(int devid);
    inline void   pg2g6_set_scale_epsi2(double scale);
    inline void   pg2g6_set_scale_epsi2MC(int devid, double scale);
    inline double pg2g6_get_scale_epsi2(void);
    inline double pg2g6_get_scale_epsi2MC(int devid);

    inline void   pg2g6_set_scale_acc(double scale);
    inline void   pg2g6_set_scale_accMC(int devid, double scale);
    inline double pg2g6_get_scale_acc(void);
    inline double pg2g6_get_scale_accMC(int devid);
    inline void   pg2g6_set_scale_jerk(double scale);
    inline void   pg2g6_set_scale_jerkMC(int devid, double scale);
    inline double pg2g6_get_scale_jerk(void);
    inline double pg2g6_get_scale_jerkMC(int devid);


#if defined(__cplusplus)
}
#endif

#endif /* LANGUAGE_FORTRAN */

#endif /* PG2G6UTIL_H */
