/* 
 * GRAPE-DR G6 library
 * Fortran interface
 */

#include <stdio.h>
#include <math.h>
#include <assert.h>
#include "g6util.h"

/*
 * standard functions.
 * the number of the devices is hidden to the user.
 */
void
g6_open_all_(void)
{
    g6_open_all();
}

void
g6_close_all_(void)
{
    g6_close_all();
}

int
g6_set_j_particle_all_(int *address, int *index, double *tj, double *dtj, double *mass,
                       double a2by18[3], double a1by6[3], double aby2[3], double v[3], double x[3])
{
    return g6_set_j_particle_all(*address, *index, *tj, *dtj, *mass,
                                 a2by18, a1by6, aby2, v, x);
}

int
g6_set_j_particle_mxonly_all_(int *address, int *index, double *mass, double x[3])
{
    return g6_set_j_particle_mxonly_all(*address, *index, *mass, x);
}

void
g6_set_ti_all_(double *ti)
{
    g6_set_ti_all(*ti);
}

void
g6calc_firsthalf_all_(int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                      double fold[][3], double jold[][3], double phiold[], double *eps2, double h2[])
{
    g6calc_firsthalf_all(*nj, *ni, index, xi, vi, fold, jold, phiold, *eps2, h2);
}

void
g6calc_firsthalf0_all_(int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                       double fold[][3], double jold[][3], double phiold[], double *eps2, double h2[], int *mode)
{
    g6calc_firsthalf0_all(*nj, *ni, index, xi, vi, fold, jold, phiold, eps2, h2, *mode);
}

int
g6calc_lasthalf_all_(int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                     double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[])
{
    return g6calc_lasthalf_all(*nj, *ni, index, xi, vi, *eps2, h2, acc, jerk, pot);
}

int
g6calc_lasthalf0_all_(int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                      double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[], int *mode)
{
    return g6calc_lasthalf0_all(*nj, *ni, index, xi, vi, eps2, h2, acc, jerk, pot, *mode);
}

int
g6calc_lasthalf2_all_(int *nj, int *ni, int index[], double xi[][3], double vi[][3],
                      double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[], int nnbindex[])
{
    return g6calc_lasthalf2_all(*nj, *ni, index, xi, vi, *eps2, h2, acc, jerk, pot, nnbindex);
}

int
g6_read_neighbour_list_all_(void)
{
    return g6_read_neighbour_list_all();
}

int
g6_get_neighbour_list_all_(int *ipipe, int *maxlength, int *nblen, int nbl[])
{
    return g6_get_neighbour_list_all(*ipipe, *maxlength, nblen, nbl);
}

void
g6_set_nip_all_(int *nip)
{
    g6_set_nip_all(*nip);
}

void
g6_set_njp_all_(int *njp)
{
    g6_set_njp_all(*njp);
}

void
g6_set_i_particle_scales_from_real_value_all_(int *address, double acc[3], double jerk[3], double *phi,
                                              double *jfactor, double *ffactor)
{
    g6_set_i_particle_scales_from_real_value_all(*address, acc, jerk, *phi, *jfactor, *ffactor);
}

void
g6_set_i_particle_all_(int *address, int *index, double x[3], double v[3], double *eps2, double *h2)
{
    g6_set_i_particle_all(*address, *index, x, v, *eps2, *h2);
}

int
g6_get_force_all_(double acc[][3], double jerk[][3], double phi[], int flag[])
{
    return g6_get_force_all(acc, jerk, phi, flag);
}

int
g6_get_force_etc_all_(double acc[][3], double jerk[][3], double phi[], int nnbindex[], int flag[])
{
    return g6_get_force_etc_all(acc, jerk, phi, nnbindex, flag);
}

int
g6_getnjmax_all_(void)
{
    return g6_getnjmax_all();
}

/*
 * primitive functions to control multiple devices individually.
 * the user needs to specify card's device id explicitly.
 */
void
g6_open_(int *clusterid)
{
    g6_open(*clusterid);
}

void
g6_close_(int *clusterid)
{
    g6_close(*clusterid);
}

void
g6_set_tunit_(int *newtunit)
{
    g6_set_tunit(*newtunit);
}

void
g6_set_xunit_(int *newxunit)
{
    g6_set_xunit(*newxunit);
}

int
g6_set_j_particle_(int *clusterid, int *address, int *index, double *tj, double *dtj, double *mass,
                   double a2by18[3], double a1by6[3], double aby2[3], double v[3], double x[3])
{
    return g6_set_j_particle(*clusterid, *address, *index, *tj, *dtj, *mass,
                             a2by18, a1by6, aby2, v, x);
}

int
g6_set_j_particle_mxonly_(int *clusterid, int *address, int *index, double *mass, double x[3])
{
    return g6_set_j_particle_mxonly(*clusterid, *address, *index, *mass, x);
}

void
g6_set_ti_(int *clusterid, double *ti)
{
    g6_set_ti(*clusterid, *ti);
}

void
g6calc_firsthalf_(int *clusterid, int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                 double fold[][3], double jold[][3], double phiold[], double *eps2, double h2[])
{
    g6calc_firsthalf(*clusterid, *nj, *ni, index, xi, vi, fold, jold, phiold, *eps2, h2);
}

void
g6calc_firsthalf0_(int *clusterid, int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                   double fold[][3], double jold[][3], double phiold[], double *eps2, double h2[], int *mode)
{
    g6calc_firsthalf0(*clusterid, *nj, *ni, index, xi, vi, fold, jold, phiold, eps2, h2, *mode);
}

int
g6calc_lasthalf_(int *clusterid, int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[])
{
    return g6calc_lasthalf(*clusterid, *nj, *ni, index, xi, vi, *eps2, h2, acc, jerk, pot);
}

int
g6calc_lasthalf0_(int *clusterid, int *nj, int *ni, int index[], double xi[][3], double vi[][3], 
                  double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[], int *mode)
{
    return g6calc_lasthalf0(*clusterid, *nj, *ni, index, xi, vi, eps2, h2, acc, jerk, pot, *mode);
}

int
g6calc_lasthalf2_(int *clusterid, int *nj, int *ni, int index[], double xi[][3], double vi[][3],
                 double *eps2, double h2[], double acc[][3], double jerk[][3], double pot[], int nnbindex[])
{
    return g6calc_lasthalf2(*clusterid, *nj, *ni, index, xi, vi, *eps2, h2, acc, jerk, pot, nnbindex);
}


int
g6_read_neighbour_list_(int *clusterid)
{
    return g6_read_neighbour_list(*clusterid);
}

int
g6_get_neighbour_list_(int *clusterid, int *ipipe, int *maxlength, int *nblen, int nbl[])
{
    return g6_get_neighbour_list(*clusterid, *ipipe, *maxlength, nblen, nbl);
}

void
g6_set_neighbour_list_sort_mode_(int *mode)
{
    g6_set_neighbour_list_sort_mode(*mode);
}

int
g6_get_neighbour_list_sort_mode_(void)
{
    return g6_get_neighbour_list_sort_mode();
}

int
g6_npipes_(void)
{
    return g6_npipes();
}

void
g6_set_nip_(int *clusterid, int *nip)
{
    g6_set_nip(*clusterid, *nip);
}

void
g6_set_njp_(int *clusterid, int *njp)
{
    g6_set_njp(*clusterid, *njp);
}

void
g6_set_i_particle_scales_from_real_value_(int *clusterid, int *address, double acc[3], double jerk[3], double *phi,
                                          double *jfactor, double *ffactor)
{
    g6_set_i_particle_scales_from_real_value(*clusterid, *address, acc, jerk, *phi, *jfactor, *ffactor);
}

void
g6_set_i_particle_(int *clusterid, int *address, int *index, double x[3], double v[3], double *eps2, double *h2)
{
    g6_set_i_particle(*clusterid, *address, *index, x, v, *eps2, *h2);
}

int
g6_get_force_(int *clusterid, double acc[][3], double jerk[][3], double phi[], int flag[])
{
    return g6_get_force(*clusterid, acc, jerk, phi, flag);
}

int
g6_get_force_etc_(int *clusterid, double acc[][3], double jerk[][3], double phi[], int nnbindex[], int flag[])
{
    return g6_get_force_etc(*clusterid, acc, jerk, phi, nnbindex, flag);
}

int
g6_getnjmax_(int *clusterid)
{
    return g6_getnjmax(*clusterid);
}
