#ifndef G5UTIL_H
#define G5UTIL_H

#include "typedef.h"

/* constant definitions */
#if !defined(__LANGUAGE_FORTRAN__) && !defined(_LANGUAGE_FORTRAN)

#if defined(__cplusplus)
extern "C"
{
#endif

    /* C interface */

    /*
     * standard functions.
     * the number of the cards is hidden to the user.
     */
    void   g5_open(void);
    void   g5_close(void);
    void   g5_set_range(double xmin, double xmax, double mmin);
    void   g5_set_jp(int adr, int nj, double *m, double (*x)[3]);
    void   g5_calculate_force_on_x(double (*x)[3], double (*a)[3], double *p, int ni);
    void   g5_set_xi(int ni, double (*x)[3]);
    void   g5_run(void);
    void   g5_set_n(int nj);
    void   g5_set_eps2(int ni, double *eps2);
    void   g5_set_eps2_to_all(double eps2);
    void   g5_get_force(int ni, double (*a)[3], double *pot);
    int    g5_get_number_of_pipelines(void);
    int    g5_get_jmemsize(void);
    void   g5_set_eta(double eta);
    void   g5_set_h_to_all(double h);
    void   g5_set_h(int ni, double *h);
    int    g5_read_neighbor_list(void);
    int    g5_get_neighbor_list(int ip, int *list);
    int    g5_get_nbmemsize(void);
    int    g5_set_nbmemsize(int size);

    void   g5n_set_jp(int adr, int nj, double *m, double (*x)[3], int *index);
    void   g5_set_index(int ni, int *index);
    void   g5n_get_force(int ni, double (*a)[3], double *pot, double * rnnb2, int * innb);
    void   g5n_calculate_force_on_x(double (*x)[3], int * index, double (*a)[3], double *p,
                                    double * rnnb2, int * innb, int ni);

    // obsolete functions
    // (may not be supported in the next version).
    //
    double g5_get_pcibus_freq(void);
    void   g5_get_range(double *xmin, double *xmax, double *mmin);
    void   g5_set_xmj(int adr, int nj, double (*xj)[3], double *mj);
    void   g5_set_eps(int ni, double *eps);
    void   g5_set_eps_to_all(double eps);
    void   g5_set_cards(int *c);
    void   g5_get_cards(int *c);
    int    g5_get_number_of_cards(void);
    int    g5_get_number_of_real_pipelines(void);
    void   g5_set_cutoff_table(double (*ffunc)(double), double fcut, double fcor,
                               double (*pfunc)(double), double pcut, double pcor);
    int    g5_is_busy(void);

    /*
     * primitive functions to control multiple cards individually.
     * the user needs to specify card's device id explicitly.
     */
    void   g5_openMC(int devid);
    void   g5_closeMC(int devid);
    void   g5_set_rangeMC(int devid, double xmin, double xmax, double mmin);
    void   g5_set_jpMC(int devid, int adr, int nj, double *m, double (*x)[3]);
    void   g5_set_xiMC(int devid, int ni, double (*x)[3]);
    void   g5_runMC(int devid);
    void   g5_set_nMC(int devid, int n);
    void   g5_set_eps2MC(int devid, int ni, double *eps2);
    void   g5_set_eps2_to_allMC(int devid, double eps2);
    void   g5_get_forceMC(int devid, int ni, double (*a)[3], double *pot);
    int    g5_get_number_of_pipelinesMC(int devid);
    int    g5_get_jmemsizeMC(int devid);
    void   g5_set_etaMC(int devid, double eta);
    void   g5_set_h_to_allMC(int devid, double h);
    void   g5_set_hMC(int devid, int ni, double *h);
    int    g5_read_neighbor_listMC(int devid);
    int    g5_get_neighbor_listMC(int devid, int ip, int *list);
    int    g5_get_nbmemsizeMC(int devid);
    int    g5_set_nbmemsizeMC(int devid, int size);

    void g5n_set_jpMC(int devid, int adr, int nj, double *m, double (*x)[3], int *index);
    void g5_set_indexMC(int devid, int ni, int *index);
    void g5n_get_forceMC(int devid, int ni, double (*a)[3], double *pot,
                         double * rnnb2, int * innb);
    void g5n_calculate_force_on_xMC(int devid, double (*x)[3], int * index,
                                    double (*a)[3], double *p, double * rnnb2, int * innb, int ni);

    // obsolete functions
    // (may not be supported in the next revision)
    //
    double g5_get_pcibus_freqMC(int devid);
    void   g5_get_rangeMC(int devid, double *xmin, double *xmax, double *mmin);
    void   g5_set_xmjMC(int devid, int adr, int nj, double (*xj)[3], double *mj);
    void   g5_set_epsMC(int devid, int ni, double *eps);
    void   g5_set_eps_to_allMC(int devid, double eps);
    int    g5_get_number_of_real_pipelinesMC(int devid);
    void   g5_set_cutoff_tableMC(int devid,
                                 double (*ffunc)(double), double fcut, double fcor,
                                 double (*pfunc)(double), double pcut, double pcor);
    int    g5_is_busyMC(int devid);


#if defined(__cplusplus)
}
#endif

#endif /* LANGUAGE_FORTRAN */

#endif /* G5UTIL_H */
