#ifndef G5NBUTIL_H
#define G5NBUTIL_H

#include "typedef.h"
#include "g5util.h"

/* constant definitions */
#if !defined(__LANGUAGE_FORTRAN__) && !defined(_LANGUAGE_FORTRAN)

#if defined(__cplusplus)
extern "C"
{
#endif

    /* C interface */

    /*
     * standard functions.
     * the number of the cards is hidden to the user.
     */
    void   g5_set_h(int ni, double *h);
    void   g5_set_h_to_all(double h);
    int    g5_read_neighbor_list(void);
    int    g5_get_neighbor_list(int ip, int *list);
    int    g5_set_nbmemsize(int size);
    int    g5_get_nbmemsize(void);

    /*
     * primitive functions to control multiple cards individually.
     * the user needs to specify card's device id explicitly.
     */
    void   g5_set_hMC(int devid, int ni, double *h);
    void   g5_set_h_to_allMC(int devid, double h);
    int    g5_read_neighbor_listMC(int devid);
    int    g5_get_neighbor_listMC(int devid, int ip, int *list);
    int    g5_set_nbmemsizeMC(int devid, int size);
    int    g5_get_nbmemsizeMC(int devid);

#if defined(__cplusplus)
}
#endif

#endif /* LANGUAGE_FORTRAN */

#endif /* G5NBUTIL_H */
