#ifndef G5NBFAPI_C
#define G5NBFAPI_C

/*
 * standard functions.
 * the number of the cards is hidden to the user.
 */
void
g5_set_h_to_all_(double *h)
{
    g5_set_h_to_all(*h);
}

void
g5_set_h_(int *ni, double *h)
{
    g5_set_h(*ni, h);
}

int
g5_read_neighbor_list_(void)
{
    g5_read_neighbor_list();
}

int
g5_get_neighbor_list_(int *ip, int *list)
{
    g5_get_neighbor_list(*ip, list);
}

int
g5_get_nbmemsize_(void)
{
    g5_get_nbmemsize();
}

int
g5_set_nbmemsize_(int *size)
{
    g5_set_nbmemsize(*size);
}

/*
 * primitive functions to control individual cards.
 * the user needs to specify card's device id explicitly.
 */
void
g5_set_h_to_allMC_(int *devid, double *h)
{
    g5_set_h_to_allMC(*devid, *h);
}

void
g5_set_hMC_(int *devid, int *ni, double *h)
{
    g5_set_hMC(*devid, *ni, h);
}

int
g5_read_neighbor_listMC_(int *devid)
{
    g5_read_neighbor_listMC(*devid);
}

int
g5_get_neighbor_listMC_(int *devid, int *ip, int *list)
{
    g5_get_neighbor_listMC(*devid, *ip, list);
}

int
g5_get_nbmemsizeMC_(int *devid)
{
    g5_get_nbmemsizeMC(*devid);
}

int
g5_set_nbmemsizeMC_(int *devid, int *size)
{
    g5_set_nbmemsizeMC(*devid, *size);
}

#endif // G5NBFAPI_C
