#ifndef G5OLDAPI_C
#define G5OLDAPI_C

/*
 * standard functions.
 * the number of the cards is hidden to the user.
 */
double
g5_get_pcibus_freq(void)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] != 0) break;
    }
    
    return g5_get_pcibus_freqMC(ic);
}

void
g5_get_range(double *xmin, double *xmax, double *mmin)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] != 0) break;
    }
    g5_get_rangeMC(ic, xmin, xmax, mmin);
}

void
g5_set_xmj(int adr, int nj, double (*x)[3], double *m)
{
    g5_set_jp(adr, nj, m, x);
}

void
g5_set_eps(int ni, double *eps)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] == 0) continue;
	g5_set_epsMC(ic, ni, eps);
    }
}

void
g5_set_eps_to_all(double eps)
{
    g5_set_eps2_to_all(eps * eps);
}

void
g5_set_cards(int *c)
{
    int i, nc = 0;

    for (i = 0; i < hib_ndevice(); i++) {
	g5_cards[i] = c[i];
	nc++;
    }
    g5_ncards = nc;
}

void
g5_get_cards(int *c)
{
    int ic;
    int first;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	c[ic] = g5_cards[ic];
    }

    WARN(2, "use g5_cards[");
    first = 1;
    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] == 0) continue;
        if (!first) WARN(2, " ");
        first = 0;
	WARN(2, "%d", ic);
    }
    WARN(2, "]\n");
}

int
g5_get_number_of_cards(void)
{
    return hib_ndevice();
}

int
g5_get_number_of_real_pipelines(void)
{
    int ic;
    int np = 0;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] == 0) continue;
	np += g5_get_number_of_real_pipelinesMC(ic);
    }
    return np;
}

/*
 * cut-off table is fixed to the one for P3M, and is not rewritable.
 * all arguments are dummy, which exist only for backward compatibility.
 */
void
g5_set_cutoff_table(double (*ffunc)(double), double fcut, double fcor,
		    double (*pfunc)(double), double pcut, double pcor)
{
    int ic;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] == 0) continue;
	g5_set_cutoff_tableMC(ic, ffunc, fcut, fcor, pfunc, pcut, pcor);
    }
}

int
g5_is_busy(void)
{
    int ic;
    int isbusy = 0;

    for (ic = 0; ic < hib_ndevice(); ic++) {
	if (g5_cards[ic] == 0) continue;
	isbusy |= g5_is_busyMC(ic);
    }
    return isbusy;
}


/*
 * primitive functions to control multiple cards individually.
 * the user needs to specify card's device id explicitly.
 */
double
g5_get_pcibus_freqMC(int devid)
{
    int plda_csr;
    double freq;

    if (H[devid]->type == HIB_GRAPE7X) {
        plda_csr = hib_config_readMC(devid, 0x44); /* PLDA Core Status Register at 0x44 */
        switch ((plda_csr>>28)&0x3) {
          case 0:
            freq = 33.0;
            break;
          case 1:
            freq = 66.0;
            break;
          case 2:
            freq = 100.0;
            break;
          case 3:
            freq = 133.0;
            break;
        }
    }
    else {
        freq = 125.0;
    }
    return freq;
}

void
g5_get_rangeMC(int devid, double *xmin, double *xmax, double *mmin)
{
    *xmin = Current_xmin[devid];
    *xmax = Current_xmax[devid];
    *mmin = Current_mmin[devid];
}

void
g5_set_xmjMC(int devid, int adr, int nj, double (*x)[3], double *m)
{
    g5_set_jpMC(devid, adr, nj, m, x);
}

void
g5_set_epsMC(int devid, int ni, double *eps)
{
    int i;
    double xs = Xscale[devid];

    if (ni > Nipmax[devid]) {
	fprintf(stderr, "g5_set_epsMC: too large ni (%d). abort.\n", ni);
	exit(1);
    }

    for (i = 0; i < ni; i++) {
        Ieps2[devid][i] = convert_eps(g5_eps2format[devid], eps[i] * eps[i] * xs * xs);
    }
}

void
g5_set_eps_to_allMC(int devid, double eps)
{
    g5_set_eps2_to_allMC(devid, eps * eps);
}

int
g5_get_number_of_real_pipelinesMC(int devid)
{
    return g5_npipes[devid] * g5_nchip[devid];
}

void
g5_set_cutoff_tableMC(int devid,
		      double (*ffunc)(double), double fcut, double fcor,
		      double (*pfunc)(double), double pcut, double pcor)
{
    static int firstcall = 1;

    if (g5_p3mcutoff[devid] == 0) {
        if (firstcall == 1) {
            firstcall = 0;
            WARN(2, "Warning: cut-off function is not implemented in this revision "
                 "of G5 pipeline. g5_set_cutoff_tableMC() has no effect.\n");
        }
    }
}

int
g5_is_busyMC(int devid)
{
    return hib_dmaw_is_completedMC(devid) ? 0 : 1;
}

#endif // G5OLDAPI_C
