#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "hibdrv.h"
#include "hibutil.h"
#include <sys/time.h>
#include <sys/resource.h>

#define NOT

void get_wcputime(laptime,splittime)
double *laptime;
double *splittime;
{
        struct timeval tval;
        void *dum=0;

        gettimeofday(&tval,dum);
        *laptime = tval.tv_sec + tval.tv_usec * 1.0e-6 - *splittime;
        *splittime = tval.tv_sec + tval.tv_usec * 1.0e-6 ;

}

int
main(int argc, char **argv)
{
    Hib *hib;
    UINT64 *rbuf;
    UINT64 *wbuf;
    UINT64 *backend;
    UINT64 data,binfo;
    int n,i,j,nn,addflag=0,devid,tmpmod;
    double drand48(),srend48();
    double lt,st;
    char model[20];

    if(argc<4){
      //      hib_set_nclusters(1);
      //      hib_openMC(0, &rbuf, &wbuf, &backend);

      if(argc < 2){
	devid = 0;
      }else{
	sscanf(argv[1],"%d",&devid);
      }
      
      hib = hib_openMC(devid);
      rbuf = hib->dmar_buf;
      wbuf = hib->dmaw_buf;
      backend = hib->backend;

    //    rbuf[0] = 0xffffffffffff00c1ll;

    //    n = 80;

      binfo = hib_mem_readMC(devid, hib->boardinfo);
      tmpmod = (binfo>>24) & 0xf;
      if(tmpmod == 1) strcpy(model,"100");
      if(tmpmod == 2) strcpy(model,"300d");
      if(tmpmod == 3) strcpy(model,"300");
      if(tmpmod == 6) strcpy(model,"600");
      printf("devid = %d model %s\n",devid,model);

      if(strcmp(model,"600")==0){
        addflag = 1;
	printf("**** loopback test for model600 ****\n"); 
      }else{
        addflag = 0;
	printf("**** loopback test for model300 or 300D ****\n"); 
      }
      
     if(argc==3){
       sscanf(argv[2],"%d",&nn);
     }else{
       nn = 10;
     }
      printf("nn = %d\n",nn);    

      backend[0] = 0x0000000700000007ll;
      data = backend[0];
      printf("data 0x%016llx\n", data); /* 0x0807060504030201 should be read */

      srand48(nn);
      for(j=0;j<nn;j++){

        n = 512 * drand48();
        if(n<4) n=4;
    
        printf("n = %d\n",n);          
        sleep(1);
    
        for(i=0;i<n;i++){
          UINT64 tmp1,tmp2;
	  tmp1 = 0x0000ffffffffffffll * drand48() ;
	  tmp2 = 0xffff000000000000ll * drand48() ;
	  rbuf[i] = tmp1 | tmp2;
	  //	  rbuf[i] = i;
          wbuf[i] = 0;
        }

        get_wcputime(&lt,&st);

        hib_dmarMC(devid, n, rbuf);
    
        hib_dmawMC(devid, n, wbuf);

        get_wcputime(&lt,&st);

        printf("time %g %g MB/s %d\n",lt,2*(8*n)/lt/1000000.0,n);    

        for(i=0;i<n;i++){
          UINT64 tmp3;
	  if(addflag==1){
	    tmp3 = wbuf[i]^(rbuf[i]<<1);
	  }else{
	    tmp3 = wbuf[i]^rbuf[i];	  
	  }
          if(tmp3!=0){
            printf("i %x rbuf 0x%016llx wbuf 0x%016llx 0x%016llx\n", i,rbuf[i], wbuf[i],tmp3);
          }
        }
        i = n-1;
        printf("i %x rbuf 0x%016llx wbuf 0x%016llx %x\n", i,rbuf[i], wbuf[i],rbuf[i]-wbuf[i]);
      }

    }else{
      printf("sample [devid] [ntrial]\n");
      exit(1);
    }
    
#ifdef NOT
 
    /* PIO read from byte address 0 */
    data = backend[0];
    printf("data 0x%016llx\n", data);

    /* PIO read from byte address 8 */
    data = backend[1];
    printf("data 0x%016llx\n", data);

    /* PIO write to byte address 0 */
    /*    backend[0] = data; /* HIB synthesized with initial
			  ./hib/vhdl/backend.vhd is designed to return
			  0x0807060504030201 to g6_piodata,
			  independent of whatever value may be written
			  to. Thus PIO write does not affect the value
			  read by the following PIO read. */

    data = backend[0];
    printf("data 0x%016llx\n", data); /* 0x0807060504030201 should be read */

#endif

    backend[0] = 0x0000000000000000ll;        

    hib_closeMC(devid);

    exit(0);
}
