#ifndef XHIBUTIL_H
#define XHIBUTIL_H

#include <pcixmem.h>
#include "typedef.h"

#if defined(__cplusplus)
extern "C"
{
#endif

  // size of PIO buffer implemented as SRAM in EHIB (in 8byte word)
  // data is written to this buf by the host via bar2.
#define PIOWBUFSIZE (512)

#define DMA0LSB  (0x00)
#define DMA0MSB  (0x04)
#define DMA0SIZE (0x08)
#define DMA0CMD  (0x0c)

#define DMA1LSB  (0x10)
#define DMA1MSB  (0x14)
#define DMA1SIZE (0x18)
#define DMA1CMD  (0x1c)

#define DMASTAT  (0x20)
#define MAILBOX  (0x24)
#define DMAMISC  (0x28)
    /* address map of XHIB DMA control register (0x28)
     *
     * 31..30: reserved for dmadone(3..2)
     * 29..28: dmadone(1..0)
     * 27:     swap_sram
     * 26:     sram1_wlock
     * 25:     sram0_wlock
     * 24..21: not used
     * 20..12: sram_wcnt(8..0)
     *     11: not used
     * 10..0:  m_dma1_datacnt(10..0)
     */

    enum {
        TESTMODE_NONE=0,         // normal operation.
	TESTMODE_REFDESIGN_FIFO, // data received are directly put into internal FIFO.
	TESTMODE_REFDESIGN_RAM,  // data received are ignored.
    };

    enum {
        SENDFUNC_DMAR = 0,
	SENDFUNC_PIOW,
    };

    /*
     * global func(s)
     */
    /* multi cluster extension */
    void xhib_alloc(int xhib0, int nxhibs);
    void xhib_set_nclusters(int n);
    int xhib_get_nclusters(void);
    void xhib_openMC(int devid, UINT64 **dmar, UINT64 **dmaw, UINT64 **backend);
    void xhib_closeMC(int devid);
    void xhib_set_test_modeMC(int devid, int mode);

    void xhib_sendMC(int devid, int size, UINT64 *buf);
    void xhib_set_sendfuncMC(int devid, int func); // SENDFUNC_DMAR/SENDFUNC_PIOW
    void xhib_piowMC(int devid, int size, UINT64 *buf);
    void xhib_dmarMC(int devid, int size, UINT64 *buf);

    int xhib_recvMC(int devid, int size, UINT64 *buf);
    int xhib_dmawMC(int devid, int size, UINT64 *buf);
    int xhib_start_dmawMC(int devid, int size, UINT64 *buf);
    int xhib_finish_dmawMC(int devid);

    /* higher level wrapper */
    void xhib_open(UINT64 **dmar, UINT64 **dmaw, UINT64 **backend);
    void xhib_close(void);

#if defined(__cplusplus)
}
#endif

#endif /* XHIBUTIL_H */
