#include<stdio.h>
#include<math.h>
#include<malloc.h>
#define REAL double
#define DIM 3
#include "jlist.h"

static int clusterid=0;

void calculate_force(x,m,a,pot,ilist,nilist,jlist,njlist,eps2)
REAL x[][3];
REAL m[];
REAL a[][3];
REAL pot[];
int ilist[];
int nilist;
struct jlist_t *jlist;
int njlist;
REAL eps2;
{
  int i,j,k,npipes,ii,jj,nn;
  double lt=0,st=0;
  double forceit=0,forcemjt=0,forcexjt=0;

  double (*xi)[3];
  double (*atmp)[3];
  double (*ptmp);

  double tj,dtj,a2by18[3],a1by6[3], aby2[3], v[3],time,h2;
  static double jerk[48][3];
  static int flag[48];
  
  xi = (double (*)[3])malloc(sizeof(double)*3*200);
  atmp = (double (*)[3])malloc(sizeof(double)*3*200);
  ptmp = (double *)malloc(sizeof(double)*200);

  get_wcputime(&lt,&st);

  npipes = g6_get_number_of_pipelines();

  /*
  g5_set_xj(0,njlist,(*jlist).x);
  g5_set_mj(0,njlist,(*jlist).mass);
  */

  h2 = 0.0;
  tj = 0.0;
  dtj = 1.0;
  for(k=0;k<DIM;k++) a2by18[k] = a1by6[k] = aby2[k] = v[k] = 0.0;
  time = 0.0;
  
  for(i=0;i<njlist;i++){
    g6_set_j_particle(clusterid, i, i+48, tj, dtj, ((*jlist).mass[i]), a2by18, a1by6, aby2, v, (*jlist).x[i]);    
  }
  g6_set_ti(time);
  
  /*  get_wcputime(&lt,&st);
  forcexjt += lt;
  forcemjt += lt;
  */
  /*  g5_set_n(njlist);*/

  for(i=0;i<nilist;i+=npipes){
    nn = npipes;
    if((i+npipes)>nilist) nn = nilist-i;

    /*
    for(ii=0;ii<nn;ii++){
      for(k=0;k<3;k++) xi[ii][k] = x[ilist[i+ii]][k];
    }
    g5_set_xi(nn,xi);
    g5_run();
    g5_get_force(nn,atmp,ptmp);
    */
    
    for(ii=0;ii<nn;ii++){
      double jfactor=6,ffactor=0;
      int index;
      index = ilist[i+ii];
      g6_set_i_particle_scales_from_real_value(clusterid, ii,a[index],jerk[ii],pot[index],jfactor,ffactor);
      g6_set_i_particle(clusterid, ii, ii, x[index], v, eps2, h2);
    }
    g6_set_nip(clusterid, nn);
    g6_set_njp(clusterid, njlist);

    g6_get_force(clusterid, atmp,jerk,ptmp,flag);
    
    for(ii=0;ii<nn;ii++){
      int iii;
      iii = ilist[i+ii];
      for(k=0;k<3;k++) a[iii][k] = atmp[ii][k];
      pot[iii] = ptmp[ii];
      if((0xf00c00db&flag[ii])!=0) printf("i %d flag %x\n",iii,flag[ii]); 
    }
  }

  get_wcputime(&lt,&st);
  forceit += lt;
  free(xi); free(atmp); free(ptmp);

}

void initialize_force_function()
{
}

static int logout_firstflag=1;

void calculate_force_using_tree(n,x,m,a,pot,eps,clist,nwalk,walklist,index,maxx,st,dninter)
int n;
REAL x[][3];
REAL m[];
REAL a[][3];
REAL pot[];
REAL eps;
struct clist_t clist[];
int nwalk;
int walklist[];
int index[];
double maxx;
double *st;
double *dninter;
{
  int ii,i,j,nilistsum=0;
  double tlist,tgrape,lt=0;
  long long int current_key;
  long long int ninter,sumjlist;
  double tmpcm[3];
  double eps2;
  int tunit,xunit;
  
  int *ilist = NULL ;
  struct jlist_t *jlist;
  jlist = (struct jlist_t *)malloc(sizeof(struct jlist_t));

  eps2 = eps*eps;

  tunit = 51;                         /* 2^51 */
  g6_set_tunit(tunit);
  xunit = 50;                         /* 2^50 */
  g6_set_xunit(xunit);

  if(logout_firstflag==1){
    g6_open(clusterid);
    printf("npipe %d\n",g6_get_number_of_pipelines_());
  }

  /*  g5_set_range(-maxx*2.0,maxx*2.0,m[0]);
  g5_set_eps_to_all(eps);
  */
  
  tlist = tgrape = 0;

  ninter = sumjlist = 0;

  for(ii=0;ii<nwalk;ii++){

    int njlist=0,nilist,tmpif;
    double coc[3],totalm=0;
    i = walklist[ii];

  tmpcm[0]=tmpcm[1]=tmpcm[2]=0.0;

    nilist = clist[i].n;
    tmpif = clist[i].ifirst;

    ilist = (int *)realloc(ilist,sizeof(int)*nilist);
      
    for(j=0;j<nilist;j++) ilist[j] = index[j+tmpif];

    center_of_cell(clist[i].key,clist[i].key_level,clist[i].length,coc,maxx);
    current_key = 1;
    make_interaction_list(clist[i].key,coc,clist[i].length,current_key,clist,&njlist,index,jlist,x,m);

    if(njlist > NJMAX) printf("njlist %d > NJMAX\n",njlist);
    ninter += njlist * nilist;
    sumjlist += njlist; 
    nilistsum += nilist;     

    get_wcputime(&lt,st);
    tlist += lt; 

    calculate_force(x,m,a,pot,ilist,nilist,jlist,njlist,eps2);

    if(eps!=0){
      for(j=0;j<nilist;j++) pot[ilist[j]] += m[ilist[j]]/eps;
    }
    /* add 2002.7.24 */

    get_wcputime(&lt,st);
    tgrape += lt;

  }

  /*  g6_close(clusterid);*/

  if(logout_firstflag == 1){
    printf("ninter %lld ave %d sumjlist %lld sumilist %d\n",ninter,ninter/n,sumjlist,nilistsum);

    printf("cpu %g: making list\n",tlist);
    printf("cpu %g: calculating on GRAPE\n",tgrape);

   system("ps augx | grep jcode | grep -v grep");
   system("ps augx | grep j9 | grep -v grep");
   printf("***************************************\n");
  }

  if(logout_firstflag == 1) logout_firstflag = 0;

  (*dninter) = (double)ninter;
  
  free(jlist);free(ilist);

}




