#include<stdio.h>
#include<math.h>
#include<malloc.h>
#define REAL double
#define DIM 3
#include "jlist.h"


void calculate_force(x,m,a,pot,ilist,nilist,jlist,njlist)
REAL x[][3];
REAL m[];
REAL a[][3];
REAL pot[];
int ilist[];
int nilist;
struct jlist_t *jlist;
int njlist;
{
  int i,j,k,npipes,ii,jj,nn;
  double lt=0,st=0;
  double forceit=0,forcemjt=0,forcexjt=0;

  double (*xi)[3];
  double (*atmp)[3];
  double (*ptmp);

  xi = (double (*)[3])malloc(sizeof(double)*3*200);
  atmp = (double (*)[3])malloc(sizeof(double)*3*200);
  ptmp = (double *)malloc(sizeof(double)*200);

/*  static double xi[200][3];
  static double atmp[200][3];
  static double ptmp[200];
*/

  get_wcputime(&lt,&st);

  npipes = g5_get_number_of_pipelines();

/*  g5_set_xj(0,njlist,(*jlist).x);
  g5_set_mj(0,njlist,(*jlist).mass);
*/

  g5_set_xmj(0,njlist,(*jlist).x,(*jlist).mass);
  
  get_wcputime(&lt,&st);
  forcemjt += lt;

  g5_set_n(njlist);

  for(i=0;i<nilist;i+=npipes){
    nn = npipes;
    if((i+npipes)>nilist) nn = nilist-i;

/*    for(ii=0;ii<nn;ii++){
      for(k=0;k<3;k++) atmp[ii][k] = 0.0;
      ptmp[ii] = 0.0;
    }
*/
    for(ii=0;ii<nn;ii++){
      for(k=0;k<3;k++) xi[ii][k] = x[ilist[i+ii]][k];
    }
/*    g5_calculate_force_on_x(xi,atmp,ptmp,nn);*/

    g5_set_xi(nn,xi);
    g5_run();
    g5_get_force(nn,atmp,ptmp);

    for(ii=0;ii<nn;ii++){
      int iii;
      iii = ilist[i+ii];
      for(k=0;k<3;k++) a[iii][k] = atmp[ii][k];
      pot[iii] = -ptmp[ii];
/*printf("ii %d %d iii %d a %g %g %g pot %e\n",ii,ii%nn,iii,atmp[ii][0],atmp[ii][1],atmp[ii][2],ptmp[ii]);      */
    }
  }

  get_wcputime(&lt,&st);
  forceit += lt;
  free(xi); free(atmp); free(ptmp);

}

void initialize_force_function()
{
}

static int logout_firstflag=1;

void calculate_force_using_tree(n,x,m,a,pot,eps,clist,nwalk,walklist,index,maxx,st,dninter)
int n;
REAL x[][3];
REAL m[];
REAL a[][3];
REAL pot[];
REAL eps;
struct clist_t clist[];
int nwalk;
int walklist[];
int index[];
double maxx;
double *st;
double *dninter;
{
  int ii,i,j,nilistsum=0;
  double tlist,tgrape,lt=0;
  long long int current_key;
  long long int ninter,sumjlist;
  double tmpcm[3];

  int *ilist = NULL ;
  struct jlist_t *jlist;
  jlist = (struct jlist_t *)malloc(sizeof(struct jlist_t));

  if(logout_firstflag == 1){
    printf("npipe %d\n",g5_get_number_of_pipelines());
    g5_open();
  }


/*  g5_set_range(-maxx*2.0,maxx*2.0,m[0]/32.0);*/
  g5_set_range(-maxx*2.0,maxx*2.0,m[0]);
  g5_set_eps_to_all(eps);

  tlist = tgrape = 0;

  ninter = sumjlist = 0;
  nilistsum = 0;

  for(ii=0;ii<nwalk;ii++){

    int njlist=0,nilist,tmpif;
    double coc[3],totalm=0;
    i = walklist[ii];

  tmpcm[0]=tmpcm[1]=tmpcm[2]=0.0;

    nilist = clist[i].n;
    tmpif = clist[i].ifirst;

    ilist = (int *)realloc(ilist,sizeof(int)*nilist);
      
    for(j=0;j<nilist;j++) ilist[j] = index[j+tmpif];

    center_of_cell(clist[i].key,clist[i].key_level,clist[i].length,coc,maxx);
    current_key = 1;
    make_interaction_list(clist[i].key,coc,clist[i].length,current_key,clist,&njlist,index,jlist,x,m);

    if(njlist > NJMAX) printf("njlist %d > NJMAX\n",njlist);
    ninter += njlist * nilist;
    sumjlist += njlist; 
    nilistsum += nilist;     

    get_wcputime(&lt,st);
    tlist += lt; 

/*
  for(j=0;j<njlist;j++){
    tmpcm[0] += (jlist->x[j][0])*(jlist->mass[j]);
    tmpcm[1] += (jlist->x[j][1])*(jlist->mass[j]);
    tmpcm[2] += (jlist->x[j][2])*(jlist->mass[j]);
  }
  if((fabs(tmpcm[0])>1.0e-15)||(fabs(tmpcm[1])>1.0e-15)||(fabs(tmpcm[2])>1.0e-15)){
  printf("ii %d cm %g %g %g\n",ii,tmpcm[0],tmpcm[1],tmpcm[2]);
  }
*/

    calculate_force(x,m,a,pot,ilist,nilist,jlist,njlist);

    if(eps!=0){
      for(j=0;j<nilist;j++) pot[ilist[j]] += m[ilist[j]]/eps;
    }    /* add 2002.7.24 */

    get_wcputime(&lt,st);
    tgrape += lt;

  }

/*printf("force time xjt %g mjt %g it %g\n",forcexjt,forcemjt,forceit);*/

  /*  g5_close();*/

  (*dninter) = ((double)ninter);

  if(logout_firstflag == 1){
    long long int nave;
    nave = ninter/n;
    printf("ninter %lld ave %lld sumjlist %lld sumilist %d\n",ninter,nave,sumjlist,nilistsum);
    printf("cpu %g: making list\n",tlist);
    printf("cpu %g: calculating on GRAPE\n",tgrape);

   system("ps augx | grep jcode | grep -v grep");
   system("ps augx | grep j9 | grep -v grep");
   printf("***************************************\n");
  }


  
  if(logout_firstflag == 1) logout_firstflag = 0;

  free(jlist);free(ilist);

}



