#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>

#ifdef MEMO
struct    *rusage {
         struct timeval ru_utime;      /* user time used */
		(tv_sec,tv_usec)
         struct timeval ru_stime;      /* system time used */
         int  ru_maxrss;          /* maximum resident set size */
         int  ru_ixrss;      /* currently 0 */
         int  ru_idrss;      /* integral resident set size */
         int  ru_isrss;      /* currently 0 */
         int  ru_minflt;          /* page faults not requiring physical I/O */
         int  ru_majflt;          /* page faults requiring physical I/O */
         int  ru_nswap;      /* swaps */
         int  ru_inblock;         /* block input operations */
         int  ru_oublock;         /* block output operations */
         int  ru_msgsnd;          /* messages sent */
         int  ru_msgrcv;          /* messages received */
         int  ru_nsignals;        /* signals received */
         int  ru_nvcsw;      /* voluntary context switches */
         int  ru_nivcsw;          /* involuntary context switches */
};
#endif
							
void get_cputime(laptime,sprittime)
double *laptime;
double *sprittime;
{
	struct rusage x;
	double sec,microsec;

	getrusage(RUSAGE_SELF,&x);
	sec = x.ru_utime.tv_sec + x.ru_stime.tv_sec ;
	microsec = x.ru_utime.tv_usec + x.ru_stime.tv_usec ;
	*sprittime = sec + microsec / 1000000.0 - *laptime;
	*laptime = sec + microsec / 1000000.0;

/*	printf("sprit lap =%e %e \n",*sprittime,*laptime);*/
}

