/* created from pcixmem.h.template by npcixme.csh. do not edit. */

#ifndef PCIXMEM_H
#define PCIXMEM_H

// #include <asm/page.h>
#include <linux/ioctl.h>

#define DEVNAME "pcixmem"
#define NPCIXMEM (1) /* max # of pcixmem device */
#ifndef PAGE_SIZE
#define PAGE_SIZE 4096
#endif
#define PAGE_REQ_ORDER (1) /* request 2^order pages for DMA buffer (max 2^5) */
#define XHIBRAMORDER (3) /* 2^3 pages */
#define XHIBRAMSIZE (PAGE_SIZE * (1<<XHIBRAMORDER)) /* 32kbyte, 8pages */
#define XHIBRAMWORDS (XHIBRAMSIZE>>2) /* dma buffer size in quad-word */

/* structure for read/write ioctl */
#include <linux/ioctl.h>
struct long_access
{
    unsigned int addr;
    unsigned int  data;
};
enum {MAP_XHIBMEM = 0, MAP_DMARBUF, MAP_DMAWBUF, MAP_BACKEND, MAP_DBLBUF,};

#define PCIXMEM_MAGIC (5)
#define WRITE_CFG            _IOW(PCIXMEM_MAGIC, 5, struct long_access)
#define READ_CFG             _IOWR(PCIXMEM_MAGIC, 4, struct long_access)
#define MAP_BAR2_DENSE_ADDR  _IO(PCIXMEM_MAGIC, 11)
#define DMA_MAP_LOAD         _IOWR(PCIXMEM_MAGIC, 17, unsigned long)
#define GET_DMAR_PA         _IOWR(PCIXMEM_MAGIC, 18, unsigned long)
#define GET_DMAW_PA         _IOWR(PCIXMEM_MAGIC, 19, unsigned long)
#define SET_MAP_MODE         _IOW(PCIXMEM_MAGIC, 20, unsigned int)

#endif /* PCIXMEM_H */
