#! /bin/csh

if (${#argv} < 1) then
  echo ''
  echo Link device driver of PCI-X Host Interface Board \(XHIB\) to kernel image.
  echo usage: $0 module_name
  echo ''
  exit (1)
endif 

set module = $1
set device = $1
set group = "wheel"
set mode = "666"

echo ''
echo -- install module ${module} --
echo ''
set npcixmem = `grep '1556:5555' /proc/pci | wc | awk '{print $1}'`
# set npcixmem = `grep "Multimedia video" /proc/pci | wc | awk '{print $1}'`
set npcixmem = `grep "Multimedia video" /proc/pci | wc | awk '{print $1}'`
echo "${npcixmem} PCI-X host interface board(s) (XHIB) found."
echo ''
echo rm -f /dev/${device}\[0-9\]
rm -f /dev/${device}[0-9]
echo ''
echo /sbin/insmod -f ${module}.o
/sbin/insmod -f ${module}.o

set major = `cat /proc/devices | awk '$2=="'${module}'"{print $1}'`

set i = 0
while (${i} < ${npcixmem})
  echo mknod /dev/${device}${i} c ${major} ${i}
  mknod /dev/${device}${i} c ${major} ${i}
  @ i++
end

echo ''
echo chgrp ${group} /dev/${device}?
chgrp ${group} /dev/${device}?
echo ''
echo chmod ${mode} /dev/${device}?
chmod ${mode} /dev/${device}?
echo ''
echo ls -l /dev/${device}?
ls -l /dev/${device}?
echo ''
echo -- done --
echo ''
