#include <stdio.h>
#include "xhibutil.h"

int
main(void)
{
    UINT64 *rbuf;
    UINT64 *wbuf;
    UINT64 *backend;
    UINT64 data;
    
    xhib_set_nclusters(1);

    xhib_openMC(0, &rbuf, &wbuf, &backend);

    rbuf[0] = 0x123456789abc0000ll;
    rbuf[1] = 0x123456789abc1111ll;
    rbuf[2] = 0x123456789abc2222ll;
    wbuf[0] = 0;
    wbuf[1] = 0;
    wbuf[2] = 0;
    
    xhib_dmarMC(0, 3, rbuf);
    xhib_dmawMC(0, 3, wbuf);

    printf("rbuf 0x%016llx 0x%016llx 0x%016llx\n", rbuf[0], rbuf[1], rbuf[2]);
    printf("wbuf 0x%016llx 0x%016llx 0x%016llx\n", wbuf[0], wbuf[1], wbuf[2]);

    /* PIO read from byte address 0 */
    data = backend[0];
    printf("data 0x%016llx\n", data);

    /* PIO read from byte address 8 */
    data = backend[1];
    printf("data 0x%016llx\n", data);

    /* PIO write to byte address 0 */
    backend[0] = data; /* XHIB synthesized with initial
			  ./xhib/vhdl/backend.vhd is designed to return
			  0x0807060504030201 to g6_piodata,
			  independent of whatever value may be written
			  to. Thus PIO write does not affect the value
			  read by the following PIO read. */

    data = backend[0];
    printf("data 0x%016llx\n", data); /* 0x0807060504030201 should be read */

    xhib_closeMC(0);

    exit(0);
}
