#include<stdio.h>

static int test_force_overflow_flag = 1;
static int test_jerk_overflow_flag = 1;
static int test_pot_overflow_flag = 1;

void g6_set_overflow_flag_test_mode(int force_test_mode,
                                    int jerk_test_mode,
                                    int pot_test_mode)
{
   test_force_overflow_flag = force_test_mode;
   test_jerk_overflow_flag = jerk_test_mode;
   test_pot_overflow_flag = pot_test_mode;
}

void g6_set_overflow_flag_test_mode_(int *force_test_mode,
                                     int *jerk_test_mode,
                                     int *pot_test_mode)
{
   g6_set_overflow_flag_test_mode(*force_test_mode,
                                  *jerk_test_mode,
                                 *pot_test_mode);
}

void g6_get_overflow_flag_test_mode_(int *force_test_mode,
                                     int *jerk_test_mode,
                                     int *pot_test_mode)
{
   *force_test_mode=test_force_overflow_flag;
   *jerk_test_mode= test_jerk_overflow_flag;
   *pot_test_mode=  test_pot_overflow_flag;
}

void g6_get_overflow_flag_test_mode(int *force_test_mode,
                                    int *jerk_test_mode,
                                    int *pot_test_mode)
{
    g6_get_overflow_flag_test_mode_(force_test_mode,
                                    jerk_test_mode,
                                    pot_test_mode);
}

void g6calc_firsthalf0_(int * clusterid,
                        int * nj,
	                int * ni,
	                int index[],
	                double xi[][3],
	                double vi[][3],
	                double fold[][3],
	                double jold[][3],
	                double phiold[],
	                double eps2[],
	                double h2[],
	                int * mode)
{
    int ii,ii2, ni2;
    for (ii= 0; ii< *ni; ii++){
       double six = 6.0;
       double zero = 0.0;
       g6_set_i_particle_scales_from_real_value_(clusterid, &ii,  fold[ii],
                                                  jold[ii], phiold+ii,
                                                  &six,&zero);
        g6_set_i_particle_(clusterid, &ii, index+ii, xi[ii], vi[ii], eps2+ii,
                           h2+ii);
    }
    g6_set_nip_(clusterid, ni);
    g6_set_njp_(clusterid, nj);
}

void g6calc_firsthalf_(int * clusterid, 
                      int * nj,  
                      int * ni,  
                      int index[],  
                      double xi[][3],  
                      double vi[][3],  
                      double fold[][3],
                      double jold[][3],  
                      double phiold[],  
                      double *eps2,   
                      double h2[])  
{
    int ii,ii2, ni2;
   for (ii= 0; ii< *ni; ii++){
     double six = 6.0;
     double zero = 0.0;
       g6_set_i_particle_scales_from_real_value_(clusterid, &ii,  fold[ii],
                                                  jold[ii], phiold+ii,
                                                  &six,&zero);
        g6_set_i_particle_(clusterid, &ii, index+ii, xi[ii], vi[ii], eps2,
                           h2+ii);
    }
    g6_set_nip_(clusterid, ni);
    g6_set_njp_(clusterid, nj);
}

void g6calc_firsthalf(int clusterid, 
                      int nj,  
                      int ni,  
                      int index[],  
                      double xi[][3],  
                      double vi[][3],  
                      double fold[][3],
                      double jold[][3],  
                      double phiold[],  
                      double eps2,   
                      double h2[])  
{
  g6calc_firsthalf_(&clusterid, &nj, &ni, index, xi, vi, fold, jold, phiold, &eps2, h2);  
}

static index_scalechanged;

int g6_changed_index_()
{
    return index_scalechanged;
}

int g6_print_chip_status_(int * clusterid)
{
}

int g6calc_lasthalf_(int * clusterid,
                     int * nj,
                     int * ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double *eps2,
                     double h2[], 
                     double acc[][3],
                     double jerk[][3],
                     double pot[])     
{
    int flag[48];
    int ii,i;
    int error,mask,count;
    double * eps2p;
    index_scalechanged = -1;
    
    error = g6_get_force_(clusterid, acc, jerk, pot, flag);
    if (error!=0) {
       fprintf(stderr,"(g6calc_lasthalf) g6_get_force error occurs\n");
       return -1;
    }

    mask = 0xdb6db;
    if(test_force_overflow_flag == 0) mask &= 0xfffffe00; 
    if(test_jerk_overflow_flag == 0)  mask &= 0xfffc01ff; 
    if(test_pot_overflow_flag == 0)   mask &= 0xffe3ffff;        

    for (ii= 0; ii< *ni; ii++){

     /*      if ((flag[ii]&0xf0000000)!= 0){
	fprintf(stderr,"(g6calc_lasthalf) parity error %x \n",flag[ii]); */

      if ((flag[ii]&0x60000000)!= 0){
          fprintf(stderr,"(g6calc_lasthalf) memory ECC error %x \n",flag[ii]);
          return -1;
      }else if ((flag[ii]&mask)!= 0){
	count=1;
	do{
	  index_scalechanged = ii;
	  fprintf(stderr,"(g6calc_lasthalf) overflow %x %d %d %d -- change scales\n",flag[ii],ii,index[ii],(*ni));
	  g6_adjust_ip_scales_(clusterid,&ii,flag+ii);
  /*	  eps2p = eps2 + ii;*/
	  eps2p = eps2;
	  g6_set_i_particle_(clusterid, &ii, index+ii, xi[ii], vi[ii], eps2p, h2+ii);
	  g6_set_nip_(clusterid, ni);
	  g6_set_njp_(clusterid, nj);
          error = g6_get_force_(clusterid, acc, jerk, pot, flag);
          if (error!=0) {
            fprintf(stderr,"(g6calc_lasthalf) g6_get_force error occurs\n");
            return -1;
          }
	  if(count==10){
            fprintf(stderr,"(g6calc_lasthalf) overflow %x %d %d %d -- abandoned\n",flag[ii],ii,index[ii],(*ni));
	    for(i=0;i<(*ni);i++) fprintf(stderr,"(g6calc_lasthalf) a %g %g %g j %g %g %g flag %x\n",
				 acc[i][0],acc[i][1],acc[i][2],jerk[i][0],jerk[i][1],jerk[i][2],flag[i]);
  	    return -1;
	  }
          count++;
        }while((flag[ii]&mask)!= 0);
      }
    }
    return 0;
}

int g6calc_lasthalf(int clusterid,
                     int nj,
                     int ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double eps2,
                     double h2[], 
                     double acc[][3],
                     double jerk[][3],
                     double pot[])     
{
  return g6calc_lasthalf_(&clusterid, &nj, &ni, index, xi, vi, &eps2, h2, acc, jerk, pot);     
}

int g6calc_lasthalf2_(int * clusterid,
                     int * nj,
                     int * ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double *eps2,
                     double h2[], 
                     double acc[][3],
                     double jerk[][3],
                     double pot[],     
                      int nnbindex[])
{
  int flag[48];
    int ii,i;
    int error;
    int mask,count;
    double * eps2p;
    index_scalechanged = -1;    

    error = g6_get_force_etc_(clusterid, acc, jerk, pot, nnbindex,flag);
    if (error!=0) {
       fprintf(stderr,"(g6calc_lasthalf) g6_get_force error occurs\n");
       return -1;
    }

    mask = 0xdb6db;
    if(test_force_overflow_flag == 0) mask &= 0xfffffe00; 
    if(test_jerk_overflow_flag == 0)  mask &= 0xfffc01ff; 
    if(test_pot_overflow_flag == 0)   mask &= 0xffe3ffff;        

    for (ii= 0; ii< *ni; ii++){
/*      if ((flag[ii]&0xf0000000)!= 0){
          fprintf(stderr,"(g6calc_lasthalf2) parity error %x \n",flag[ii]); */

      if ((flag[ii]&0x60000000)!= 0){
          fprintf(stderr,"(g6calc_lasthalf2) memory ECC error %x \n",flag[ii]);
          return -1;
      }else if ((flag[ii]&mask)!= 0){
	count=1;
	do{
          index_scalechanged = ii;
          fprintf(stderr,"(g6calc_lasthalf2) overflow %x %d %d %d -- change scales\n",flag[ii],ii,index[ii],(*ni));
	  g6_adjust_ip_scales_(clusterid,&ii,flag+ii);
  /*	  eps2p = eps2 + ii;*/
	  eps2p = eps2 ;
	  g6_set_i_particle_(clusterid, &ii, index+ii, xi[ii], vi[ii], eps2p, h2+ii);
	  g6_set_nip_(clusterid, ni);
	  g6_set_njp_(clusterid, nj);
          error = g6_get_force_etc_(clusterid, acc, jerk, pot, nnbindex, flag);
          if (error!=0) {
            fprintf(stderr,"(g6calc_lasthalf2) g6_get_force error occurs\n");
            return -1;
          }
          if(count==10){
            fprintf(stderr,"(g6calc_lasthalf2) overflow %x %d %d %d -- abandoned\n",flag[ii],ii,index[ii],(*ni));
	    for(i=0;i<(*ni);i++) fprintf(stderr,"(g6calc_lasthalf2) a %g %g %g j %g %g %g flag %x\n",
				 acc[i][0],acc[i][1],acc[i][2],jerk[i][0],jerk[i][1],jerk[i][2],flag[i]);
  	    return -1;
	  }
	  count++;
        }while((flag[ii]&mask)!= 0);
      }
    }
    return 0;
}

                    
int g6calc_lasthalf2(int clusterid,
                     int nj,
                     int ni,
                     int index[],
                     double xi[][3],
                     double vi[][3],
                     double eps2,
                     double h2[], 
                     double acc[][3],
                     double jerk[][3],
                     double pot[],     
                      int nnbindex[])
{
  return g6calc_lasthalf2_(&clusterid, &nj, &ni, index, xi, vi, &eps2, h2, acc, jerk, pot, nnbindex);
}

void g6_reinitialize(int clusterid)
{
}

void g6_reinitialize_(int *clusterid)
{
  g6_reinitialize(*clusterid);
}

int g6_initialize_jp_buffer(int clusterid, int size)
{
}

int g6_initialize_jp_buffer_(int* clusterid, int* size)
{
  return g6_initialize_jp_buffer(*clusterid, *size);
}

int g6_set_j_particle_mxonly(int  clusterid,
			     int address,
			     int index,
			     double mass,
			     double x[3] /* position */)
{
  double tj = 0.0;
  double dtj = 1.0;
  double a2by18[3];
  double a1by6[3];
  double aby2[3];
  double v[3];
  int k;
  for(k=0;k<3;k++){
    a2by18[k] = 0.0;
    a1by6[k] = 0.0;
    aby2[k] = 0.0;
    v[k] = 0.0;
  }
  return g6_set_j_particle_(&clusterid,&address,&index,&tj,&dtj,&mass,
			    a2by18, a1by6, aby2, v, x);
}

int g6_set_j_particle_mxonly_(int* clusterid,
			      int* address,
			      int* index,
			      double* mass,
			      double x[3] /* position */)
{
  double tj = 0.0;
  double dtj = 1.0;
  double a2by18[3];
  double a1by6[3];
  double aby2[3];
  double v[3];
  int k;
  for(k=0;k<3;k++){
    a2by18[k] = 0.0;
    a1by6[k] = 0.0;
    aby2[k] = 0.0;
    v[k] = 0.0;
  }
  return g6_set_j_particle_(clusterid,address,index,&tj,&dtj,mass,
			    a2by18, a1by6, aby2, v, x);
}

int g6_flush_jp_buffer(int  clusterid)
{
}

int g6_flush_jp_buffer_(int*  clusterid)
{
}

int g6_reset_fofpga(int  clusterid)
{
}

int g6_reset_fofpga_(int*  clusterid)
{
}
