#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include "memmap.h"
#include "xhibutil.h"

#define NPCIMEM 16

static unsigned int *phib[NPCIMEM];
static unsigned int *resbufp[NPCIMEM];
static unsigned long resbufpa[NPCIMEM]; 
static unsigned int off[NPCIMEM];
static int dmainit[NPCIMEM]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

/* lock file should permit everyone to be accessed with O_WRONLY */
static char g5lockfile[1][255];
static int lockfd[1];
static int fd_opened[1];

UINT64 *rbuf;
UINT64 *wbuf;
UINT64 *backend;
UINT64 data;

//static unsigned int *Rbuf; /* DMA read buffer */
//static unsigned int Piow_buf[8192]; /* PIO write buffer */

void lock_grape(int devid)
{
  static char buf[256];

  /*  sprintf(g5lockfile[0], "/tmp/phib_g6a");*/
  sprintf(g5lockfile[0], "/dev/pcixmem0");  

  if (!fd_opened[devid])
    {
      lockfd[devid] = open(g5lockfile[devid], O_WRONLY);
      if (lockfd[devid] == -1 && errno == ENOENT)
	{
	  sprintf(buf, "touch %s; chmod a+w %s",
		  g5lockfile[devid],
		  g5lockfile[devid]);
	  system(buf);
	  lockfd[devid] = open(g5lockfile[devid], O_WRONLY);
	}
    }
  fd_opened[devid] = 1;
  if (lockfd[devid] == -1)
    {
      sprintf(buf, "failed to open %s.\n", g5lockfile[devid]);
      perror(buf);
     exit (2);
    }

  if (lockf(lockfd[devid], F_TLOCK, getpagesize()))
    {
      if ((errno == EACCES) || (errno == EAGAIN)) /* JCL 15 May 2000 */
	{
	  fprintf(stderr,"Someone is using GRAPE-6A, sleep...\n", devid);
	  if (lockf(lockfd[devid], F_LOCK, getpagesize()))
	    {
	      perror("LOCKF failed");
	      exit (2);
	    }
	              else
			{
			  fprintf(stderr,"Got GRAPE-6A...\n");
			}
	}
              else
		{
		  perror("LOCKF failed");
		  exit (2);
		}
    }
  if (lockf(lockfd[devid], F_LOCK, getpagesize()))
    {
      perror("LOCKF failed");
      exit (2);
    }
}

void unlock_grape(int devid)
{
  if (lockf(lockfd[devid], F_ULOCK, getpagesize()))
    {
      fprintf(stderr,"LOCKF (unlock) failed with %d\n", errno);
      exit (2);
    }
}
		
void g6_reset(int devid)
{
  int i;

    rbuf[0] = 0x0000000100000004ll;
    rbuf[1] = 0x0000000000000000ll;
    rbuf[2] = 0x0000000000000000ll;
    rbuf[3] = 0x0000000000000000ll;
    rbuf[4] = 0x0000000000000000ll;

    xhib_dmarMC(0, 5, rbuf);
}

void g6_reset_(int *devid)
{
  g6_reset(*devid);
}

#define DMASTAT  (0x20)

void g6_init(int devid)
{
  xhib_set_nclusters(1);

  xhib_openMC(0, &rbuf, &wbuf, &backend);
  
  //  backend[0] = 0x0;
  //  backend[0] = 0xffffffffffffffffll;

  g6_reset(devid);
  TBmemWrite(devid, DMASTAT, 0x80000000);
}


void g6_close(int devid)
{
  xhib_closeMC(0);
  unlock_grape(0);
}

int g6_npipes()
{
    return 48;
}

int g6_npipes_()
{
  return g6_npipes();
}

int g6_get_number_of_pipelines_()
{
    return 48;
}

int g6_get_number_of_pipelines()
{
    return 48;
}

void g6_set_ipdata(
int devid,
unsigned int ipdata[])
{
  int i,nword_g6,nword_ipd,nword_pcix;
  int iii;
  UINT64 tmp, tmp2;
    
  nword_g6 = ipdata[1];
  nword_ipd = nword_g6 + 2;
  nword_pcix = 2 * nword_ipd;
    
  //  fprintf(stderr,"ip nword %d\n",nword);

  //  rbuf[0] = 0x0000000400000000ll | nword_pcix ;
  rbuf[0] = 0x0000000400000000ll | nword_ipd ;  

  /*
  for(i=0;i<nword_ipd;i++){
    iii = 2*i+1;
    tmp = ipdata[i];
    tmp2 = (tmp<<32) | tmp;
    rbuf[iii] = tmp2;
    rbuf[iii+1] = tmp2;
  }
  */

  for(i=0;i<nword_ipd;i++){
    tmp = ipdata[i];
    tmp2 = (tmp<<32) | tmp;
    rbuf[i+1] = tmp2;
  }
  
  //  for(i=0;i<(nword_pcix+1);i++) printf("ip %x 0x%016llx\n",i,rbuf[i]);
  //  for(i=0;i<(nword_ipd+1);i++) printf("ip %x 0x%016llx\n",i,rbuf[i]);  
    
   xhib_dmarMC(0, (nword_ipd+1), rbuf);

   //   xhib_dmarMC(0, (nword_pcix+1), rbuf);   
   //    xhib_piowMC(0, (nword_pcix+1), rbuf);

}


void g6_set_ipdata_nb(
int devid,
unsigned int ipdata[],
int ichip)
{
  int i,nword_g6,nword_ipd,nword_pcix;
  int iii;
  UINT64 tmp, tmp2;
    
  nword_g6 = ipdata[1];
  nword_ipd = nword_g6 + 2;
    
  if(ichip==0) rbuf[0] = 0x000000e400000000ll | nword_ipd ; /* 1110 */
  if(ichip==1) rbuf[0] = 0x000000d400000000ll | nword_ipd ; /* 1101 */
  if(ichip==2) rbuf[0] = 0x000000b400000000ll | nword_ipd ; /* 1011 */
  if(ichip==3) rbuf[0] = 0x0000007400000000ll | nword_ipd ; /* 0111 */

  for(i=0;i<nword_ipd;i++){
    tmp = ipdata[i];
    tmp2 = (tmp<<32) | tmp;
    rbuf[i+1] = tmp2;
  }
  
//  for(i=0;i<(nword_ipd+1);i++) printf("ip %x 0x%016llx\n",i,rbuf[i]);  
    
   xhib_dmarMC(0, (nword_ipd+1), rbuf);
}


int g6_get_fodata(
int devid,
unsigned int nword,
unsigned int fodata[][4])
{
  int i,nn,ii,nnn,dmasize,ndfo,iii;
     
  //  fprintf(stderr,"nword %d\n",nword);

   dmasize = 256;
   //   dmasize = 672;  

  for(i=0;i<nword;i+=dmasize){
    if((i+dmasize)>nword){
      nn = nword - i ;
    }else{
      nn = dmasize;
    }  

    nnn = 2*nn;
    xhib_dmawMC(0, nnn, wbuf);

    //   for(ii=0;ii<nnn;ii++) fprintf(stderr,"wbuf %x %016llx\n",ii,wbuf[ii]);
//     if(i==0) fprintf(stderr,"wbuf %x %016llx %016llx %016llx\n",ii,wbuf[0],wbuf[1],wbuf[2]);   
    for(ii=0;ii<nn;ii++){
      fodata[i+ii][0] = wbuf[2*ii];
      fodata[i+ii][1] = (wbuf[2*ii]>>32);
      fodata[i+ii][2] = wbuf[2*ii+1];
      fodata[i+ii][3] = (wbuf[2*ii+1]>>32);
    }
  }

  //  g6_reset(devid);

#ifdef LIBG65
  ndfo = 9;
#else
  ndfo = 14;  
#endif

  for(i=0;i<nword;i+=ndfo){    
    UINT64 tmp1,tmp2;
    unsigned int nnbmin;

    for(iii=0;iii<8;iii+=2){
      tmp1 = 0;
      for(ii=0;ii<4;ii++){
        tmp2 = fodata[i+iii][ii];
        tmp2 = (tmp2<<32) | fodata[i+iii+1][ii];
        tmp1 += tmp2;
      }
      fodata[i+iii][0] = (tmp1>>32);    
      fodata[i+iii+1][0] = tmp1;
    }

#ifndef LIBG65

    for(iii=8;iii<11;iii++){
      tmp1 = fodata[i+iii][0];
      for(ii=1;ii<4;ii++) tmp1 += fodata[i+iii][ii];
      fodata[i+iii][0] = tmp1;
    }

    nnbmin = fodata[i+11][0];
    for(ii=1;ii<4;ii++){
      if(nnbmin>fodata[i+11][ii]){
        nnbmin = fodata[i+11][ii];
        fodata[i+12][0] = fodata[i+12][ii];    
      }
    }

    tmp1 = fodata[i+13][0];
    for(ii=1;ii<4;ii++) tmp1 |= fodata[i+13][ii];
    fodata[i+13][0] = tmp1;

#endif

#ifdef LIBG65

    tmp1 = fodata[i+8][0];
    for(ii=1;ii<4;ii++) tmp1 |= fodata[i+8][ii];
    fodata[i+8][0] = tmp1;

#endif
    //      fprintf(stderr,"fodata %08x\n",fodata[i+13]);

  }

  return nword;
}

int g6_get_fodata_nb(
unsigned int fodata[],
int ichip)
{

  int i,focnt,focnt0,focnt00,nword;
  int adr,size;
  int ii,sum,devid=0,ip;

  i=0;
  for(ip=0;ip<3;ip++){
    xhib_dmawMC(0, 2, wbuf);
    if(ichip==0){
      nword = 0x3ff & wbuf[0];
      fodata[i] = wbuf[0];
    }
    if(ichip==1){
      nword = 0x3ff & (wbuf[0]>>32);
      fodata[i] = (wbuf[0]>>32);
    }
    if(ichip==2){
      nword = 0x3ff & wbuf[1];
      fodata[i] = wbuf[1];
    }
    if(ichip==3){
      nword = 0x3ff & (wbuf[1]>>32);	
      fodata[i] = (wbuf[1]>>32);
    }
    //fprintf(stderr,"ip %d nword %d fodata %d %x\n",ip,nword,i,fodata[i]);
    i++;
    xhib_dmawMC(0, (4*nword), wbuf);
    for(ii=0;ii<(2*nword);ii++){
      if(ichip==0) fodata[i] = wbuf[2*ii];
      if(ichip==1) fodata[i] = (wbuf[2*ii]>>32);
      if(ichip==2) fodata[i] = wbuf[2*ii+1];
      if(ichip==3) fodata[i] = (wbuf[2*ii+1]>>32);      
      //fprintf(stderr,"fodata %d %x\n",i,fodata[i]);
      i++;
    }
  }
  focnt = i; 

  //  for(ii=0;ii<focnt;ii++) fprintf(stderr,"nb fodata %x %x\n",ii,fodata[ii]);

  return focnt;

}

static UINT64 piowbuf[XHIBRAMWORDS];

void g6_set_jpdata(
int devid,
unsigned int nword,
unsigned int jpdata[][4])
{
  int i;
  int ii,ijp,ndjp;

#ifdef LIBG65
  ndjp = 6;   
#else
  ndjp = 18;
#endif

  //  fprintf(stderr,"jp nword %d\n",nword);

  ii = 1; ijp = 0;

  for(i=0;i<nword;i++){
    UINT64 tmp,tmp2,tmp3,tmp4;

    tmp = jpdata[i][1];
    rbuf[ii] = (tmp<<32) | jpdata[i][0];
    tmp3 = jpdata[i][3];
    rbuf[ii+1] = (tmp3<<32) | jpdata[i][2];
    ii+=2;ijp++;

    /*
    tmp = jpdata[i][0];
    tmp2 = (tmp<<32) | tmp;
    rbuf[ii] = tmp2;
    rbuf[ii+1] = tmp2;
    ii+=2;ijp++;
    */
    
    /*
    rbuf[ii] = jpdata[i];
    rbuf[ii] = (rbuf[ii]<<32) | rbuf[ii];
    ii++;
    rbuf[ii] = rbuf[ii-1];
    ii++; 
    */

    if(ijp == ndjp){
      int iii;
      for(iii=0;iii<8;iii++) rbuf[ii+iii] = 0;
      ii+=8;
      ijp=0; 
    }
  }
  nword = ii;
#ifdef LIBG65
  rbuf[0] = 0x0000000a00000000ll | (nword-1);  
#else
  rbuf[0] = 0x0000000200000000ll | (nword-1);
#endif
  
  //for(i=0;i<nword;i++) fprintf(stderr,"rbuf %d %016llx\n",i,rbuf[i]);
  //  exit(1);
  
   xhib_dmarMC(0, nword, rbuf);

}  



