#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "memmap.h"

UINT64 *rbuf;
UINT64 *wbuf;
UINT64 *backend;
UINT64 data;

void g6_reset(int devid)
{
    rbuf[0] = 0x0000000000000000ll;
    rbuf[1] = 0x1000000000000000ll;
    rbuf[2] = 0x0000000000000000ll;

    xhib_dmarMC(0, 3, rbuf);
}

main(int argc, char **argv)
{
  int devid=0;
  int ichip;

  if(argc==2){
    sscanf(argv[1],"%d",&ichip);
  }else{
    ichip = 0;
  }  

  xhib_set_nclusters(1);

  xhib_openMC(0, &rbuf, &wbuf, &backend);

  if(ichip==1){  
    backend[0] = 0xffffffffffffffffll;
  }else{
    backend[0] = 0x0;
  }
  printf("ichip %d\n",ichip);

  g6_reset(devid);

  xhib_closeMC(0);
}

