#ifndef MEMMAP_H
#define MEMMAP_H

#define CFG_SIZE   (0x80)
#define MEM_SIZE   (XHIBRAMSIZE)

#ifdef __alpha
#ifdef __osf__
#include <c_asm.h>
#endif /* __osf__ */
#define MB asm("mb")
#else /* __alpha */
#define MB /* do nothing */
#endif

#include "typedef.h"

UINT32 * TBopen(int devid, UINT64 **backend, UINT64 **dblbuf);
void TBterm(int devid);
UINT32 TBconfigRead(int devid, UINT32 addr);
void TBconfigWrite(int devid, UINT32 addr, UINT32 value);
UINT32 TBmemRead(int devid, UINT32 addr);
void TBmemWrite(int devid, UINT32 addr, UINT32 value);
void TBgetDmaInfo(int devid,
		  unsigned long *dmarpa, UINT64 **dmarva,
		  unsigned long *dmawpa, UINT64 **dmawva);

#endif /* MEMMAP_H */
