/************************************************
   radius7.c(radius.c for sticky7.c)	
************************************************/
#include <string.h>
#include "./sticky.h"
  
#define C_H_VALUE 6 /* (Casertano & Hut 1985 's j) */

void sort_nblist(xi,x,nblists,nbns)
REAL xi[DIM];
REAL x[NMAX][DIM];
int nblists[NBMAX];
int nbns;
{
	int j;
	static REAL r2[NBMAX];

	for(j=0;j<nbns;j++){
	  r2[j] = (xi[0]-x[nblists[j]][0])*(xi[0]-x[nblists[j]][0])
	  	+ (xi[1]-x[nblists[j]][1])*(xi[1]-x[nblists[j]][1])
	  	+ (xi[2]-x[nblists[j]][2])*(xi[2]-x[nblists[j]][2]);
	}
	sort_two_values(0,nbns-1,r2,nblists);
}

void obtain_individual_density(x,m,nblist,rho)
REAL x[NMAX][DIM];
REAL m[NMAX];
int nblist[NBMAX];
REAL *rho;
{
/* in nblist[0], i itself is stored. */

	REAL total_mass=0.0,r2;
	int i;
	
	for(i=0;i<=(C_H_VALUE-1);i++) total_mass += m[nblist[i]]; 

	r2 = (x[nblist[0]][0]-x[nblist[C_H_VALUE]][0])*(x[nblist[0]][0]-x[nblist[C_H_VALUE]][0]) 
	   + (x[nblist[0]][1]-x[nblist[C_H_VALUE]][1])*(x[nblist[0]][1]-x[nblist[C_H_VALUE]][1]) 
	   + (x[nblist[0]][2]-x[nblist[C_H_VALUE]][2])*(x[nblist[0]][2]-x[nblist[C_H_VALUE]][2]) ;

	*rho = 3.0/(4.0*PI)*total_mass/(r2*sqrt(r2));
}

void calculate_local_density_on_host(x,m,n,rho,prev,index)
REAL x[NMAX][DIM];
REAL m[NMAX];
int n;
REAL rho[NMAX];
struct previous *prev;
int index[NMAX];
{
        int min_nbn;
        REAL h2; 
        int i,j,d;
        REAL r2;
        REAL dx[DIM];  
        static int nblist[NBMAX];
        int nbn,in,ii,jj;

        REAL newh2,rc2crit,prc;

        h2=8.0/pow((double)n,2.0/3.0);
        min_nbn=8;

	in=0;
	prc = ((*prev).rc);
/*printf("prc %e in %d\n",prc,in);*/
	if(prc<1.0e-1) prc = 1.0e-1;
#ifdef TIDAL_FIELD
/*	if(prc<2.0e-1) prc = 2.0e-1;*/
#endif
	rc2crit = 9.0*prc*prc;
        for(i=0;i<n;i++){
          if((*prev).flag==1){
            double drc2;
            drc2 = (x[i][0]-(*prev).cod[0])*(x[i][0]-(*prev).cod[0])
                 + (x[i][1]-(*prev).cod[1])*(x[i][1]-(*prev).cod[1])
                 + (x[i][2]-(*prev).cod[2])*(x[i][2]-(*prev).cod[2]);
            if(drc2>rc2crit){
              rho[i] = 0.0;
            }else{
	      index[in] = i;
	      in++;
            }
          }else{
            index[in] = i;
	    in++;
          }
	}

        for(i=0;i<in;i++){
	  nbn = 0;    
	  ii = index[i];
          for(j=0;j<in;j++){
	    jj = index[j];
	    r2 = 0.0;  
            for(d=0;d<DIM;d++){
              dx[d] = x[jj][d] - x[ii][d];
              r2 += dx[d] * dx[d];
            }
            if(r2<h2){
              nblist[nbn]=jj;
              nbn++;
            }
	  }
          newh2 = h2;
          while(nbn<min_nbn){
            newh2 *= 4.0;
            nbn=0;
	    for(j=0;j<in;j++){
	      jj = index[j];
              r2 = 0.0;
	      for(d=0;d<DIM;d++){
                dx[d] = x[jj][d] - x[ii][d];
                r2 += dx[d] * dx[d];
              }
              if(r2<newh2){ 
                nblist[nbn]=jj;
                nbn++;
              }
            }
	  }
	  sort_nblist(x[ii],x,nblist,nbn);
	  if(nblist[0]!=ii){
	    printf("%d %d %d NB error !!!!!!\n",nblist[0],i,nbn);
	  }
/*printf("i %d nbn %d nblist %d %d %d\n",i,nbn,nblist[0],nblist[1],nblist[2]);
*/
	  obtain_individual_density(x,m,nblist,&rho[ii]);
	}  
}

REAL interpolate(mr0,r20,mr1,r21,mlagr)
REAL mr0,mr1;
REAL r20,r21;
REAL mlagr;
{
	REAL r0,r1;
	REAL a,rlagr;  

	r0 = sqrt(r20);
	r1 = sqrt(r21);

	a = pow((mlagr-mr0)/(mr1-mr0),1.0/3.0);
	rlagr =  r0 + (r1-r0)*a;

	return rlagr;
}		

void calculate_center_of_density(n,x,rho,cod)
int n;
REAL x[NMAX][DIM];
REAL rho[NMAX];
REAL cod[DIM];
{
	double tmp1,tmp3[DIM],tmp4[DIM];
	int i,k;

	tmp1 = 0.0;	
	for(k=0;k<DIM;k++) tmp3[k] = 0.0;  
	for(k=0;k<DIM;k++) tmp4[k] = 0.0;  
	for(i=0;i<n;i++){
	  tmp1 += rho[i]*rho[i];
	  for(k=0;k<DIM;k++) tmp3[k] += rho[i]*rho[i]*x[i][k]; 
	}
	for(k=0;k<DIM;k++) cod[k] = tmp3[k]/tmp1;

	printf("radius: center of density %e %e %e\n",cod[0],cod[1],cod[2]);
}

void calculate_distance_from_cod(n,x,r2,cod) 
int n;
REAL x[NMAX][DIM];
REAL r2[NMAX];
REAL cod[DIM];
{
	int i;

	for(i=0;i<n;i++) {
	  r2[i] = (x[i][0]-cod[0])*(x[i][0]-cod[0])
		+ (x[i][1]-cod[1])*(x[i][1]-cod[1])
		+ (x[i][2]-cod[2])*(x[i][2]-cod[2]);
	}
}

void calculate_core_radius(n,r2,rho,rcore)
int n;
REAL r2[NMAX];
REAL rho[NMAX];
REAL *rcore;
{	
	REAL tmp1,tmp2,rcore2,rho2;
	int i;

	tmp1 = 0.0;
	tmp2 = 0.0;
	for(i=0;i<n;i++) {
	  rho2 = rho[i]*rho[i];
	  tmp1 += rho2*r2[i];
	  tmp2 += rho2;
	} 
	rcore2 = tmp1/tmp2;
	*rcore = sqrt(rcore2);
}


void calculate_core_parameter(n,r2,m,v,rcore,mcore,ncore,v2core,rhoc)
int n;
REAL r2[NMAX],*mcore,*v2core,rcore,*rhoc;
REAL m[NMAX];
REAL v[NMAX][DIM];	
int *ncore;
{
	int i;
	REAL rcore2;

	rcore2 = rcore*rcore;
	*mcore = *v2core = 0.0;
	*ncore = 0;
	for(i=0;i<n;i++){
	  if(r2[i]<=rcore2){ 
	    (*mcore) += m[i];
	    (*ncore)++;
	    (*v2core) += v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2];   
	  }
	}
	(*v2core) /= (REAL)(*ncore);
	*rhoc = 3.0*(*mcore)/(4.0*M_PI*rcore2*rcore);

/*	printf("core m %g n %d v2 %g rho %g\n",*mcore,*ncore,*v2core,*rhoc);*/
}

void calculate_lagrangean_radius(n,r2,m,mr,index,rlagr,total_m)
int n;
REAL r2[NMAX];
REAL m[NMAX];
REAL mr[NMAX];
int index[NMAX];
REAL rlagr[20];
REAL total_m;
{
	REAL mlagr[20],totalm;
	int k,i;

	mlagr[0] = 0.01;mlagr[1] = 0.02;mlagr[2] = 0.05;
	mlagr[3] = 0.1;	mlagr[4] = 0.2;	mlagr[5] = 0.3;
	mlagr[6] = 0.5;	mlagr[7] = 0.7;	mlagr[8] = 0.9;
	mlagr[9] = 0.95;mlagr[10] = 0.99;mlagr[11] = 1.0;

	k=0;totalm=total_m;

/*	for(i=0;i<n;i++) totalm += m[i];*/

	for(i=0;i<n;i++){
	  if(i==0){
	    mr[index[i]] = m[index[i]]/ totalm;
	  }else{
	    mr[index[i]] = mr[index[i-1]] + m[index[i]]/ totalm;
	  }
	  while((mr[index[i]] > mlagr[k])&&(k<11)){
	    if(i==0){
	      REAL center = 0.0;
	      rlagr[k] = interpolate(center,center,mr[index[i]],r2[index[i]],mlagr[k]);
	    }else{
	      rlagr[k] = interpolate(mr[index[i-1]],r2[index[i-1]],mr[index[i]],r2[index[i]],mlagr[k]);
	    }
	    k++;
	  }
	}
}

void calculate_central_potential(n,x,m,cod,potc)	
int n;
REAL x[NMAX][DIM];
REAL m[NMAX];
REAL cod[DIM];
REAL *potc;
{
	REAL tmpr2;
	int i;

        *potc = 0.0;
	for(i=0;i<n;i++){
          tmpr2 = (x[i][0]-cod[0])*(x[i][0]-cod[0])
                + (x[i][1]-cod[1])*(x[i][1]-cod[1])
                + (x[i][2]-cod[2])*(x[i][2]-cod[2]);
          *potc += -m[i]/sqrt(tmpr2);
        }
}
        
void velocity_parameter(v,x,cod,v2,vt2,vr2)
REAL v[DIM],x[DIM],cod[DIM];
REAL *v2,*vt2,*vr2;
{
	REAL rdotv,r2;

	rdotv = (x[0]-cod[0])*v[0]+(x[1]-cod[1])*v[1]+(x[2]-cod[2])*v[2];
	r2 = (x[0]-cod[0])*(x[0]-cod[0])+(x[1]-cod[1])*(x[1]-cod[1])+(x[2]-cod[2])*(x[2]-cod[2]);
	*vr2 = rdotv*rdotv/r2;
	*v2 = v[0]*v[0]+v[1]*v[1]+v[2]*v[2];
	*vt2 = *v2 - *vr2;
}

void calculate_lagrangean_shell_parameter(n,x,v,r2,index,rlag,cod,nlag,v2lag,vt2lag,vr2lag)
int n;
REAL x[NMAX][DIM];
REAL v[NMAX][DIM];
REAL r2[NMAX];
int index[NMAX];
REAL rlag[20];
REAL cod[DIM];
int nlag[20];
REAL v2lag[20],vt2lag[20],vr2lag[20];
{
        int i,ii,k;
	REAL v2,vt2,vr2;

	for(k=0;k<20;k++){
	  nlag[k] = 0;
	  v2lag[k] = vt2lag[k] = vr2lag[k] = 0.0;
	}

	k=0;
	for(i=0;i<n;i++){
	  ii = index[i];
	  if((r2[ii]>(rlag[k]*rlag[k]))&&(rlag[k]>0.0))k++;
	  nlag[k]++;
	  velocity_parameter(v[ii],x[ii],cod,&v2,&vt2,&vr2);
	  v2lag[k] += v2;
	  vt2lag[k] += vt2;
	  vr2lag[k] += vr2;
	}
	for(k=0;k<20;k++){
	  if(nlag[k]>0){
	    v2lag[k] /= nlag[k];
	    vt2lag[k] /= nlag[k];
	    vr2lag[k] /= nlag[k];
	  }
	}
}

void calculate_escaper(n,pot,v,m,nesc,eesc)
int n;
REAL pot[NMAX];
REAL v[NMAX][DIM];
REAL m[NMAX];
int *nesc;
REAL *eesc;
{
	int i;
	REAL be,maxbe=-100000;
	(*nesc) = 0;
	(*eesc) = 0.0;

	for(i=0;i<n;i++){
	  be = 0.5*m[i]*(v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2])+m[i]*pot[i];
	  if(maxbe<be)maxbe = be;
	  if(be>0.0){
	   (*nesc)++;
	   (*eesc) += be;
	  }
	}
/*	printf("maxbe %e\n",maxbe);*/
}

void calculate_tidal_parameter(n,x,m,v,rt,nrt,v2rt,vt2rt,vr2rt)
int n;
REAL x[NMAX][DIM],*v2rt,rt,*vt2rt,*vr2rt;
REAL m[NMAX];
REAL v[NMAX][DIM];	
int *nrt;
{
	int i;
	REAL rt2,r2,v2,vt2,vr2,cod[DIM];

        cod[0]= cod[1]= cod[2]= 0.0;
	rt2 = rt*rt;
	*v2rt = *vt2rt = *vr2rt = 0.0;
	*nrt = 0;
	for(i=0;i<n;i++){
          r2 = x[i][0]*x[i][0]+x[i][1]*x[i][1]+x[i][2]*x[i][2];
	  if(r2<rt2){ 
	    (*nrt)++;
            velocity_parameter(v[i],x[i],cod,&v2,&vt2,&vr2);
	    (*v2rt) += v2;
	    (*vt2rt) += vt2;
	    (*vr2rt) += vr2;
	  }
	}
	(*v2rt) /= (REAL)(*nrt);
	(*vt2rt) /= (REAL)(*nrt);
	(*vr2rt) /= (REAL)(*nrt);

/*	printf("rt %g n %d v2 %g\n",rt,*nrt,*v2rt);*/
}

void radius(time,x,v,m,n,dmaindex,prev,pot,radfile)
REAL time;
REAL x[NMAX][DIM];
REAL v[NMAX][DIM];
REAL m[NMAX];
int n;
int dmaindex[NMAX];
struct previous *prev;
REAL pot[NMAX];
char radfile[];
{
	static REAL r2[NMAX];
	int i,k;
	static REAL rho[NMAX];
	REAL rcore;
	REAL mcore,v2core,rhoc,potc;
	static int ncore,index[NMAX],nesc;
	static REAL cod[DIM],eesc;
	static REAL mr[NMAX],rlagr[20],v2lag[20],vt2lag[20],vr2lag[20];
	static int nlag[20];
	FILE *fp1;
	char radfile2[200];
        REAL tm,v2rt,vt2rt,vr2rt;
        int nrt; 

	for(i=0;i<n;i++) index[i] = i;
        tm = (*prev).total_m;
 
#ifdef ONLYGRAPE_NB
#  ifdef USEGRAPE4
        calculate_local_density(x,m,n,rho,v,a,adot,dmaindex,prev);
#  endif
#endif
#ifdef ONLYHOST_NB
        calculate_local_density_on_host(x,m,n,rho,prev,dmaindex);
#endif

	calculate_center_of_density(n,x,rho,cod);

	calculate_distance_from_cod(n,x,r2,cod); 

	calculate_core_radius(n,r2,rho,&rcore);

	calculate_core_parameter(n,r2,m,v,rcore,&mcore,&ncore,&v2core,&rhoc);

	sort_particles(0,n-1,r2,index);

	calculate_lagrangean_radius(n,r2,m,mr,index,rlagr,tm);

	calculate_lagrangean_shell_parameter(n,x,v,r2,index,rlagr,cod,nlag,v2lag,vt2lag,vr2lag);

	calculate_central_potential(n,x,m,cod,&potc);	

	calculate_escaper(n,pot,v,m,&nesc,&eesc);

#ifdef TIDAL_FIELD
	calculate_tidal_parameter(n,x,m,v,(*prev).rt,&nrt,&v2rt,&vt2rt,&vr2rt);
#endif
/******** print out *************************/

	fp1 = fopen(radfile,"a");
	fprintf(fp1,"%g %g %g %g %g ",time,cod[0],cod[1],cod[2],rcore);
	fprintf(fp1,"%g %g %d %g ",rhoc,mcore,ncore,v2core);
	fprintf(fp1,"%g %d %g ",potc,nesc,eesc);
#ifdef TIDAL_FIELD
	fprintf(fp1,"%g %g %d ",(*prev).rt,(*prev).total_m,nrt);
	fprintf(fp1,"%g %g %g ",v2rt,vt2rt,vr2rt);
#endif
        fprintf(fp1,"\n");
 	fclose(fp1);

	strcpy(radfile2,radfile);
	strcat(radfile2,"_lag");	

	fp1 = fopen(radfile2,"a");
	fprintf(fp1,"%g ",time);
	for(k=0;k<12;k++){
	  fprintf(fp1,"%g %d %g %g %g ",rlagr[k],nlag[k],v2lag[k],vt2lag[k],vr2lag[k]);
	}
	fprintf(fp1,"\n");
	fclose(fp1);

	if((*prev).flag==0){
	  printf("[%s]\n",radfile);
	  printf("1: time 2: cod[0] 3: cod[1] 4: cod[2] 5: rcore\n");
	  printf("6: rhoc 7: mcore  8: ncore  9: v2core 10: potc\n");
	  printf("11: nesc(c) 12: eesc(c)\n");
#ifdef TIDAL_FIELD 
	  printf("13: rt 14: totalm 15: nrt\n");
	  printf("16: v2rt 17: vt2rt 18:vr2rt\n");
#endif
	  printf("[%s]\n",radfile2);
	  printf("2-6  : r,n,v2,vt2,vr2 (0-1)\n");
	  printf("7-11 : r,n,v2,vt2,vr2 (1-2)\n");
	  printf("12-16: r,n,v2,vt2,vr2 (2-5)\n");
	  printf("17-21: r,n,v2,vt2,vr2 (5-10)\n");
	  printf("22-26: r,n,v2,vt2,vr2 (10-20)\n");
	  printf("27-31: r,n,v2,vt2,vr2 (20-30)\n");
	  printf("32-36: r,n,v2,vt2,vr2 (30-50)\n");
	  printf("37-41: r,n,v2,vt2,vr2 (50-70)\n");
	  printf("42-46: r,n,v2,vt2,vr2 (70-90)\n");
	  printf("47-51: r,n,v2,vt2,vr2 (90-95)\n");
	  printf("52-56: r,n,v2,vt2,vr2 (95-99)\n");
	  printf("57-61: r,n,v2,vt2,vr2 (99-100)\n");
	}

	for(k=0;k<DIM;k++) (*prev).cod[k] = cod[k];
	(*prev).rc = rcore;
	if((*prev).flag==0) (*prev).flag = 1;	
}

/*********************************************************************
	make different mass system from equal mass system. 
	assume no-correlation between position and particle number.
	sorting in order mass and quantatization for GRAPE
	dN prop (m^alpha)*dm
*********************************************************************/

/********** heating ********************/
#ifdef BINARY_HEATING
/*	for(i=0;i<n;i++){
	  double vel2,rho2v,crit;
	  crit = 1.0e10;
	  vel2 = v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2];
	  rho2v = rho[i]*rho[i]/sqrt(vel2);
	  if(rho2v>crit){
	   printf("heating time %g i %d rho %g v2 %g ",time,i,rho[i],vel2);
	   for(d=0;d<DIM;d++) v[i][d] *= sqrt(2.0);
	   vel2 = v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2];
	   printf("-> %g\n",vel2); 
	  }
	}
*/
/*	if(rho0ch>1.0e4){
	  int nn=0;
          for(i=0;i<n;i++){
            if(r2[i]<=rcore2){
	      for(d=0;d<DIM;d++) v[i][d] *= 2.0;
	      nn++;
            }
          }
	  printf("heating in core: rho %g n %d\n",rho0ch,nn);
	}
*/
	inc = 0;
	*eadd = 0.0;
	for(i=0;i<n;i++){
	  double vel2,rho2v,crit=1.0e-10,ienergy;
	  if(r2[i]<rcore2){
	    double prevel2;
	      vel2 = v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2];
	    prevel2 = vel2;	
	      rho2v = rho[i]*rho[i]/sqrt(vel2);
	      ienergy = crit*rho2v;
	      for(d=0;d<DIM;d++){
	        if(v[i][d]>0.0){
	          v[i][d] += sqrt(ienergy);
	        }else{
	          v[i][d] -= sqrt(ienergy);
	        }	   
	      }
	      printf("heating: time %g i %d rho %g v2 %g ",time,i,rho[i],vel2);
	      vel2 = v[i][0]*v[i][0]+v[i][1]*v[i][1]+v[i][2]*v[i][2];
	      printf("-> %g\n",vel2); 
	      *eadd += 0.5*m[i]*(vel2-prevel2);
	  }
	}
	printf("eadd = %e\n",*eadd); 
#endif

double double_rand()
{
	double ranx;
	int k;
/*
	k=rand();
        ranx = 0.5*(1.0+(k-1073741824)/1073741824.0);
	return ranx;
*/
        return drand48();
}

void mass_spectrum(m,alpha,maxm,n)
REAL m[NMAX];
REAL alpha;
REAL maxm;
int n;
{
	REAL pmax,trial,nm,total_mass=0.0,immean,tmpm=0.0;
	int i; 	

	if(alpha!=0.0){
	  if(alpha>0.0){
	    pmax=pow(maxm,alpha);
	  }else{
	    pmax=1.0;
	  }
	  for(i=0;i<n;i++){
	    do{
	      m[i]= double_rand()*(maxm-1.0)+1.0;
	      nm = pow(m[i],alpha); 
	      trial = double_rand()*pmax;
/*printf("i %d nm %e trial %e\n",i,nm,trial);*/
	    }while(nm<trial);
	  }
	}
	for(i=0;i<n;i++) total_mass += m[i];
	for(i=0;i<n;i++) m[i] /= total_mass;
	sort_value(0,n-1,m);
/*	for(i=0;i<n;i++) m[i] = ((REAL)anint(m[i]/m[0]*32.0))*m[0]/32.0;*/

	for(i=0;tmpm<0.1;i++){
	  tmpm += m[(n-1)-i];
	}  
	immean = tmpm/(double)i;
	printf("initial mean mass %e\n",immean);

/*	if(1){
	  REAL mrank;
	  int mnum;
	  mrank = m[0];
	  mnum = 1;
	  for(i=1;i<n;i++){
	    if(mrank==m[i]){
	      mnum++;
	    }else{
	      printf("%e %d \n",m[i-1],mnum);
	      mrank = m[i];
	      mnum = 1;		  
	    }
	  }
	  printf("%e %d \n",m[n-1],mnum);
	}
*/
i=0;
printf("%i %e\n",i,m[0]);
for(i=1;i<n;i+=1000)printf("%i %e\n",i,m[i]);
printf("%i %e\n",n-1,m[n-1]);
}






