#! /bin/csh

if (${#argv} < 1) then
  echo ''
  echo Link device driver of PCI Host Interface Board \(PHIB\) to kernel image.
  echo usage: $0 module_name
  echo ''
  exit (1)
endif 

set module = $1
set device = $1
set group = "wheel"
set mode = "666"

echo ''
echo -- install module ${module} --
echo ''
set npcimem = `grep "9080" /proc/pci | grep "PLX" | wc | awk '{print $1}'`
echo "${npcimem} PCI host interface board(s) (PHIB) found."
echo ''
echo rm -f /dev/${device}\[0-9\]
rm -f /dev/${device}[0-9]
echo ''
echo /sbin/insmod -f ${module}.o
/sbin/insmod -f ${module}.o

set major = `cat /proc/devices | awk '$2=="'${module}'"{print $1}'`

set i = 0
while (${i} < ${npcimem})
  echo mknod /dev/${device}${i} c ${major} ${i}
  mknod /dev/${device}${i} c ${major} ${i}
  @ i++
end

echo ''
echo chgrp ${group} /dev/${device}?
chgrp ${group} /dev/${device}?
echo ''
echo chmod ${mode} /dev/${device}?
chmod ${mode} /dev/${device}?
echo ''
echo ls -l /dev/${device}?
ls -l /dev/${device}?
echo ''
echo -- done --
echo ''
