#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include "memmap.h"

#define NPCIMEM 16

static unsigned int *phib[NPCIMEM];
static unsigned int *resbufp[NPCIMEM];
static unsigned long resbufpa[NPCIMEM]; 
static unsigned int off[NPCIMEM];
static int dmainit[NPCIMEM]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

/* lock file should permit everyone to be accessed with O_WRONLY */
static char g5lockfile[1][255];
static int lockfd[1];
static int fd_opened[1];

void lock_grape(int devid)
{
  static char buf[256];

  /*  sprintf(g5lockfile[0], "/tmp/phib_g6a");*/
  sprintf(g5lockfile[0], "/dev/pcimem0");  

  if (!fd_opened[devid])
    {
      lockfd[devid] = open(g5lockfile[devid], O_WRONLY);
      if (lockfd[devid] == -1 && errno == ENOENT)
	{
	  sprintf(buf, "touch %s; chmod a+w %s",
		  g5lockfile[devid],
		  g5lockfile[devid]);
	  system(buf);
	  lockfd[devid] = open(g5lockfile[devid], O_WRONLY);
	}
    }
  fd_opened[devid] = 1;
  if (lockfd[devid] == -1)
    {
      sprintf(buf, "failed to open %s.\n", g5lockfile[devid]);
      perror(buf);
      exit (2);
    }

  if (lockf(lockfd[devid], F_TLOCK, getpagesize()))
    {
      if ((errno == EACCES) || (errno == EAGAIN)) /* JCL 15 May 2000 */
	{
	  fprintf(stderr,"Someone is using GRAPE-6A, sleep...\n", devid);
	  if (lockf(lockfd[devid], F_LOCK, getpagesize()))
	    {
	      perror("LOCKF failed");
	      exit (2);
	    }
	              else
			{
			  fprintf(stderr,"Got GRAPE-6A...\n");
			}
	}
              else
		{
		  perror("LOCKF failed");
		  exit (2);
		}
    }
  if (lockf(lockfd[devid], F_LOCK, getpagesize()))
    {
      perror("LOCKF failed");
      exit (2);
    }
}

void unlock_grape(int devid)
{
  if (lockf(lockfd[devid], F_ULOCK, getpagesize()))
    {
      fprintf(stderr,"LOCKF (unlock) failed with %d\n", errno);
      exit (2);
    }
}
		
int g6_npipes()
{
    return 48;
}

int g6_npipes_()
{
  return g6_npipes();
}

int g6_get_number_of_pipelines_()
{
    return 48;
}

int g6_get_number_of_pipelines()
{
    return 48;
}

void g6_reset(int devid)
{
    int adr,data;

    adr = 0xc00;
    TBmemWrite(devid, adr, data);
}

void g6_reset_(int *devid)
{
  g6_reset(*devid);
}

void g6_focnt_reset(int devid)
{
    int adr,data;

    adr = 0x1000;
    TBmemWrite(devid, adr, data);
}

void g6_init(int devid)
{
  int adr,data;
  
  while (-1 == (long int)(phib[devid] = TBopen(devid))){
    sleep(1);
  }

  /*  printf("local register(conf_done) %0x\n",TBregRead(devid, 0x6c));*/

  /* send pll control */
  adr = 0x1400;
  data = 0x0000; 
  TBmemWrite(devid, adr, data);
  usleep(100);

  g6_reset(devid);
  g6_focnt_reset(devid);
}

/* send_fpga_data
   address: 0x20 for g6a
   data:
      LSB:  dclk
        1:  data0
        2: nconfig
   file format: ttf (comma-separatted decimal byte data)
   bit order: should send lsb first
 */

int send_fpga_data(int devid,
                   char * file_name)
{
   FILE *fopen(),*fin;
   int adr,data0,dclk,nconf,i,datacount,data;

   fin = fopen(file_name,"r");
   adr = 0x800;

   data0 = 0;
   dclk = 0;
   nconf = 1;
   TBmemWrite(devid, adr, ((nconf<<2) | (data0<<1) | dclk));
   usleep(8);

   nconf = 0;
   TBmemWrite(devid, adr, ((nconf<<2) | (data0<<1) | dclk));

   nconf = 1;
   TBmemWrite(devid, adr, ((nconf<<2) | (data0<<1) | dclk));
   usleep(40);

   datacount = 0;
   while(fscanf(fin, "%d,",&data)!=EOF){
     for(i=0;i<8;i++){
       int ii;
       data0 = 0x1 & (data>>i);
       dclk = 0;
       TBmemWrite(devid, adr, ((nconf<<2) | (data0<<1) | dclk));
       dclk = 1;
       TBmemWrite(devid, adr, ((nconf<<2) | (data0<<1) | dclk));
     }
     datacount++;
     if ((datacount & 0x3fff) == 0)fprintf(stderr,"datacount = %x\n", datacount);
   }

   fclose(fin);

   g6_reset(devid);
   g6_focnt_reset(devid);
   
   return 1;
}

void g6_send_fpga_data(int devid,
                   char * file_name)
{
  (void)send_fpga_data(devid,file_name);
}

void g6_set_ipdata(
int devid,
unsigned int ipdata[])
{
  int i,adr;
  unsigned int nword,size;
  static int ii=0;
  
  nword = ipdata[1];

  adr = 0x0;
  for(i=0;i<(nword+2);i++){
    int ii;
    /*    printf("ipdata %d %x\n",i,ipdata[i]);*/
    /*    TBmemWrite(devid, adr, ipdata[i]);*/
    phib[devid][adr+(i%1024)] = ipdata[i];
  }

}

void g6_set_ipdata_dma(
int devid,
unsigned int ipdata[])
{
  int i,adr;
  unsigned int nword,size,sum;
  static int ii=0;
  
  nword = ipdata[1];

  if(dmainit[devid]==1){ 
    TBgetDmaInfo(devid, &(resbufpa[devid]), &(resbufp[devid]));
    dmainit[devid] = 0;
  }

  for(i=0;i<(nword+2);i++){
    ((unsigned int *)resbufp[devid])[i] = ipdata[i];
  }

  off[devid] = 0x0;
  size = nword+2;

  TBregWrite(devid, 0x84, resbufpa[devid]); /* start address in PCI space */
  TBregWrite(devid, 0x88, off[devid]*4); /* start address in local space */
  TBregWrite(devid, 0x8c, size*4); /* size in byte */
  TBregWrite(devid, 0x90, 0x00000000); /* direction (0x0:PCI --> local) */
  TBregWrite(devid, 0xa8, 0x00000003); /* start DMA */
  do{
    /*    for(ii=0;ii<1000;ii++) sum+=ii;*/
  }while (!(TBregRead(devid, 0xa8) & 0x10));

}

#if 0 
/**  old version **/
int g6_get_fodata(
int devid,
unsigned int nword,
unsigned int fodata[])
{
  int i,focnt,focnt0;
  int adr,size;
  int ii,sum;
  
  adr = 0x800;
  do{
    focnt = TBmemRead(devid, adr);
    /*     printf("focnt %d %x nword %d\n",focnt,focnt,nword); */
  }while(focnt<nword);

  if((0x80000000&focnt)!=0) printf("parity error %x\n",focnt);

#if 0
  adr = 0x0;   
  for(i=0;i<focnt;i++){
    adr = 0x0 + i;
    fodata[i] = TBmemRead(devid, adr);
    /*printf("fodata %d %x\n",i,fodata[i]);*/
  }
#endif

#if 1
  off[devid] = 0x0;
  size = focnt;

  if(dmainit[devid]==1){ 
    TBgetDmaInfo(devid, &(resbufpa[devid]), &(resbufp[devid]));
    dmainit[devid] = 0;
  }
  TBregWrite(devid, 0x84, resbufpa[devid]); /* start address in PCI space */
  TBregWrite(devid, 0x88, off[devid]*4); /* start address in local space */
  TBregWrite(devid, 0x8c, size*4); /* size in byte */
  TBregWrite(devid, 0x90, 0x00000008); /* direction (0x8:PCI <-- local) */
  TBregWrite(devid, 0xa8, 0x00000003); /* start DMA */
  do{
    /*    for(ii=0;ii<1000;ii++) sum+=ii;*/
  }while (!(TBregRead(devid, 0xa8) & 0x10));

  for(i=0;i<size;i++){
    fodata[i] = ((unsigned int *)resbufp[devid])[i];
  }
#endif
  
  g6_focnt_reset(devid);
  g6_reset(devid);

  return focnt;
}
#endif

#if 1 
/** new version **/
int g6_get_fodata(
int devid,
unsigned int nword,
unsigned int fodata[])
{
  int i,focnt,focnt0;
  int adr,size;
  int ii,sum;
  int pre_focnt;

  if(dmainit[devid]==1){ 
    TBgetDmaInfo(devid, &(resbufpa[devid]), &(resbufp[devid]));
    dmainit[devid] = 0;
  }

  adr = 0x800;
  pre_focnt = 0;
  do{
    do{
      focnt = TBmemRead(devid, adr);
      /*      printf("focnt %d %x nword %d pre_focnt %d\n",focnt,focnt,nword,pre_focnt); */
    }while((focnt<50)&&(focnt<nword));

    off[devid] = 0x0 + pre_focnt;
    size = focnt - pre_focnt;

    TBregWrite(devid, 0x84, resbufpa[devid]); /* start address in PCI space */
    TBregWrite(devid, 0x88, off[devid]*4); /* start address in local space */
    TBregWrite(devid, 0x8c, size*4); /* size in byte */
    TBregWrite(devid, 0x90, 0x00000008); /* direction (0x8:PCI <-- local) */
    TBregWrite(devid, 0xa8, 0x00000003); /* start DMA */
    do{
      /*    for(ii=0;ii<1000;ii++) sum+=ii;*/
    }while (!(TBregRead(devid, 0xa8) & 0x10));

    for(i=0;i<size;i++){
      fodata[i+pre_focnt] = ((unsigned int *)resbufp[devid])[i];
    }
    pre_focnt = focnt;
  }while(focnt<nword);

  if((0x80000000&focnt)!=0) printf("parity error %x\n",focnt);

  g6_focnt_reset(devid);
  g6_reset(devid);

  return focnt;
}

#endif

int g6_get_fodata_nb(
unsigned int fodata[])
{
  int i,focnt,focnt0,focnt00;
  int adr,size;
  int ii,sum,devid=0;
  
  adr = 0x800;
  focnt0 = focnt00 = 0;
  do{
    focnt = TBmemRead(devid, adr);
    focnt00 = focnt0;
    focnt0  = focnt;
    /*    printf("focnt %d %d %d\n",focnt,focnt0,focnt00);*/
  }while((focnt<3)||(focnt!=focnt00));

  if((0x80000000&focnt)!=0) printf("parity error %x\n",focnt);

  off[devid] = 0x0;
  size = focnt;

  if(dmainit[devid]==1){ 
    TBgetDmaInfo(devid, &(resbufpa[devid]), &(resbufp[devid]));
    dmainit[devid] = 0;
  }
  TBregWrite(devid, 0x84, resbufpa[devid]); /* start address in PCI space */
  TBregWrite(devid, 0x88, off[devid]*4); /* start address in local space */
  TBregWrite(devid, 0x8c, size*4); /* size in byte */
  TBregWrite(devid, 0x90, 0x00000008); /* direction (0x8:PCI <-- local) */
  TBregWrite(devid, 0xa8, 0x00000003); /* start DMA */
  do{
    /*    for(ii=0;ii<1000;ii++) sum+=ii;*/
  }while (!(TBregRead(devid, 0xa8) & 0x10));

  for(i=0;i<size;i++){
    fodata[i] = ((unsigned int *)resbufp[devid])[i];
  }
  
  g6_focnt_reset(devid);
  g6_reset(devid);

  return focnt;
}

void g6_close(int devid)
{
  TBterm(devid);
  unlock_grape(0);
}

void g6_set_jpdata(
int devid,
unsigned int nword,
unsigned int jpdata[])
{
  int i,adr,size;

  adr = 0x400;
  if(nword>1024){
    for(i=0;i<nword;i++){
      /*printf("jpdata %d %x\n",i,jpdata[i]);*/
      /*    TBmemWrite(devid, adr, jpdata[i]);*/
      phib[devid][adr+(i%1024)] = jpdata[i];
    }
  }else{
    for(i=0;i<nword;i++){
      phib[devid][adr+i] = jpdata[i];
    }
  }    
}

void g6_set_jpdata_dma(
int devid,
unsigned int nword,
unsigned int jpdata[])
{
  int i,adr,size,ii;

  if(dmainit[devid]==1){ 
    TBgetDmaInfo(devid, &(resbufpa[devid]), &(resbufp[devid]));
    dmainit[devid] = 0;
  }

  for(i=0;i<nword;i++){
    ((unsigned int *)resbufp[devid])[i] = jpdata[i];
  }

  off[devid] = 0x400;
  size = nword;

  TBregWrite(devid, 0x84, resbufpa[devid]); /* start address in PCI space */
  TBregWrite(devid, 0x88, off[devid]*4); /* start address in local space */
  TBregWrite(devid, 0x8c, size*4); /* size in byte */
  TBregWrite(devid, 0x90, 0x00000000); /* direction (0x0:PCI --> local) */
  TBregWrite(devid, 0xa8, 0x00000003); /* start DMA */
  do{
    /*    for(ii=0;ii<1000;ii++) sum+=ii;*/
  }while (!(TBregRead(devid, 0xa8) & 0x10));

}




