#    Installation Program for GRAPE-6A
#         by Toshiyuki Fukushige
#
echo "********** Main Menu ***********"
echo 1. Compiling the device driver
echo 2. Compiling libraries and sample program
echo 3. Installing the device driver '(need to be a superuser)'
echo 4. Configuring the internal FPGAs
echo 0. Exit
echo enter menu number '(1-4, or 0)':
set ans = $<
if ($ans == 0) then
  echo exit
  exit 0
else if ($ans == 1) then  
  echo "How many GRAPE-6A card do you want to install ?  (Enter number)"
  set ans1 = $<
  if($ans1 == 1) then 
    echo "What version is your linux kernel ?"
    echo "1. Linux 2.4.20-8  (Redhat 9.0)"
    echo "2. Linux 2.4.18-14 (Redhat 8.0)"
    echo "3. Linux 2.4.7-10  (Redhat 7.2)"
    echo "4. Linux 2.4.18 (slackware 8.1)"
    echo "5. Linux 2.6.5 (Fedora Core 2, x86_64)"
    echo "**** At present, only those two versions are tested."
    echo "**** When you want to use other version, please try either or both. "
    echo "**** If you are successful or if not, please let me know. "
    echo "**** Such information will help other users. "
    echo "(1-5)" 
    set ans2 = $<
    echo "******* Compiling device driver *********"
    rm -f pcimem
    if($ans2 == 5) then  
      ln -s pcimem.26 pcimem
      cd pcimem
      make clean
      make
    else
    ln -s pcimem.24 pcimem
    cd pcimem
    if($ans2 == 1) then  
      cp pcimem.c.2.4.20 pcimem.c
      cp Makefile.2.4.20 Makefile
      make clean
      make
      cd ..
    else if($ans2 == 2) then         
      cp pcimem.c.org pcimem.c
      cp Makefile.2.4.20 Makefile
      make clean
      make
      cd ..
    else if($ans2 == 3) then         
      cp pcimem.c.org pcimem.c
      cp Makefile.org Makefile
      make clean
      make
      cd ..
    else if($ans2 == 4) then         
      cp pcimem.c.org pcimem.c
      cp Makefile.slack.8.1 Makefile
      make clean
      make
      cd ..
    else
    endif
    endif    
  else
    echo "   Sorry, multi card configuration is not supported."
    echo "   Please ask to the auther."
  endif
else if ($ans == 2) then 
  echo "******* Compiling libraries *********"
  cd lib
  make clean    
  make libg6a.a
  make libg65.a
  make g6aconfig
  echo "******* Compiling sample programs *********"
  cd ../s8
  make clean
  make s8
  cd ../s9
  make clean
  make s9
  make s9nb
  cd ..
else if ($ans == 3) then
  echo Here, you need to be a superuser.
  echo "Are you OK to proceed ? (yes or no)"
  set ans2 = $<
  if ($ans2 == "yes") then
    echo "****** Installing the device driver *******"
    cd pcimem
    make installmodule
    cd ..
  else
    echo exit
  endif
else if ($ans == 4) then  
  echo "****** Configuring the internal FPGA ******"
  cd lib
  ./g6aconfig
  cd ..
endif
