#! /bin/csh

if (${#argv} < 1) then
  echo ''
  echo Link device driver of Host Interface Bridge \(HIB\) to kernel image.
  echo usage: $0 module_name vendorID:deviceID
  echo ''
  exit (1)
endif 

set module = $1
set device = $1
set group = "wheel"
set mode = "666"

echo ''
echo -- install module ${module} --

if (-x /sbin/lspci) then
    set lspci = /sbin/lspci
else
    if (-x `which lspci`) then
        set lspci = `which lspci`
    else
      echo command \'lspci\' not found.
      echo you may need to set PATH so that it includes
      echo the directory where lspci is located.
      goto LABEL_EXIT
    endif
endif

# this works with GNU awk only.
#
# awk '/\.vendorid/{vid = $3}; \
#     /\.deviceid/{did = $3; printf("%04x %04x\n", strtonum(vid), strtonum(did))}' \
#     $1.h > /tmp/pciids$$

awk '/\.vendorid/{vid = $3}; \
     /\.deviceid/{did = $3; \
         gsub("0x", "", vid); gsub(",", "", vid);\
         gsub("0x", "", did); gsub(",", "", did);\
          printf("%s %s\n", vid, did)}' \
     $1.h > /tmp/pciids$$

set ids = `awk '{print $1":"$2}' /tmp/pciids$$`
set i = 1
set ndriver = 0

while (${i} <= $#ids)
  (${lspci} -d $ids[$i] | wc | awk '{print $1}' > /tmp/tmp$$) >& /dev/null
  set n0 = `cat /tmp/tmp$$`
  if ($n0 == 0) then
    echo "  found no  HIB  with pci id $ids[$i]"
  else if ($n0 == 1) then
    echo "  found   $n0 HIB  with pci id $ids[$i]"
  else
    echo "  found   $n0 HIBs with pci id $ids[$i]"
  endif
  @ ndriver += `cat /tmp/tmp$$`
  @ i++
end
\rm -f /tmp/tmp$$

if (${ndriver} == 0) then
  echo "${module}: No HIB found."
  goto LABEL_EXIT
endif

if (${ndriver} == 1) then
  echo "${module}: found ${ndriver} HIB in total."
else
  echo "${module}: found ${ndriver} HIBs in total."
endif

# echo ${ndriver} > .ndriver
# sed 's/#define\s+NHIB\s+[0-9]+/#define NHIB '${ndriver}'/' $1.h > /tmp/tmp$$
# /bin/mv -f /tmp/tmp$$ $1.h

echo ''
echo rm -f /dev/${device}\[0-9\]
rm -f /dev/${device}[0-9] >& /dev/null
echo ''
echo /sbin/insmod -f ${module}.ko
/sbin/insmod -f ${module}.ko

set major = `cat /proc/devices | awk '$2=="'${module}'"{print $1}' | tail -1`

set i = 0
while (${i} < ${ndriver})
  echo mknod /dev/${device}${i} c ${major} ${i}
  mknod /dev/${device}${i} c ${major} ${i}
  @ i++
end

echo ''
echo chgrp ${group} /dev/${device}*
chgrp ${group} /dev/${device}*
echo ''
echo chmod ${mode} /dev/${device}*
chmod ${mode} /dev/${device}*

LABEL_EXIT:
ls -l /dev/${device}*
echo -- done --
echo ''
